/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.actions;

import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.TestFinder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public final class RubyTestFinder
implements TestFinder {
    public PsiElement findSourceElement(@NotNull PsiElement from) {
        if (from == null) {
            RubyTestFinder.$$$reportNull$$$0(0);
        }
        return (PsiElement)ObjectUtils.doIfNotNull((Object)from.getContainingFile(), file -> {
            FileViewProvider provider = file.getViewProvider();
            if (provider instanceof TemplateLanguageFileViewProvider) {
                return file;
            }
            return provider.getPsi((Language)RubyLanguage.INSTANCE);
        });
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        if (element == null) {
            RubyTestFinder.$$$reportNull$$$0(1);
        }
        if (element.getLanguage() != RubyLanguage.INSTANCE) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyTestFinder.$$$reportNull$$$0(2);
            }
            return list;
        }
        Project project = element.getProject();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyTestFinder.$$$reportNull$$$0(3);
            }
            return list;
        }
        String filename = file.getName();
        ArrayList<TestsLocationProviderUtil.FileInfo> candidates = new ArrayList<TestsLocationProviderUtil.FileInfo>();
        for (String suffix : List.of("_spec.rb", "_test.rb")) {
            if (!filename.endsWith(suffix)) continue;
            TestsLocationProviderUtil.collectCandidates((Project)project, (String)filename.replaceFirst(suffix, ".rb"), (boolean)false).stream().filter(it -> !TestSourcesFilter.isTestSources((VirtualFile)it.getFile(), (Project)project)).forEach(candidates::add);
        }
        return RubyTestFinder.sortCandidatesByProximity(project, candidates, file);
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        if (element == null) {
            RubyTestFinder.$$$reportNull$$$0(4);
        }
        if (element.getLanguage() != RubyLanguage.INSTANCE) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyTestFinder.$$$reportNull$$$0(5);
            }
            return list;
        }
        Project project = element.getProject();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file == null || TestSourcesFilter.isTestSources((VirtualFile)file, (Project)project)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyTestFinder.$$$reportNull$$$0(6);
            }
            return list;
        }
        String name = file.getNameWithoutExtension();
        ArrayList<TestsLocationProviderUtil.FileInfo> candidates = new ArrayList<TestsLocationProviderUtil.FileInfo>();
        for (String suffix : List.of("_spec.rb", "_test.rb")) {
            TestsLocationProviderUtil.collectCandidates((Project)project, (String)(name + suffix), (boolean)false).stream().filter(it -> TestSourcesFilter.isTestSources((VirtualFile)it.getFile(), (Project)project)).forEach(candidates::add);
        }
        return RubyTestFinder.sortCandidatesByProximity(project, candidates, file);
    }

    public boolean isTest(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            RubyTestFinder.$$$reportNull$$$0(7);
        }
        return RSpecUtil.isFileWithRSpecTestFileName(file = PsiUtilCore.getVirtualFile((PsiElement)element)) || TestUnitUtil.isFileWithValidTestUnitFileName(file, false);
    }

    public boolean navigateToTestImmediately(@NotNull PsiElement element) {
        if (element == null) {
            RubyTestFinder.$$$reportNull$$$0(8);
        }
        return this.isTest(element);
    }

    @NotNull
    private static List<PsiElement> sortCandidatesByProximity(@NotNull Project project, @NotNull List<TestsLocationProviderUtil.FileInfo> candidates, @NotNull VirtualFile file) {
        VirtualFile parent;
        if (project == null) {
            RubyTestFinder.$$$reportNull$$$0(9);
        }
        if (candidates == null) {
            RubyTestFinder.$$$reportNull$$$0(10);
        }
        if (file == null) {
            RubyTestFinder.$$$reportNull$$$0(11);
        }
        List folders = (parent = file.getParent()) != null ? ContainerUtil.filter((Collection)ContainerUtil.reverse(List.of(parent.getPath().split("/"))), it -> !it.isBlank()) : Collections.emptyList();
        PsiManager manager = PsiManager.getInstance((Project)project);
        List<PsiElement> list = TestsLocationProviderUtil.findFilesClosestToTarget((List)folders, candidates, (int)0).stream().mapMulti((it, consumer) -> {
            PsiFile psiFile = manager.findFile(it);
            if (psiFile != null) {
                consumer.accept(psiFile);
            }
        }).toList();
        if (list == null) {
            RubyTestFinder.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/actions/RubyTestFinder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/actions/RubyTestFinder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sortCandidatesByProximity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigateToTestImmediately";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sortCandidatesByProximity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 12 -> new IllegalStateException(string);
        };
    }
}

