/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;

public enum SupportedTestFramework {
    TEST_UNIT(":test_unit", RBundle.message((String)"test.frameworks.names.testunit"), "RubyTestUnit", true),
    SHOULDA(":shoulda", RBundle.message((String)"test.frameworks.names.shoulda"), "Shoulda", false),
    RSPEC(":rspec", RBundle.message((String)"test.frameworks.names.rspec"), "RSpec", true),
    CUCUMBER(":cucumber", RBundle.message((String)"test.frameworks.names.cucumber"), "Cucumber", false),
    RAKE("rake", "rake", "Rake", false);

    private static final Logger LOG;
    private final String myFrameworkId;
    private final String myPresentableName;
    private final String myFrameworkName;
    private final boolean myIdBasedTestTree;

    private SupportedTestFramework(@NotNull String frameworkId, String presentableName, String frameworkName, boolean idBasedTestTree) {
        if (presentableName == null) {
            SupportedTestFramework.$$$reportNull$$$0(0);
        }
        if (frameworkName == null) {
            SupportedTestFramework.$$$reportNull$$$0(1);
        }
        this.myFrameworkId = frameworkId;
        this.myPresentableName = presentableName;
        this.myFrameworkName = frameworkName;
        this.myIdBasedTestTree = idBasedTestTree;
    }

    public String getFrameworkId() {
        return this.myFrameworkId;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    public String getFrameworkName() {
        return this.myFrameworkName;
    }

    public boolean isIdBasedTestTree() {
        return this.myIdBasedTestTree;
    }

    public static String serialize(List<SupportedTestFramework> frameworks) {
        StringBuilder buff = new StringBuilder();
        for (SupportedTestFramework framework : frameworks) {
            buff.append(framework.getFrameworkId()).append(' ');
        }
        return buff.toString();
    }

    public static List<SupportedTestFramework> deserialize(String text) {
        ArrayList<SupportedTestFramework> frameworks = new ArrayList<SupportedTestFramework>();
        StringTokenizer tk = new StringTokenizer(text, " ");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            boolean notFound = true;
            for (SupportedTestFramework framework : SupportedTestFramework.values()) {
                if (!framework.getFrameworkId().equals(token)) continue;
                frameworks.add(framework);
                notFound = false;
                break;
            }
            if (!notFound) continue;
            LOG.warn("Unexpected test framework id - " + token);
        }
        return frameworks;
    }

    public static boolean containsBddFramework(@NotNull List<SupportedTestFramework> frameworks) {
        if (frameworks == null) {
            SupportedTestFramework.$$$reportNull$$$0(2);
        }
        for (SupportedTestFramework framework : frameworks) {
            if (framework != CUCUMBER && framework != RSPEC) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTestUnitBasedFramework(@NotNull List<SupportedTestFramework> frameworks) {
        if (frameworks == null) {
            SupportedTestFramework.$$$reportNull$$$0(3);
        }
        for (SupportedTestFramework framework : frameworks) {
            if (framework != TEST_UNIT && framework != SHOULDA) continue;
            return true;
        }
        return false;
    }

    static {
        LOG = Logger.getInstance(SupportedTestFramework.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworks";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/SupportedTestFramework";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsBddFramework";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "containsTestUnitBasedFramework";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

