/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySearchScopeService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public class RubyQualifiedNameUrlProvider
implements SMTestLocator {
    public static final String RUBY_QUALIF_NAME_PROTOCOL_ID = "ruby_qn";
    public static final String RUBY_MINITEST_PROTOCOL_ID = "ruby_minitest_qn";
    public static final RubyQualifiedNameUrlProvider INSTANCE = new RubyQualifiedNameUrlProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        String methodName;
        FQN classFQNList;
        if (protocol == null) {
            RubyQualifiedNameUrlProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            RubyQualifiedNameUrlProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            RubyQualifiedNameUrlProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            RubyQualifiedNameUrlProvider.$$$reportNull$$$0(3);
        }
        if (!RUBY_QUALIF_NAME_PROTOCOL_ID.equals(protocol) && !RUBY_MINITEST_PROTOCOL_ID.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                RubyQualifiedNameUrlProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        int classNameSeparatorPos = path.indexOf(46);
        if (classNameSeparatorPos == -1) {
            classFQNList = FQN.Builder.fromString((String)path);
            methodName = null;
        } else {
            String className = path.substring(0, classNameSeparatorPos);
            classFQNList = FQN.Builder.fromString((String)className);
            methodName = path.substring(classNameSeparatorPos + 1);
        }
        if (classFQNList == FQN.INVALID) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                RubyQualifiedNameUrlProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        String classOrModuleName = classFQNList.getShortName();
        String classOrModuleFullQualifiedName = classFQNList.getFullPath();
        ArrayList<Location> locations = new ArrayList<Location>();
        Collection<RElementWithFQN> elements = RubyQualifiedNameUrlProvider.getClassesAndModulesForName(project, classOrModuleName);
        for (RElementWithFQN container : elements) {
            ProgressManager.checkCanceled();
            if (!(container instanceof RClass)) continue;
            RubyQualifiedNameUrlProvider.processRClass(project, (RContainer)((RClass)container), classOrModuleFullQualifiedName, methodName, locations);
        }
        ArrayList<Location> arrayList = locations;
        if (arrayList == null) {
            RubyQualifiedNameUrlProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void processRClass(Project project, RContainer container, @NotNull String classOrModuleFullQualifiedName, @Nullable String methodName, List<Location> locations) {
        Symbol testOrSuiteSymbol;
        Symbol testOrSuiteClassSymbol;
        if (classOrModuleFullQualifiedName == null) {
            RubyQualifiedNameUrlProvider.$$$reportNull$$$0(7);
        }
        if ((testOrSuiteClassSymbol = SymbolUtil.findConstantByFQN(project, Type.CLASS, classOrModuleFullQualifiedName, (PsiElement)container)) == null) {
            return;
        }
        if (methodName != null) {
            Symbol methodSymbol = RubyQualifiedNameUrlProvider.findRMethodSymbolForTest(testOrSuiteClassSymbol, methodName);
            if (methodSymbol == null) {
                PsiElement lastTestClassDeclaration = testOrSuiteClassSymbol.getPsiElement();
                if (lastTestClassDeclaration instanceof RClass) {
                    RClass testClass = (RClass)lastTestClassDeclaration;
                    RPsiElement testClosure = TestUnitUtil.findValidTestClosure(methodName, testClass);
                    if (testClosure != null) {
                        locations.add(PsiLocation.fromPsiElement((Project)project, (PsiElement)testClosure));
                        return;
                    }
                    RPsiElement shouldaClosure = ShouldaUtil.findValidTestClosure(methodName, testClass);
                    if (shouldaClosure != null) {
                        locations.add(PsiLocation.fromPsiElement((Project)project, (PsiElement)shouldaClosure));
                        return;
                    }
                }
                testOrSuiteSymbol = testOrSuiteClassSymbol;
            } else {
                testOrSuiteSymbol = methodSymbol;
            }
        } else {
            testOrSuiteSymbol = testOrSuiteClassSymbol;
        }
        for (PsiElement psiElement : testOrSuiteSymbol.getAllDeclarations((PsiElement)container)) {
            locations.add(PsiLocation.fromPsiElement((Project)project, (PsiElement)psiElement));
        }
    }

    @Nullable
    private static Symbol findRMethodSymbolForTest(@NotNull Symbol testOrSuiteClassSymbol, @NotNull String methodName) {
        if (testOrSuiteClassSymbol == null) {
            RubyQualifiedNameUrlProvider.$$$reportNull$$$0(8);
        }
        if (methodName == null) {
            RubyQualifiedNameUrlProvider.$$$reportNull$$$0(9);
        }
        return SymbolUtil.findMethod(testOrSuiteClassSymbol, methodName, Type.INSTANCE_METHOD.asSet(), testOrSuiteClassSymbol.getPsiElement());
    }

    private static Collection<RElementWithFQN> getClassesAndModulesForName(Project project, String classOrModuleName) {
        SearchScope scope = RubySearchScopeService.instance().getProjectAndLibrariesScope(project);
        return (Collection)ReadAction.compute(() -> RubyClassModuleNameIndex.getInstance().getElements(project, scope, classOrModuleName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/RubyQualifiedNameUrlProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrModuleFullQualifiedName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOrSuiteClassSymbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/RubyQualifiedNameUrlProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findRMethodSymbolForTest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

