/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.structure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RForStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBeginEndBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.REnsureBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUnlessModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewElement;
import org.jetbrains.plugins.ruby.tasks.rake.RakeIcons;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;

public class RakeStructureViewElement
extends RubyStructureViewElement {
    private static final Logger LOG = Logger.getInstance(RakeStructureViewElement.class);

    public RakeStructureViewElement(@Nullable RPsiElement element) {
        super(element);
    }

    @Override
    protected boolean canElementHaveChildren() {
        return super.canElementHaveChildren() || this.getElement() instanceof RBlockCall;
    }

    @Override
    protected List<? extends RPsiElement> getElementPsiChildren() {
        RPsiElement element = (RPsiElement)this.getElement();
        if (element instanceof RContainer) {
            return ((RContainer)element).getStatements();
        }
        if (element instanceof RBlockCall) {
            RCodeBlock codeBlock = ((RBlockCall)element).getBlock();
            RCompoundStatement codeBlockCompoundStatement = codeBlock.getCompoundStatement();
            return codeBlockCompoundStatement.getStatements();
        }
        return Collections.emptyList();
    }

    @Override
    protected final boolean processPsiChild(@NotNull RPsiElement child, @NotNull Collection<RPsiElement> elements) {
        if (child == null) {
            RakeStructureViewElement.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            RakeStructureViewElement.$$$reportNull$$$0(1);
        }
        if (super.processPsiChild(child, elements)) {
            return true;
        }
        int oldSize = elements.size();
        this.collectElementsFrom(child, elements);
        return oldSize != elements.size();
    }

    private void collectElementsFrom(@Nullable RPsiElement psiElement, final Collection<RPsiElement> elements) {
        if (psiElement == null) {
            return;
        }
        if (psiElement instanceof RCall || psiElement instanceof RBlockCall) {
            RPossibleCall possibleCall = (RPossibleCall)psiElement;
            if (RakeUtil.isRakeTaskCall(possibleCall) || RakeUtil.isRakeNamespaceCall(possibleCall)) {
                elements.add(psiElement);
                return;
            }
            if (RakeStructureViewElement.canBeTaskDefinedUsingTaskClassInstantiation((PsiElement)psiElement)) {
                elements.add(psiElement);
            }
            if (psiElement instanceof RBlockCall) {
                RCompoundStatement compoundStatement = ((RBlockCall)psiElement).getBlock().getCompoundStatement();
                List statements = compoundStatement.getStatements();
                for (RPsiElement rPsiElement : statements) {
                    this.collectElementsFrom(rPsiElement, elements);
                }
            }
            return;
        }
        if (psiElement instanceof RDotReference && RakeStructureViewElement.canBeTaskDefinedUsingTaskClassInstantiation((PsiElement)psiElement)) {
            elements.add(psiElement);
        }
        psiElement.accept((PsiElementVisitor)new RubyElementVisitor(){

            public void visitRIfStatement(@NotNull RIfStatement ifStatement) {
                if (ifStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                RakeStructureViewElement.this.collectElementsFromCodeBlock(ifStatement.getThenBlock(), elements);
                RElseBlock elseBlock = ifStatement.getElseBlock();
                if (elseBlock != null) {
                    RakeStructureViewElement.this.collectElementsFromCodeBlock(elseBlock.getBody(), elements);
                }
                List elsifBlocks = ifStatement.getElsifBlocks();
                for (RElsifBlock elsifBlock : elsifBlocks) {
                    RakeStructureViewElement.this.collectElementsFromCodeBlock(elsifBlock.getBody(), elements);
                }
            }

            public void visitRUnlessStatement(@NotNull RUnlessStatement rUnlessStatement) {
                if (rUnlessStatement == null) {
                    1.$$$reportNull$$$0(1);
                }
                RakeStructureViewElement.this.collectElementsFromCodeBlock(rUnlessStatement.getThenBlock(), elements);
                RElseBlock elseBlock = rUnlessStatement.getElseBlock();
                if (elseBlock != null) {
                    RakeStructureViewElement.this.collectElementsFromCodeBlock(elseBlock.getBody(), elements);
                }
            }

            public void visitRForStatement(@NotNull RForStatement rForStatement) {
                if (rForStatement == null) {
                    1.$$$reportNull$$$0(2);
                }
                RakeStructureViewElement.this.collectElementsFromCodeBlock(rForStatement.getBody(), elements);
            }

            public void visitRUntilStatement(@NotNull RUntilStatement rUntilStatement) {
                if (rUntilStatement == null) {
                    1.$$$reportNull$$$0(3);
                }
                RakeStructureViewElement.this.collectElementsFromCodeBlock(rUntilStatement.getLoopBody(), elements);
            }

            public void visitRWhileStatement(@NotNull RWhileStatement rWhileStatement) {
                if (rWhileStatement == null) {
                    1.$$$reportNull$$$0(4);
                }
                RakeStructureViewElement.this.collectElementsFromCodeBlock(rWhileStatement.getLoopBody(), elements);
            }

            public void visitRBeginEndBlockStatement(@NotNull RBeginEndBlockStatement rBeginEndBlockStatement) {
                REnsureBlock ensureBlock;
                if (rBeginEndBlockStatement == null) {
                    1.$$$reportNull$$$0(5);
                }
                RBodyStatement bodyStatement = rBeginEndBlockStatement.getBody();
                RakeStructureViewElement.this.collectElementsFromCodeBlock(bodyStatement.getCompoundStatement(), elements);
                Collection rescueBlocks = bodyStatement.getRescueBlocks();
                for (RRescueBlock rescueBlock : rescueBlocks) {
                    RakeStructureViewElement.this.collectElementsFromCodeBlock(rescueBlock.getBody(), elements);
                }
                RElseBlock elseBlock = bodyStatement.getElseBlock();
                if (elseBlock != null) {
                    RakeStructureViewElement.this.collectElementsFromCodeBlock(elseBlock.getBody(), elements);
                }
                if ((ensureBlock = bodyStatement.getEnsureBlock()) != null) {
                    RakeStructureViewElement.this.collectElementsFromCodeBlock(ensureBlock.getBody(), elements);
                }
            }

            public void visitRIfModStatement(@NotNull RIfModStatement rIfModStatement) {
                if (rIfModStatement == null) {
                    1.$$$reportNull$$$0(6);
                }
                RakeStructureViewElement.this.collectElementsFrom(rIfModStatement.getCommand(), elements);
            }

            public void visitRUnlessModStatement(@NotNull RUnlessModStatement rUnlessModStatement) {
                if (rUnlessModStatement == null) {
                    1.$$$reportNull$$$0(7);
                }
                RakeStructureViewElement.this.collectElementsFrom(rUnlessModStatement.getCommand(), elements);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ifStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rUnlessStatement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rForStatement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rUntilStatement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rWhileStatement";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rBeginEndBlockStatement";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rIfModStatement";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rUnlessModStatement";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/structure/RakeStructureViewElement$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRIfStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRUnlessStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRForStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRUntilStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRWhileStatement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRBeginEndBlockStatement";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRIfModStatement";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRUnlessModStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void collectElementsFromCodeBlock(@Nullable RCompoundStatement compoundStatement, Collection<RPsiElement> elements) {
        if (compoundStatement != null) {
            List statements = compoundStatement.getStatements();
            for (RPsiElement statement : statements) {
                this.collectElementsFrom(statement, elements);
            }
        }
    }

    public static boolean canBeTaskDefinedUsingTaskClassInstantiation(@NotNull PsiElement psiElement) {
        PsiElement candidateDotRef;
        if (psiElement == null) {
            RakeStructureViewElement.$$$reportNull$$$0(2);
        }
        if ((candidateDotRef = psiElement) instanceof RBlockCall) {
            RBlockCall blockCall = (RBlockCall)psiElement;
            candidateDotRef = blockCall.getCall();
        }
        if (candidateDotRef instanceof RCall) {
            PsiElement possibleRef = ((RCall)candidateDotRef).getPsiCommand();
            RDotReference rDotReference = candidateDotRef = possibleRef instanceof RDotReference ? (RDotReference)possibleRef : null;
        }
        if (candidateDotRef instanceof RDotReference) {
            RPsiElement receiver;
            String receiverText;
            RDotReference dotReference = (RDotReference)candidateDotRef;
            return RakeStructureViewElement.isNewInstanceDotRef(dotReference) && ((receiverText = StringUtil.toLowerCase((String)(receiver = dotReference.getReceiver()).getText())).endsWith("::task") || receiverText.endsWith("::raketask"));
        }
        return false;
    }

    private static boolean isNewInstanceDotRef(RDotReference dotReference) {
        RPsiElement refRightPart = dotReference.getValue();
        if (refRightPart == null) {
            return false;
        }
        return "new".equals(refRightPart.getText());
    }

    @Override
    @NotNull
    protected RubyStructureViewElement createTreeElement(@NotNull RPsiElement psiElement, boolean inherited) {
        if (psiElement == null) {
            RakeStructureViewElement.$$$reportNull$$$0(3);
        }
        return new RakeStructureViewElement(psiElement);
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        Icon icon;
        PsiElement psiElement = this.getElement();
        if (!(psiElement instanceof RPossibleCall)) {
            ItemPresentation itemPresentation = super.getPresentation();
            if (itemPresentation == null) {
                RakeStructureViewElement.$$$reportNull$$$0(4);
            }
            return itemPresentation;
        }
        RPossibleCall call = (RPossibleCall)psiElement;
        ItemPresentation presentation = call.getPresentation();
        if (presentation == null) {
            LOG.error("Presentation isn't defined for " + call.getClass().getName() + ".\n" + call.getText());
            ItemPresentation itemPresentation = super.getPresentation();
            if (itemPresentation == null) {
                RakeStructureViewElement.$$$reportNull$$$0(5);
            }
            return itemPresentation;
        }
        String presentableText = presentation.getPresentableText();
        if (RakeUtil.isRakeTaskCall(call)) {
            String string;
            RPsiElement argument = (RPsiElement)ContainerUtil.getFirstItem((List)call.getArguments());
            if (argument instanceof RAssoc) {
                RAssoc assoc = (RAssoc)argument;
                string = assoc.getKeyText();
            } else {
                string = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
            }
            presentableText = string;
            icon = RakeIcons.RAKE_TASK_ICON;
        } else if (RakeStructureViewElement.canBeTaskDefinedUsingTaskClassInstantiation((PsiElement)call)) {
            if (call instanceof RDotReference) {
                presentableText = call.getText();
            }
            icon = RakeIcons.RAKE_TASK_ICON;
        } else if (RakeUtil.isRakeNamespaceCall(call)) {
            presentableText = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)ContainerUtil.getFirstItem((List)call.getArguments()));
            icon = RakeIcons.RAKE_NAMESPACE_ICON;
        } else {
            ItemPresentation itemPresentation = super.getPresentation();
            if (itemPresentation == null) {
                RakeStructureViewElement.$$$reportNull$$$0(6);
            }
            return itemPresentation;
        }
        return new PresentationData((String)ObjectUtils.coalesce((Object)presentableText, (Object)RBundle.message((String)"ruby.presentation.unknown")), null, icon, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/structure/RakeStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/structure/RakeStructureViewElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processPsiChild";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeTaskDefinedUsingTaskClassInstantiation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTreeElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

