/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.runConfigurations;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationType;

public final class RakeRunConfigurationProducer
extends LazyRunConfigurationProducer<RakeRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = RakeRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            RakeRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull RakeRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement element;
        if (configuration == null) {
            RakeRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RakeRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            RakeRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((element = (PsiElement)sourceElement.get()) == null) {
            return false;
        }
        String taskName = RakeUtil.getRakeTaskFullName(element);
        if (taskName == null) {
            return false;
        }
        configuration.setTaskName(taskName);
        configuration.setName(taskName + ": " + context.getProject().getName());
        VirtualFile workingDir = (VirtualFile)ObjectUtils.doIfNotNull((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)element), RakeUtil::getRakeHomeDir);
        if (workingDir != null) {
            configuration.setWorkingDirectory(workingDir.getPath());
        }
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull RakeRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement element;
        if (configuration == null) {
            RakeRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            RakeRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((element = context.getPsiLocation()) == null) {
            return false;
        }
        String taskName = RakeUtil.getRakeTaskFullName(element);
        if (!Objects.equals(configuration.getTaskName(), taskName)) {
            return false;
        }
        VirtualFile workingDir = (VirtualFile)ObjectUtils.doIfNotNull((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)element), RakeUtil::getRakeHomeDir);
        return Objects.equals(configuration.getWorkingDirectory(), workingDir != null ? workingDir.getPath() : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

