/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.runConfigurations;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationFactoryBase;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.TaskRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationType;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public class RakeRunConfigurationFactory
extends RubyRunConfigurationFactoryBase {
    public static final String CHANGE_TEMPLATE_UI_RUNNER_TEST_FRAMEWORKS = "rake.configuration.change.template.ui.runner";

    public RakeRunConfigurationFactory(RakeRunConfigurationType configurationType) {
        super(configurationType, (project, base) -> new RakeRunConfiguration((Project)project, (ConfigurationFactory)base), "Rake");
    }

    @Override
    protected void initWithDefaultModule(AbstractRubyRunConfiguration conf, @NotNull Module module) {
        if (module == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(0);
        }
        super.initWithDefaultModule(conf, module);
        VirtualFile homeDir = RakeUtil.getRakeHomeDir(module);
        conf.setWorkingDirectory(homeDir != null ? homeDir.getPath() : null);
    }

    public RunnerAndConfigurationSettings createConfigurationSettings(@NotNull Module module, @NotNull String taskFullName, String @NotNull [] taskArgs, @NotNull Map<String, String> env) {
        if (module == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(1);
        }
        if (taskFullName == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(2);
        }
        if (env == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(3);
        }
        if (taskArgs == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(4);
        }
        return this.createConfigurationSettings(module, taskFullName, taskArgs, env, RakeRunConfigurationFactory.getDefaultTaskConfigurationNameProducer(module, taskFullName));
    }

    public RunnerAndConfigurationSettings createConfigurationSettings(@NotNull Module module, @NotNull String taskFullName, String @NotNull [] taskArgs, @NotNull Map<String, String> env, @NotNull Supplier<String> configurationNameProducer) {
        if (module == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(5);
        }
        if (taskFullName == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(6);
        }
        if (env == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(7);
        }
        if (configurationNameProducer == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(8);
        }
        if (taskArgs == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(9);
        }
        RunnerAndConfigurationSettings settings = RunConfigurationUtil.createSettings(module.getProject(), this, "");
        RakeRunConfiguration conf = (RakeRunConfiguration)settings.getConfiguration();
        this.initConfiguration(module, conf, taskFullName, taskArgs, env, configurationNameProducer);
        return settings;
    }

    private void initConfiguration(@NotNull Module module, @NotNull TaskRunConfiguration conf, @NotNull String taskFullName, String @NotNull [] taskArgs, @NotNull Map<String, String> envs, @NotNull Supplier<String> configurationNameProducer) {
        if (module == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(10);
        }
        if (conf == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(11);
        }
        if (taskFullName == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(12);
        }
        if (envs == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(13);
        }
        if (configurationNameProducer == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(14);
        }
        if (taskArgs == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(15);
        }
        conf.setName(configurationNameProducer.get());
        conf.setTaskName(taskFullName);
        String taskArgsString = RunConfigurationUtil.argsToString(taskArgs);
        if (!StringUtil.isEmpty((String)taskArgsString)) {
            conf.setTaskArgs(taskArgsString);
        }
        Map<String, String> configEnvs = conf.getEnvs();
        configEnvs.putAll(envs);
        if (Registry.is((String)CHANGE_TEMPLATE_UI_RUNNER_TEST_FRAMEWORKS, (boolean)true)) {
            SupportedTestFramework framework = RakeUtil.taskRequiresTest(taskFullName);
            conf.setAttachedTestFrameworks(ContainerUtil.createMaybeSingletonList((Object)((Object)framework)));
        }
        this.initWithDefaultModule((AbstractRubyRunConfiguration)((Object)conf), module);
    }

    @NotNull
    public static String getDefaultConfigurationNameForTask(@NotNull Module module, @NotNull String taskFullName) {
        if (module == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(16);
        }
        if (taskFullName == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(17);
        }
        String string = taskFullName + ": " + module.getName();
        if (string == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static Supplier<String> getDefaultTaskConfigurationNameProducer(@NotNull Module module, @NotNull String taskFullName) {
        if (module == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(19);
        }
        if (taskFullName == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(20);
        }
        Supplier<String> supplier = () -> RakeRunConfigurationFactory.getDefaultConfigurationNameForTask(module, taskFullName);
        if (supplier == null) {
            RakeRunConfigurationFactory.$$$reportNull$$$0(21);
        }
        return supplier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskFullName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskArgs";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationNameProducer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationFactory";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigurationNameForTask";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTaskConfigurationNameProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initWithDefaultModule";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationSettings";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initConfiguration";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigurationNameForTask";
                break;
            }
            case 18: 
            case 21: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTaskConfigurationNameProducer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 21 -> new IllegalStateException(string);
        };
    }
}

