/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.runConfigurations;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public class RakeRunConfigurationExternalizer
extends SettingsExternalizer {
    private static final RakeRunConfigurationExternalizer myInstance = new RakeRunConfigurationExternalizer();
    @NonNls
    private static final String RAKE_RUN_CONFIG_SETTINGS_ID = "RAKE_RUN_CONFIG_SETTINGS_ID";
    @NonNls
    private static final String RAKE_TASK_NAME = "RAKE_TASK_NAME";
    @NonNls
    private static final String RAKE_TASK_ARGS = "RAKE_TASK_ARGS";
    @NonNls
    private static final String RAKE_TASK_ATTACHED_TEST_FRAMEWORKS = "RAKE_TASK_ATTACHED_TEST_FRAMEWORKS";
    @Deprecated
    @NonNls
    private static final String RAKE_TASK_SHOULD_ATTACH_TEST_RUNNER_UI = "RAKE_TASK_SHOULD_ATTACH_TEST_RUNNER_UI";
    @NonNls
    private static final String RAKE_TASK_OPTION_TRACE = "RAKE_TASK_OPTION_TRACE";
    @NonNls
    private static final String RAKE_TASK_OPTION_DRYRUN = "RAKE_TASK_OPTION_DRYRUN";
    @NonNls
    private static final String RAKE_TASK_OPTION_PREREQS = "RAKE_TASK_OPTION_PREREQS";
    @NonNls
    private static final String RAKE_TASK_OPTION_TESTOPTS = "RAKE_TASK_OPTION_TESTOPTS";

    public static RakeRunConfigurationExternalizer getInstance() {
        return myInstance;
    }

    public void writeExternal(RakeRunConfiguration config, Element elem) {
        this.writeOption(RAKE_TASK_NAME, config.getTaskName(), elem);
        this.writeOption(RAKE_TASK_ARGS, config.getTaskArgs(), elem);
        this.writeOption(RAKE_TASK_ATTACHED_TEST_FRAMEWORKS, SupportedTestFramework.serialize(config.getAttachedTestFrameworks()), elem);
        this.writeOption(RAKE_TASK_OPTION_TRACE, String.valueOf(config.isOptionTraceEnabled()), elem);
        this.writeOption(RAKE_TASK_OPTION_DRYRUN, String.valueOf(config.isOptionDryrunEnabled()), elem);
        this.writeOption(RAKE_TASK_OPTION_PREREQS, String.valueOf(config.isOptionPrereqsEnabled()), elem);
        this.writeOption(RAKE_TASK_OPTION_TESTOPTS, StringUtil.notNullize((String)config.getTestopts()), elem);
    }

    public void readExternal(RakeRunConfiguration config, Element elem) {
        Map<String, String> optionsByName = this.buildOptionsByElement(elem);
        config.setTaskName(optionsByName.get(RAKE_TASK_NAME));
        config.setTaskArgs(optionsByName.get(RAKE_TASK_ARGS));
        config.setOptionTrace(Boolean.valueOf(optionsByName.get(RAKE_TASK_OPTION_TRACE)));
        config.setOptionDryrun(Boolean.valueOf(optionsByName.get(RAKE_TASK_OPTION_DRYRUN)));
        config.setOptionPrereqs(Boolean.valueOf(optionsByName.get(RAKE_TASK_OPTION_PREREQS)));
        config.setTestopts(StringUtil.notNullize((String)optionsByName.get(RAKE_TASK_OPTION_TESTOPTS)));
        ArrayList<SupportedTestFramework> frs = new ArrayList<SupportedTestFramework>();
        String serialized_attached_fr_info = optionsByName.get(RAKE_TASK_ATTACHED_TEST_FRAMEWORKS);
        if (serialized_attached_fr_info != null) {
            frs.addAll(SupportedTestFramework.deserialize(serialized_attached_fr_info));
        }
        if (Boolean.valueOf(optionsByName.get(RAKE_TASK_SHOULD_ATTACH_TEST_RUNNER_UI)).booleanValue() && !frs.contains((Object)SupportedTestFramework.TEST_UNIT)) {
            frs.add(SupportedTestFramework.TEST_UNIT);
        }
        config.setAttachedTestFrameworks(frs);
    }

    @Override
    @NotNull
    public String getID() {
        return RAKE_RUN_CONFIG_SETTINGS_ID;
    }
}

