/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake.runConfigurations;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rake.workspace.storage.ExtensionsKt;
import org.jetbrains.plugins.ruby.rake.workspace.storage.RakeTaskEntity;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeIcons;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationParams;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public class RakeRunConfigurationEditor
extends SettingsEditor<RakeRunConfiguration>
implements RakeRunConfigurationParams,
PanelWithAnchor {
    private JComponent myContentPane;
    private LabeledComponent<TextFieldWithAutoCompletion> myRakeTaskNameComponent;
    private LabeledComponent<RawCommandLineEditor> myTaskArgumentsComponent;
    private JCheckBox myOptionTraceCB;
    private JCheckBox myOptionDryRunCB;
    private JCheckBox myOptionPrereqsCB;
    private JCheckBox myAttachTestUnitCB;
    private JCheckBox myAttachShouldCB;
    private JCheckBox myAttachCucumberSpecCB;
    private JCheckBox myAttachRSpecCB;
    private final Pair<JCheckBox, SupportedTestFramework>[] myCB2TestFrameworkPairs;
    private TextFieldWithAutoCompletion myRakeTaksNameTextField;
    private RawCommandLineEditor myTaskArgumentsEditor;
    private final Project myProject;
    private JPanel myCommonOptionsPanel;
    private final RubyCommonRunParamsEditor myCommonEditor;
    private boolean myResetting;
    private JComponent anchor;
    private TextFieldWithAutoCompletionListProvider<RakeTaskEntity> myCompletionProvider;

    public RakeRunConfigurationEditor(Project project, RakeRunConfiguration runConfiguration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = RunConfigurationUIUtil.createRubyCommonRunParamsEditor(runConfiguration, "rake", this.myCommonOptionsPanel);
        this.myCommonEditor.addModuleChangedListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RakeRunConfigurationEditor.this.onModuleChanged(RakeRunConfigurationEditor.this.myCommonEditor.getModule(), e.getSource() instanceof JComboBox);
            }
        });
        this.myCB2TestFrameworkPairs = new Pair[]{Pair.create((Object)this.myAttachRSpecCB, (Object)((Object)SupportedTestFramework.RSPEC)), Pair.create((Object)this.myAttachCucumberSpecCB, (Object)((Object)SupportedTestFramework.CUCUMBER)), Pair.create((Object)this.myAttachShouldCB, (Object)((Object)SupportedTestFramework.SHOULDA)), Pair.create((Object)this.myAttachTestUnitCB, (Object)((Object)SupportedTestFramework.TEST_UNIT))};
        this.setAnchor(this.myCommonEditor.getAnchor());
    }

    protected void resetEditorFrom(@NotNull RakeRunConfiguration config) {
        if (config == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myResetting = true;
        try {
            RakeRunConfiguration.copyParams(config, this);
            this.myCommonEditor.resetEditorFrom(config);
        }
        finally {
            this.myResetting = false;
        }
    }

    protected void applyEditorTo(@NotNull RakeRunConfiguration config) throws ConfigurationException {
        if (config == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        RakeRunConfiguration.copyParams(this, config);
        this.myCommonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        JComponent jComponent = this.myContentPane;
        if (jComponent == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    private void createUIComponents() {
        Ref textFieldWithAutoCompletionRef = new Ref();
        Ref completionProviderRef = new Ref();
        this.myRakeTaskNameComponent = RakeRunConfigurationEditor.createRakeTaskNamesComponent(this.myProject, (Ref<? super TextFieldWithAutoCompletion>)textFieldWithAutoCompletionRef, (Ref<? super TextFieldWithAutoCompletionListProvider<RakeTaskEntity>>)completionProviderRef);
        this.myRakeTaksNameTextField = (TextFieldWithAutoCompletion)textFieldWithAutoCompletionRef.get();
        this.myCompletionProvider = (TextFieldWithAutoCompletionListProvider)completionProviderRef.get();
        Ref taskArgsEditorRef = new Ref();
        this.myTaskArgumentsComponent = RakeRunConfigurationEditor.createRakeTaskArgumentsComponent((Ref<? super RawCommandLineEditor>)taskArgsEditorRef);
        this.myTaskArgumentsEditor = (RawCommandLineEditor)taskArgsEditorRef.get();
    }

    public static LabeledComponent<TextFieldWithAutoCompletion> createRakeTaskNamesComponent(@NotNull Project project, @NotNull Ref<? super TextFieldWithAutoCompletion> textFieldRef, @NotNull Ref<? super TextFieldWithAutoCompletionListProvider<RakeTaskEntity>> completionProviderRef) {
        if (project == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        if (textFieldRef == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        if (completionProviderRef == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        String text = RBundle.message((String)"run.configuration.rake.task.name");
        TextFieldWithAutoCompletionListProvider<RakeTaskEntity> provider = new TextFieldWithAutoCompletionListProvider<RakeTaskEntity>(null){

            @NotNull
            protected Icon getIcon(@NotNull RakeTaskEntity item) {
                if (item == null) {
                    2.$$$reportNull$$$0(0);
                }
                Icon icon = RakeIcons.RAKE_RUN_CONFIGURATION_ICON;
                if (icon == null) {
                    2.$$$reportNull$$$0(1);
                }
                return icon;
            }

            @NotNull
            protected String getLookupString(@NotNull RakeTaskEntity item) {
                if (item == null) {
                    2.$$$reportNull$$$0(2);
                }
                String string = item.getName();
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            protected String getTailText(@NotNull RakeTaskEntity item) {
                if (item == null) {
                    2.$$$reportNull$$$0(4);
                }
                String string = " " + item.getDescription();
                if (string == null) {
                    2.$$$reportNull$$$0(5);
                }
                return string;
            }

            public int compare(@NotNull RakeTaskEntity item1, @NotNull RakeTaskEntity item2) {
                if (item1 == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (item2 == null) {
                    2.$$$reportNull$$$0(7);
                }
                return StringUtil.compare((String)item1.getName(), (String)item2.getName(), (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationEditor$2";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item1";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationEditor$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTailText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getLookupString";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getTailText";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "compare";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 5 -> new IllegalStateException(string);
                };
            }
        };
        completionProviderRef.set((Object)provider);
        TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)provider, true, null);
        textFieldRef.set((Object)textField);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)textField);
        myComponent.setText(text);
        return myComponent;
    }

    public static LabeledComponent<RawCommandLineEditor> createRakeTaskArgumentsComponent(@NotNull Ref<? super RawCommandLineEditor> argsEditorWrapper) {
        if (argsEditorWrapper == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        String text = RBundle.message((String)"run.configuration.rake.task.arguments");
        return RunConfigurationUIUtil.createRawEditorComponent(argsEditorWrapper, text);
    }

    @Override
    public String getTaskName() {
        return this.myRakeTaksNameTextField.getText().trim();
    }

    @Override
    public String getTaskArgs() {
        return this.myTaskArgumentsEditor.getText().trim();
    }

    @Override
    @NotNull
    public List<SupportedTestFramework> getAttachedTestFrameworks() {
        ArrayList<SupportedTestFramework> frameworks = new ArrayList<SupportedTestFramework>(1);
        for (Pair<JCheckBox, SupportedTestFramework> cb2TestFrameworkPair : this.myCB2TestFrameworkPairs) {
            JCheckBox cb = (JCheckBox)cb2TestFrameworkPair.first;
            SupportedTestFramework framework = (SupportedTestFramework)((Object)cb2TestFrameworkPair.second);
            if (!cb.isSelected()) continue;
            frameworks.add(framework);
        }
        ArrayList<SupportedTestFramework> arrayList = frameworks;
        if (arrayList == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    public void setTaskName(@Nullable String name) {
        this.myRakeTaksNameTextField.setText(StringUtil.notNullize((String)name));
    }

    @Override
    public void setTaskArgs(@Nullable String args) {
        this.myTaskArgumentsEditor.setText(StringUtil.notNullize((String)args));
    }

    @Override
    public void setAttachedTestFrameworks(List<SupportedTestFramework> frameworks) {
        for (Pair<JCheckBox, SupportedTestFramework> cb2TestFrameworkPair : this.myCB2TestFrameworkPairs) {
            JCheckBox cb = (JCheckBox)cb2TestFrameworkPair.first;
            SupportedTestFramework framework = (SupportedTestFramework)((Object)cb2TestFrameworkPair.second);
            cb.setSelected(frameworks.contains((Object)framework));
        }
    }

    @Override
    public boolean isOptionTraceEnabled() {
        return this.myOptionTraceCB.isSelected();
    }

    @Override
    public boolean isOptionDryrunEnabled() {
        return this.myOptionDryRunCB.isSelected();
    }

    @Override
    public boolean isOptionPrereqsEnabled() {
        return this.myOptionPrereqsCB.isSelected();
    }

    @Override
    @NotNull
    public String getTestopts() {
        return "";
    }

    @Override
    public void setOptionTrace(boolean enabled) {
        this.myOptionTraceCB.setSelected(enabled);
    }

    @Override
    public void setOptionDryrun(boolean enabled) {
        this.myOptionDryRunCB.setSelected(enabled);
    }

    @Override
    public void setOptionPrereqs(boolean enabled) {
        this.myOptionPrereqsCB.setSelected(enabled);
    }

    @Override
    public void setTestopts(@NotNull String value) {
        if (value == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(8);
        }
    }

    private void onModuleChanged(@Nullable Module module, boolean isTriggeredByUser) {
        RakeRunConfigurationEditor.updateTasksListOnModuleChanged(module, this.myCompletionProvider);
        this.updateWorkingDirOnModuleChanged(module, isTriggeredByUser);
    }

    private void updateWorkingDirOnModuleChanged(Module module, boolean isTriggeredByUser) {
        if (isTriggeredByUser && !this.myResetting) {
            VirtualFile homeDir;
            if (module != null && (homeDir = RakeUtil.getRakeHomeDir(module)) != null) {
                this.myCommonEditor.setWorkDir(homeDir.getPath());
                return;
            }
            this.myCommonEditor.setWorkDir(null);
        }
    }

    public static void updateTasksListOnModuleChanged(@Nullable Module module, @NotNull TextFieldWithAutoCompletionListProvider<RakeTaskEntity> completionListProvider) {
        if (completionListProvider == null) {
            RakeRunConfigurationEditor.$$$reportNull$$$0(9);
        }
        if (module == null || module.isDisposed()) {
            completionListProvider.setItems(null);
            return;
        }
        completionListProvider.setItems((Collection)SequencesKt.toList(ExtensionsKt.getRakeTasks(module)));
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myRakeTaskNameComponent.setAnchor(anchor);
        this.myTaskArgumentsComponent.setAnchor(anchor);
        this.myCommonEditor.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionProviderRef";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argsEditorWrapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionListProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/runConfigurations/RakeRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedTestFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRakeTaskNamesComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRakeTaskArgumentsComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTestopts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateTasksListOnModuleChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        this.createUIComponents();
        JPanel jPanel2 = new JPanel();
        this.myContentPane = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent<TextFieldWithAutoCompletion> labeledComponent = this.myRakeTaskNameComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("run.configuration.rake.task.name"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<RawCommandLineEditor> labeledComponent2 = this.myTaskArgumentsComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("run.configuration.rake.task.arguments"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOptionTraceCB = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("run.configuration.rake.task.options.trace"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOptionDryRunCB = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("run.configuration.rake.task.options.dry.run"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOptionPrereqsCB = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("run.configuration.rake.task.options.prereqs"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 3, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("run.configuration.rake.task.attach.test.runner.ui"), (int)0, (int)0, null, null));
        this.myAttachTestUnitCB = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("test.frameworks.names.testunit"));
        jPanel4.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAttachCucumberSpecCB = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("test.frameworks.names.cucumber"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAttachRSpecCB = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("test.frameworks.names.rspec"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAttachShouldCB = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RakeRunConfigurationEditor.class).getString("test.frameworks.names.shoulda"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

