/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public class RakeUtilBase {
    @NonNls
    public static final List<String> RAKE_FILE_NAMES = List.of("Rakefile", "Rakefile.rb", "rakefile", "rakefile.rb");
    @NonNls
    public static final String TASKS_SPEC_FULLCMD = "spec";
    @NonNls
    public static final String TASKS_TEST_FULLCMD = "test";
    @NonNls
    public static final String OPTIONS_TRACE = "--trace";
    @NonNls
    protected static final String RAKE_FILE_EXT = "rake";
    @NonNls
    public static final String RAKE_SCRIPT = "rake";
    @NonNls
    public static final String RAKE_TASK_DESCRIPTION_SHORT_NAME = "desc";
    @NonNls
    public static final String RAKE_NAMESPACE_CLOSURE_SHORT_NAME = "namespace";
    @NonNls
    public static final String RAKE_TASK_CLOSURE_SHORT_NAME = "task";

    public static boolean isRakeFileByNamingConventions(@Nullable VirtualFile file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        if (!RubyVirtualFileScanner.isRubyFile(file)) {
            return false;
        }
        String fileNameWithoutExt = file.getNameWithoutExtension();
        if (StringUtil.toLowerCase((String)fileNameWithoutExt).equals("rakefile")) {
            return true;
        }
        String fileExtension = file.getExtension();
        return fileExtension != null && StringUtil.toLowerCase((String)fileExtension).equals("rake");
    }

    @NotNull
    public static Collection<VirtualFile> getRakeFiles(@Nullable Module module) {
        if (module == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                RakeUtilBase.$$$reportNull$$$0(0);
            }
            return list;
        }
        Collection collection = Arrays.stream(ModuleRootManager.getInstance((Module)module).getContentRoots()).map(root -> RakeUtilBase.findRakeFile(root)).filter(rakefile -> rakefile != null && !rakefile.isDirectory()).collect(Collectors.toList());
        if (collection == null) {
            RakeUtilBase.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public static VirtualFile findRakeFile(@NotNull VirtualFile root) {
        if (root == null) {
            RakeUtilBase.$$$reportNull$$$0(2);
        }
        for (String name : RAKE_FILE_NAMES) {
            VirtualFile rakefile = root.findChild(name);
            if (rakefile == null) continue;
            return rakefile;
        }
        return null;
    }

    public static boolean hasRakeFile(@Nullable Module module) {
        return !RakeUtilBase.getRakeFiles(module).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/RakeUtilBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRakeFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/RakeUtilBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRakeFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

