/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rake.workspace.storage.ExtensionsKt;
import org.jetbrains.plugins.ruby.rake.workspace.storage.RakeTaskEntity;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;

public final class RakeKeymapExtension
implements KeymapExtension {
    @Nullable
    public KeymapGroup createGroup(Condition<? super AnAction> filtered, Project project) {
        List modulesWithRake = (List)ReadAction.compute(() -> RakeKeymapExtension.findModulesWithRakefile(project));
        if (modulesWithRake.isEmpty()) {
            return null;
        }
        KeymapGroup rakeGroup = KeymapGroupFactory.getInstance().createGroup(RBundle.message((String)"keymap.extension.rake.group.name"));
        for (Module module : modulesWithRake) {
            RakeTaskNode node;
            if (module.isDisposed() || (node = RakeKeymapExtension.createRakeTaskTree(SequencesKt.toList(ExtensionsKt.getRakeTasks(module)))) == null) continue;
            RakeKeymapExtension.fillKeymapGroup(rakeGroup, node, filtered);
        }
        return rakeGroup;
    }

    private static void fillKeymapGroup(@NotNull KeymapGroup rakeGroup, @NotNull RakeTaskNode parent, @Nullable Condition<? super AnAction> filtered) {
        if (rakeGroup == null) {
            RakeKeymapExtension.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            RakeKeymapExtension.$$$reportNull$$$0(1);
        }
        for (RakeTaskNode node : parent.children()) {
            if (!node.children().isEmpty()) {
                Group subGroup = (Group)KeymapGroupFactory.getInstance().createGroup(node.id());
                RakeKeymapExtension.fillKeymapGroup((KeymapGroup)subGroup, node, filtered);
                if (subGroup.getSize() <= 0) continue;
                rakeGroup.addGroup((KeymapGroup)subGroup);
                continue;
            }
            if (node.task() == null) continue;
            String id = node.task().getActionId();
            if (filtered != null && !filtered.value((Object)ActionManager.getInstance().getActionOrStub(id))) continue;
            rakeGroup.addActionId(id);
        }
    }

    @NotNull
    private static List<Module> findModulesWithRakefile(Project project) {
        ArrayList<Module> modulesWithRake = new ArrayList<Module>();
        if (project != null) {
            Module[] modules;
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                VirtualFile homeDir = RakeUtil.getRakeHomeDir(module);
                if (homeDir == null || !RakeUtil.rakeFileExists(homeDir)) continue;
                modulesWithRake.add(module);
            }
        }
        ArrayList<Module> arrayList = modulesWithRake;
        if (arrayList == null) {
            RakeKeymapExtension.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    private static RakeTaskNode createRakeTaskTree(@NotNull List<? extends RakeTaskEntity> entities) {
        if (entities == null) {
            RakeKeymapExtension.$$$reportNull$$$0(3);
        }
        if (entities.isEmpty()) {
            return null;
        }
        RakeTaskNode head = new RakeTaskNode("rake", null, new ArrayList<RakeTaskNode>());
        for (RakeTaskEntity entity : ContainerUtil.sorted(entities, Comparator.comparingInt(it -> it.getName().length()))) {
            RakeTaskNode parent = head;
            String[] ids = entity.getName().split(":");
            for (int i = 0; i < ids.length; ++i) {
                RakeTaskNode node = RakeKeymapExtension.findSubtaskById(parent, ids[i]);
                if (node == null) {
                    node = new RakeTaskNode(ids[i], i == ids.length - 1 ? entity : null, new ArrayList<RakeTaskNode>());
                    parent.children.add(node);
                }
                parent = node;
            }
        }
        return head;
    }

    @Nullable
    private static RakeTaskNode findSubtaskById(@NotNull RakeTaskNode parent, @NotNull String id) {
        if (parent == null) {
            RakeKeymapExtension.$$$reportNull$$$0(4);
        }
        if (id == null) {
            RakeKeymapExtension.$$$reportNull$$$0(5);
        }
        return (RakeTaskNode)ContainerUtil.find(parent.children(), it -> id.equals(it.id));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rakeGroup";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/RakeKeymapExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entities";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/RakeKeymapExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findModulesWithRakefile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillKeymapGroup";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRakeTaskTree";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSubtaskById";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private record RakeTaskNode(String id, @Nullable RakeTaskEntity task, List<RakeTaskNode> children) {
    }
}

