/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rake.workspace.storage.ExtensionsKt;
import org.jetbrains.plugins.ruby.rake.workspace.storage.RakeTaskEntity;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeActionsUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.task.CommonRakeActionPanel;
import org.jetbrains.plugins.ruby.tasks.rake.task.RakeActionPanel;
import org.jetbrains.plugins.ruby.tasks.rake.task.RakeDialogs;
import org.jetbrains.plugins.ruby.tasks.rake.task.SimpleRailsRakeActionPanel;

public class RakeAction
extends AnAction
implements DumbAware {
    private final String myTaskName;
    @Nullable
    private final String myTaskDescription;

    public RakeAction(@NotNull @NlsSafe String name, @Nullable @NlsSafe String description, @NotNull Icon icon) {
        if (name == null) {
            RakeAction.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            RakeAction.$$$reportNull$$$0(1);
        }
        super(name, description, icon);
        this.myTaskName = name;
        this.myTaskDescription = description;
        this.addTextOverride("GoToAction", () -> RBundle.message((String)"rake.action.title", (Object[])new Object[]{name}));
    }

    @Nullable
    public String getTaskDescription() {
        return this.myTaskDescription;
    }

    @NotNull
    public String getTaskName() {
        String string = this.myTaskName;
        if (string == null) {
            RakeAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected Module getModule(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RakeAction.$$$reportNull$$$0(3);
        }
        return RakeActionsUtil.getContextModule(dataContext);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            RakeAction.$$$reportNull$$$0(4);
        }
        Module module = this.getModule(event.getDataContext());
        assert (module != null);
        assert (!module.isDisposed());
        String taskName = this.myTaskName;
        for (RakeTaskEntity task : SequencesKt.toList(ExtensionsKt.getRakeTasks(module))) {
            if (!taskName.equals(task.getName())) continue;
            this.executeTask(module, event.getDataContext());
            return;
        }
        String msg = RBundle.message((String)"action.registered.shortcut.execute.invalid.rake.task.msg", (Object[])new Object[]{taskName, module.getName()});
        Messages.showErrorDialog((String)msg, (String)RBundle.message((String)"action.registered.shortcut.execute.disabled.title"));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RakeAction.$$$reportNull$$$0(5);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            RakeAction.$$$reportNull$$$0(6);
        }
        Module module = this.getModule(event.getDataContext());
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        Presentation presentation = event.getPresentation();
        presentation.setVisible(RModuleUtil.getInstance().hasRubySupport(module) && this.getTask(module) != null);
        presentation.setEnabled(sdk != null);
    }

    @Nullable
    public RakeTaskEntity getTask(@NotNull Module module) {
        if (module == null) {
            RakeAction.$$$reportNull$$$0(7);
        }
        return (RakeTaskEntity)ContainerUtil.find(() -> ExtensionsKt.getRakeTasks(module).iterator(), it -> it.getName().equals(this.myTaskName));
    }

    protected void executeTask(@NotNull Module module, @NotNull DataContext originalDataContext) {
        RakeActionPanel rakeActionPanel;
        if (module == null) {
            RakeAction.$$$reportNull$$$0(8);
        }
        if (originalDataContext == null) {
            RakeAction.$$$reportNull$$$0(9);
        }
        if ((rakeActionPanel = this.showTaskArgumentsAndEnvDialog(module, originalDataContext)) == null) {
            return;
        }
        RakeUtil.runRakeTask(this.myTaskName, module, rakeActionPanel);
    }

    @Nullable
    protected RakeActionPanel showTaskArgumentsAndEnvDialog(@NotNull Module module, @NotNull DataContext dataContext) {
        String title;
        if (module == null) {
            RakeAction.$$$reportNull$$$0(10);
        }
        if (dataContext == null) {
            RakeAction.$$$reportNull$$$0(11);
        }
        RakeActionPanel actionPanel = this.createActionPanel(module, dataContext);
        RunnerAndConfigurationSettings settings = RakeUtil.findExistingRakeRunConfFor(module, this.myTaskName);
        String string = title = RModuleUtil.getInstance().isInMultiProject(module) ? RBundle.message((String)"rake.action.execute.task.dialog.title.ex", (Object[])new Object[]{this.myTaskName, module.getName()}) : RBundle.message((String)"rake.action.execute.task.dialog.title", (Object[])new Object[]{this.myTaskName});
        if (RakeDialogs.showDialog(module, title, actionPanel, settings) == 0) {
            return actionPanel;
        }
        return null;
    }

    @NotNull
    protected RakeActionPanel createActionPanel(@NotNull Module module, DataContext dataContext) {
        if (module == null) {
            RakeAction.$$$reportNull$$$0(12);
        }
        if (RailsFacetUtil.hasRailsSupport(module)) {
            return new SimpleRailsRakeActionPanel(module, this.myTaskName, this.myTaskDescription);
        }
        return new CommonRakeActionPanel(this.myTaskDescription);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/RakeAction";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/RakeAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTask";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showTaskArgumentsAndEnvDialog";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createActionPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

