/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.statistic.RubyCapistranoCountCollector;
import org.jetbrains.plugins.ruby.tasks.capistrano.CapistranoUtil;
import org.jetbrains.plugins.ruby.tasks.capistrano.actions.CapistranoStagedActionPanel;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.CapistranoRunCommandLineState;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfigurationEditor;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfigurationParams;

public final class CapistranoRunConfiguration
extends AbstractRubyRunConfiguration<CapistranoRunConfiguration>
implements CapistranoRunConfigurationParams {
    public static final String CAPISTRANO_RUN_CONFIGURATION = "CAPISTRANO_RUN_CONFIGURATION";
    private String myTaskName = "";
    private String myTaskArgs = "";
    @NlsSafe
    private String myStage = "";

    CapistranoRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    protected String getSerializationId() {
        return CAPISTRANO_RUN_CONFIGURATION;
    }

    @Override
    protected SettingsEditor<CapistranoRunConfiguration> createConfigurationEditor() {
        return new CapistranoRunConfigurationEditor(this.getProject(), this);
    }

    @Override
    protected void validateConfiguration() throws RuntimeConfigurationException {
        this.validateTaskName();
        this.validateCapistranoGem();
    }

    private void validateCapistranoGem() throws RuntimeConfigurationError {
        String executable = CapistranoUtil.getCapistranoExecutable(this.getSdk(), this.getModule());
        if (executable == null) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.capistrano.error.capistrano.gem"));
        }
    }

    private void validateTaskName() throws RuntimeConfigurationError {
        if (this.myTaskName.isEmpty()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.capistrano.error.task.name"));
        }
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CapistranoRunConfiguration.$$$reportNull$$$0(0);
        }
        super.readExternal(element);
        CapistranoRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CapistranoRunConfiguration.$$$reportNull$$$0(1);
        }
        super.writeExternal(element);
        CapistranoRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    @Override
    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            CapistranoRunConfiguration.$$$reportNull$$$0(2);
        }
        RubyCapistranoCountCollector.logCapistranoTaskExecuted(this.myTaskName);
        return new CapistranoRunCommandLineState(this, env);
    }

    @Override
    public String getTaskName() {
        return this.myTaskName;
    }

    @Override
    public String getTaskArgs() {
        return this.myTaskArgs;
    }

    @Override
    public void setTaskName(@Nullable String name) {
        this.myTaskName = StringUtil.notNullize((String)name);
    }

    @Override
    public void setTaskArgs(@Nullable String args) {
        this.myTaskArgs = StringUtil.notNullize((String)args);
    }

    @Override
    public boolean isOptionTraceEnabled() {
        return false;
    }

    @Override
    public void setOptionTrace(boolean enabled) {
    }

    @Override
    public void setStage(@Nullable String stage) {
        this.myStage = stage != null ? stage : "";
    }

    @Override
    public String getStage() {
        if (this.myStage.equals(CapistranoStagedActionPanel.getDefaultStage())) {
            return "";
        }
        return this.myStage;
    }

    public static void copyParams(CapistranoRunConfigurationParams fromParams, CapistranoRunConfigurationParams toParams) {
        toParams.setTaskName(fromParams.getTaskName());
        toParams.setTaskArgs(fromParams.getTaskArgs());
        toParams.setStage(fromParams.getStage());
        toParams.setOptionTrace(fromParams.isOptionTraceEnabled());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/capistrano/run/configuration/CapistranoRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommandLineState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

