/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.capistrano.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.projectRoots.Sdk;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.tasks.capistrano.CapistranoUtil;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfiguration;

public class CapistranoRunCommandLineState
extends RubyAbstractCommandLineState {
    @NonNls
    private static final String CAPISTRANO_RUNNER_PARAMS_GROUP_ID = "ruby.capistrano.runner";

    public CapistranoRunCommandLineState(CapistranoRunConfiguration config, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            CapistranoRunCommandLineState.$$$reportNull$$$0(0);
        }
        super(config, environment, false);
    }

    public CapistranoRunConfiguration getConfig() {
        return (CapistranoRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        CapistranoRunConfiguration config = this.getConfig();
        return CapistranoRunCommandLineState.createCommandLine(config, this.getRunnerId());
    }

    public static RubyCommandLineData createCommandLine(@NotNull CapistranoRunConfiguration config, String runnerId) throws ExecutionException {
        if (config == null) {
            CapistranoRunCommandLineState.$$$reportNull$$$0(1);
        }
        RubyCommandLineData data = CapistranoRunCommandLineState.createDefaultCommandLine(config, runnerId);
        Sdk sdk = config.getSdk();
        assert (sdk != null);
        String capExecutablePath = CapistranoUtil.getCapistranoExecutable(sdk, config.getModule());
        if (capExecutablePath != null) {
            String[] split;
            RubyCommandLine commandLine = data.getCommandLine();
            ParamsGroup runnerParamsGroup = CapistranoRunCommandLineState.addExecutionScriptGroup(CAPISTRANO_RUNNER_PARAMS_GROUP_ID, data, commandLine, capExecutablePath, sdk, config.getModule());
            String stage = config.getStage();
            if (!stage.isEmpty()) {
                runnerParamsGroup.addParameter(stage);
            }
            String taskName = config.getTaskName();
            for (String s : split = taskName.split("\\s+")) {
                runnerParamsGroup.addParameter(s);
            }
            String taskArgs = config.getTaskArgs();
            if (!taskArgs.isEmpty()) {
                String[] args;
                for (String arg : args = taskArgs.split("\\s+")) {
                    runnerParamsGroup.addParameter(arg);
                }
            }
            if (config.isOptionTraceEnabled()) {
                runnerParamsGroup.addParameter("--trace");
            }
        }
        return data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/capistrano/run/CapistranoRunCommandLineState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommandLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

