/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.capistrano;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfigurationType;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.task.RakeActionPanel;

public final class CapistranoUtil {
    public static final String CAPFILE = "Capfile";
    public static final String CAPISTRANO_GEM = "capistrano";
    public static final String CAP_EXECUTABLE = "cap";
    public static final String CAPIFY_EXECUTABLE = "capify";
    public static final String CAPIFYING_CONSOLE_TITLE = "Capifying application...";
    public static final String INSTALL = "install";
    public static final String CONFIG = "config";
    public static final String DEPLOY = "deploy";
    @NonNls
    public static final String OPTIONS_TRACE = "--trace";
    private static final String CAPISTRANO3_LISTING_KEY = "-AT";
    private static final String CAPISTRANO_LISTING_KEY = "-vT";
    private static final Logger LOG = Logger.getInstance(CapistranoUtil.class);

    @Nullable
    public static VirtualFile getCapFile(@Nullable Module module) {
        VirtualFile capfile = null;
        if (module == null || module.isDisposed()) {
            return null;
        }
        block0: for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            for (VirtualFile file : root.getChildren()) {
                if (!CapistranoUtil.isCapfile(file)) continue;
                capfile = file;
                continue block0;
            }
        }
        return capfile;
    }

    public static boolean isCapfile(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && CAPFILE.equalsIgnoreCase(file.getName());
    }

    public static boolean isDeployFile(@Nullable VirtualFile file) {
        VirtualFile parentFile = file == null || file.isDirectory() || !"deploy.rb".equals(file.getName()) ? null : file.getParent();
        return parentFile != null && parentFile.isDirectory() && parentFile.getName().equalsIgnoreCase(CONFIG);
    }

    public static void capifyModule(@NotNull Sdk sdk, @NotNull Module module) {
        VirtualFile root;
        if (sdk == null) {
            CapistranoUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            CapistranoUtil.$$$reportNull$$$0(1);
        }
        if ((root = RModuleUtil.getInstance().getFirstContentRoot(module)) != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (CapistranoUtil.isCapistrano3OrLater(module)) {
                    CapistranoUtil.runCapistranoTask(INSTALL, module, null);
                } else {
                    CapistranoUtil.runCapify(sdk, module, root.getPresentableUrl());
                }
            });
        }
    }

    public static boolean isCapistranoEnabled(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        return RubyProjectGemSearchService.Companion.findGem(module, CAPISTRANO_GEM) != null;
    }

    private static void runCapify(final @NotNull Sdk sdk, final @NotNull Module module, @NotNull String appUrl) {
        if (sdk == null) {
            CapistranoUtil.$$$reportNull$$$0(2);
        }
        if (module == null) {
            CapistranoUtil.$$$reportNull$$$0(3);
        }
        if (appUrl == null) {
            CapistranoUtil.$$$reportNull$$$0(4);
        }
        try {
            ExecutionModes.BackGroundMode mode = new ExecutionModes.BackGroundMode(false, CAPIFYING_CONSOLE_TITLE);
            mode.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.processTerminated(event);
                    String scriptPath = CapistranoUtil.getCapistranoExecutable(sdk, module);
                    assert (scriptPath != null);
                    RunnerUtil.reportErrorsIfNeeded(module.getProject(), RBundle.message((String)"execution.error.title.abstract.script", (Object[])new Object[]{CapistranoUtil.CAPIFY_EXECUTABLE}), scriptPath, this.getOutput().getStderr());
                    ApplicationManager.getApplication().invokeLater(() -> {
                        FileDocumentManager.getInstance().saveAllDocuments();
                        SaveAndSyncHandler.getInstance().refreshOpenFiles();
                        VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/tasks/capistrano/CapistranoUtil$1", "processTerminated"));
                }
            });
            String remoteAppUrl = RubySdkUtil.convertToRemote(sdk, module, appUrl);
            ((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, CAPISTRANO_GEM).withModule(module)).withGemScriptName(CAPIFY_EXECUTABLE).withWorkingDirPath(appUrl)).withExecutionMode((ExecutionMode)mode)).withArguments(remoteAppUrl)).executeScript();
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static String getCapistranoExecutable(@Nullable Sdk sdk, @Nullable Module module) {
        return RubyGemExecutionContext.getScriptPath(sdk, module, CAPISTRANO_GEM, CAP_EXECUTABLE);
    }

    @Nullable
    public static RunnerAndConfigurationSettings findRunConfiguration(@NotNull Module module, @NotNull String taskName) {
        if (module == null) {
            CapistranoUtil.$$$reportNull$$$0(5);
        }
        if (taskName == null) {
            CapistranoUtil.$$$reportNull$$$0(6);
        }
        RunManager runManagerEx = RunManager.getInstance((Project)module.getProject());
        List settings = runManagerEx.getConfigurationSettingsList((ConfigurationType)CapistranoRunConfigurationType.getInstance());
        for (RunnerAndConfigurationSettings configurationSettings : settings) {
            CapistranoRunConfiguration configuration = (CapistranoRunConfiguration)configurationSettings.getConfiguration();
            String configurationTaskName = configuration.getTaskName();
            if (!taskName.equals(configurationTaskName) || !module.equals((Object)configuration.getModule())) continue;
            return configurationSettings;
        }
        return null;
    }

    @NotNull
    public static List<String> getStages(@NotNull Module module) {
        VirtualFile deployCandidate;
        VirtualFile configCandidate;
        if (module == null) {
            CapistranoUtil.$$$reportNull$$$0(7);
        }
        ArrayList<String> files = new ArrayList<String>();
        VirtualFile root = RModuleUtil.getInstance().getFirstContentRoot(module);
        if (root != null && (configCandidate = root.findChild(CONFIG)) != null && configCandidate.isDirectory() && (deployCandidate = configCandidate.findChild(DEPLOY)) != null && deployCandidate.isDirectory()) {
            VirtualFile[] stages;
            for (VirtualFile stage : stages = deployCandidate.getChildren()) {
                if (stage.isDirectory() || !stage.isValid()) continue;
                files.add(stage.getNameWithoutExtension());
            }
        }
        ArrayList<String> arrayList = files;
        if (arrayList == null) {
            CapistranoUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static void runCapistranoTask(@NotNull String taskName, @NotNull Module module, @Nullable RakeActionPanel panel2) {
        if (taskName == null) {
            CapistranoUtil.$$$reportNull$$$0(9);
        }
        if (module == null) {
            CapistranoUtil.$$$reportNull$$$0(10);
        }
        RunnerAndConfigurationSettings settings = CapistranoUtil.findRunConfiguration(module, taskName);
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        if (settings != null) {
            RakeUtil.applyChangesFromRakePanel(panel2, settings);
            ApplicationManager.getApplication().runReadAction(() -> RunConfigurationUtil.executeConfiguration(runManager, settings, null));
        } else {
            ApplicationManager.getApplication().runReadAction(() -> {
                RunnerAndConfigurationSettings settings1 = CapistranoRunConfigurationType.getInstance().getFactory().createConfigurationSettings(module, taskName);
                RakeUtil.applyChangesFromRakePanel(panel2, settings1);
                runManager.setTemporaryConfiguration(settings1);
                RunConfigurationUtil.executeConfiguration(runManager, settings1, null);
            });
        }
    }

    @NotNull
    static String getTaskListingArgs(@NotNull Module module) {
        if (module == null) {
            CapistranoUtil.$$$reportNull$$$0(11);
        }
        if (CapistranoUtil.isCapistrano3OrLater(module)) {
            return CAPISTRANO3_LISTING_KEY;
        }
        return CAPISTRANO_LISTING_KEY;
    }

    private static boolean isCapistrano3OrLater(@NotNull Module module) {
        GemInfo gem;
        if (module == null) {
            CapistranoUtil.$$$reportNull$$$0(12);
        }
        return (gem = RubyProjectGemSearchService.Companion.findGem(module, CAPISTRANO_GEM)) != null && VersionComparatorUtil.compare((String)gem.getVersion(), (String)"3.0.0") >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appUrl";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/capistrano/CapistranoUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/capistrano/CapistranoUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "capifyModule";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runCapify";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRunConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStages";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runCapistranoTask";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTaskListingArgs";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCapistrano3OrLater";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

