/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.capistrano;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.tasks.capistrano.CapistranoTaskModuleCache;
import org.jetbrains.plugins.ruby.tasks.capistrano.CapistranoUtil;
import org.jetbrains.plugins.ruby.tasks.capistrano.actions.CapistranoAction;
import org.jetbrains.plugins.ruby.tasks.capistrano.task.CapistranoTask;
import org.jetbrains.plugins.ruby.tasks.capistrano.task.CapistranoTaskImpl;

public final class CapistranoTaskModuleCacheImpl
extends CapistranoTaskModuleCache
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CapistranoTaskModuleCache.class);
    @Language(value="RegExp")
    private static final String TASK_INFO_PATTERN_STR = "^cap\\s([\\w:]+)\\s+#?(.*)";
    private static final Pattern TASK_INFO_PATTERN = Pattern.compile("^cap\\s([\\w:]+)\\s+#?(.*)");
    private static final String ACTION_ID_PREFIX = "capistrano: ";
    @NotNull
    private final Module myModule;
    @NotNull
    private final Project myProject;
    private final Map<String, String> myTaskNamesToDescriptions;
    private final Set<CapistranoTask> myTasks;
    private final Map<String, CapistranoAction> myActions;

    public CapistranoTaskModuleCacheImpl(@NotNull Module module) {
        if (module == null) {
            CapistranoTaskModuleCacheImpl.$$$reportNull$$$0(0);
        }
        this.myTaskNamesToDescriptions = new HashMap<String, String>();
        this.myTasks = new HashSet<CapistranoTask>();
        this.myActions = new HashMap<String, CapistranoAction>();
        this.myModule = module;
        this.myProject = this.myModule.getProject();
        this.myModule.getProject().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new CapistranoFileChangeListener());
        ApplicationManager.getApplication().executeOnPooledThread(this::refresh);
    }

    public void dispose() {
    }

    @Override
    public Collection<CapistranoAction> getActions() {
        return this.myActions.values();
    }

    public void initializeTasks() {
        if (this.myProject.isDisposed()) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
        VirtualFile baseDir = this.myProject.getBaseDir();
        String executable = CapistranoUtil.getCapistranoExecutable(sdk, this.myModule);
        LOG.info("Initializing tasks for " + this.myModule.getName());
        if (sdk == null || baseDir == null || executable == null) {
            LOG.info("Unable to initialize tasks for " + this.myModule.getName());
            return;
        }
        Runnable runnable = () -> {
            try {
                ProcessOutput capOutput = ((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, "capistrano").withGemScriptName("cap").withModule(this.myModule)).withWorkingDir(baseDir)).inSameThread()).withArguments(CapistranoUtil.getTaskListingArgs(this.myModule))).executeScript();
                if (capOutput == null) {
                    LOG.warn("No capistrano tasks listed, output is null for module " + this.myModule.getName());
                    return;
                }
                RunnerUtil.reportErrorsIfNeeded(this.myProject, "Errors", executable, capOutput.getStderr());
                String stdout = capOutput.getStdout();
                LOG.debug("output of `cap -vT`\n" + stdout);
                for (String line : StringUtil.splitByLines((String)stdout)) {
                    Matcher matcher = TASK_INFO_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        String taskName = matcher.group(1).trim();
                        String taskDescription = matcher.group(2).trim();
                        this.myTaskNamesToDescriptions.put(taskName, taskDescription);
                        continue;
                    }
                    LOG.debug("Unable to parse line \"" + line + "\"");
                }
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            LOG.info("Tasks for " + this.myModule.getName() + " initialized");
            if (LOG.isDebugEnabled()) {
                for (Map.Entry<String, String> entry : this.myTaskNamesToDescriptions.entrySet()) {
                    LOG.debug(entry.getKey() + " - " + entry.getValue());
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RBundle.message((String)"capistrano.getting.tasks.progress.title"), false, this.myProject);
    }

    @Override
    public CapistranoAction getActionByName(String name) {
        return this.myActions.get(name);
    }

    @Override
    public Set<CapistranoTask> getTasks() {
        this.myTasks.clear();
        for (String taskName : this.myTaskNamesToDescriptions.keySet()) {
            CapistranoTaskImpl capistranoTask = new CapistranoTaskImpl(taskName, this.myTaskNamesToDescriptions.get(taskName));
            this.myTasks.add(capistranoTask);
        }
        return this.myTasks;
    }

    private void registerCapistranoActions(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            CapistranoTaskModuleCacheImpl.$$$reportNull$$$0(1);
        }
        Set<CapistranoTask> tasks = this.getTasks();
        for (CapistranoTask task : tasks) {
            String taskName = task.getName();
            String actionId = CapistranoTaskModuleCacheImpl.generateActionId(taskName);
            if (CapistranoTaskModuleCacheImpl.isRegistered(actionManager, actionId)) continue;
            CapistranoAction capistranoAction = new CapistranoAction(task);
            this.myActions.put(taskName, capistranoAction);
            actionManager.registerAction(actionId, (AnAction)capistranoAction);
        }
    }

    @Override
    public void refresh() {
        this.myTaskNamesToDescriptions.clear();
        this.initializeTasks();
        ActionManager actionManager = ActionManager.getInstance();
        this.registerCapistranoActions(actionManager);
    }

    private static String generateActionId(@NotNull String taskName) {
        if (taskName == null) {
            CapistranoTaskModuleCacheImpl.$$$reportNull$$$0(2);
        }
        return ACTION_ID_PREFIX + taskName;
    }

    private static boolean isRegistered(ActionManager actionManager, String taskName) {
        AnAction action = actionManager.getAction(taskName);
        return action != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/capistrano/CapistranoTaskModuleCacheImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCapistranoActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateActionId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CapistranoFileChangeListener
    implements BulkFileListener {
        private CapistranoFileChangeListener() {
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                CapistranoFileChangeListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                VirtualFile file;
                if (!(vFileEvent instanceof VFileContentChangeEvent) && !(vFileEvent instanceof VFileCreateEvent) || (file = vFileEvent.getFile()) == null || !"Capfile".equals(file.getName())) continue;
                CapistranoTaskModuleCacheImpl.this.refresh();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/tasks/capistrano/CapistranoTaskModuleCacheImpl$CapistranoFileChangeListener", "after"));
        }
    }
}

