/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

public final class RubyVersionManagersUsageCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ruby.version.managers", 5);
    private static final EventId1<String> MANAGER = GROUP.registerEvent("manager", (EventField)EventFields.String((String)"value", List.of("RvmVersionManagerHandler", "RubySystemVersionManagerHandler", "RbenvVersionManagerHandler", "ChrubyVersionManagerHandler", "AsdfVersionManagerHandler", "MiseVersionManagerHandler")));

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            RubyVersionManagersUsageCollector.$$$reportNull$$$0(0);
        }
        Set<MetricEvent> set = RubySdkUtil.getAllRubySdks().stream().map(it -> {
            Class<?> clazz = RubyVersionManagerHandler.notNullFrom(it).getClass();
            return PluginInfoDetectorKt.getPluginInfo(clazz).isSafeToReport() ? clazz.getSimpleName() : "third.party";
        }).distinct().map(it -> MANAGER.metric(it)).collect(Collectors.toSet());
        if (set == null) {
            RubyVersionManagersUsageCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/statistic/RubyVersionManagersUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/statistic/RubyVersionManagersUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

