/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.statistic.MemoryInfo;
import org.jetbrains.plugins.ruby.statistic.ModuleUsagesCollector;
import org.jetbrains.plugins.ruby.statistic.RubySdkUsageCollectorKt;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/ruby/statistic/RubySdkUsageCollector;", "Lorg/jetbrains/plugins/ruby/statistic/ModuleUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.ruby.backend"})
public final class RubySdkUsageCollector
extends ModuleUsagesCollector {
    @NotNull
    public EventLogGroup getGroup() {
        return RubySdkUsageCollectorKt.access$getGROUP$p();
    }

    @Override
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Module module) {
        List metrics;
        block5: {
            int it;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk == null) {
                return SetsKt.emptySet();
            }
            Sdk sdk2 = sdk;
            RbConfig rbConfig = RbConfig.notNullFrom(sdk2);
            Intrinsics.checkNotNullExpressionValue((Object)rbConfig, (String)"notNullFrom(...)");
            RbConfig rbConfig2 = rbConfig;
            if (rbConfig2.isEmpty()) {
                return SetsKt.emptySet();
            }
            CredentialsType remoteCredentialsType = RubySdkUsageCollectorKt.access$computeRemoteCredentialsType(sdk2);
            Object[] objectArray = new EventPair[6];
            objectArray[0] = EventFields.Version.with((Object)RubySdkUsageCollectorKt.access$computeVersionString(rbConfig2));
            objectArray[1] = RubySdkUsageCollectorKt.access$getRUBY_TYPE$p().with((Object)StringUtil.notNullize((String)rbConfig2.getNormalizeInstallName(), (String)"Missing"));
            objectArray[2] = RubySdkUsageCollectorKt.access$getHOST_OS$p().with((Object)RubySdkUsageCollectorKt.access$computeHostOs(rbConfig2));
            objectArray[3] = RubySdkUsageCollectorKt.access$getVERSION_MANAGER$p().with(RubyVersionManagerHandler.notNullFrom(sdk2).getClass());
            CredentialsType credentialsType = remoteCredentialsType;
            objectArray[4] = RubySdkUsageCollectorKt.access$getREMOTE_TYPE$p().with(credentialsType != null ? credentialsType.getClass() : null);
            objectArray[5] = RubySdkUsageCollectorKt.access$getIS_LOCALHOST$p().with((Object)RubySdkUsageCollectorKt.access$computeIsLocalhost(sdk2));
            metrics = CollectionsKt.mutableListOf((Object[])objectArray);
            if (remoteCredentialsType == null) break block5;
            RubyRunner rubyRunner = RubyRunner.notNullFrom(sdk2);
            Intrinsics.checkNotNullExpressionValue((Object)rubyRunner, (String)"notNullFrom(...)");
            RubyRunner runner = rubyRunner;
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            MemoryInfo remoteMemoryInfo = RubySdkUsageCollectorKt.access$getMemoryInfo(project, runner);
            Integer n = remoteMemoryInfo.getAvailableInKiB();
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl = false;
                metrics.add(RubySdkUsageCollectorKt.access$getREMOTE_AVAILABLE_RAM$p().with((Object)(it / 0x100000)));
            }
            Integer n2 = remoteMemoryInfo.getTotalInKiB();
            if (n2 != null) {
                it = ((Number)n2).intValue();
                boolean bl = false;
                metrics.add(RubySdkUsageCollectorKt.access$getREMOTE_TOTAL_RAM$p().with((Object)(it / 0x100000)));
            }
            Project project2 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Integer n3 = RubySdkUsageCollectorKt.access$getCPUCoreCount(project2, runner);
            if (n3 != null) {
                it = ((Number)n3).intValue();
                boolean bl = false;
                metrics.add(RubySdkUsageCollectorKt.access$getREMOTE_CPU_COUNT$p().with((Object)it));
            }
        }
        return SetsKt.setOf((Object)RubySdkUsageCollectorKt.access$getRUBY_SDK$p().metric(metrics));
    }
}

