/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.bundler.BundleExecSettings;
import org.jetbrains.plugins.ruby.rails.ExternalRailsSettings;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.statistic.RubySdkSourceTypeRunConfiguration;
import org.jetbrains.plugins.ruby.testing.PreloadedTestRunConfiguration;

public final class RubyRunConfigurationSettingProjectCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ruby.run.configuration", 8);
    public static final EventId3<Integer, Class<?>, Boolean> CONFIGURED_NAILGUN_SERVER_ENABLED = GROUP.registerEvent("nailgunServer.configured", (EventField)EventFields.Int((String)"count"), (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Boolean((String)"nailgunServerEnabled"));
    public static final EventId3<Integer, Class<?>, BundleExecSettings.UsingBundleMode> CONFIGURED_USING_BUNDLE_MODE = GROUP.registerEvent("usingBundleMode.configured", (EventField)EventFields.Int((String)"count"), (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Enum((String)"usingBundleMode", BundleExecSettings.UsingBundleMode.class));
    public static final EventId3<Integer, Class<?>, Boolean> CONFIGURED_COVERAGE_IN_TEST_FOLDER_CHANGE = GROUP.registerEvent("coverage.coverageInTestFolder.configured", (EventField)EventFields.Int((String)"count"), (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Boolean((String)"coverageInTestFolder"));
    public static final EventId3<Integer, Class<?>, Boolean> CONFIGURED_BRANCH_COVERAGE = GROUP.registerEvent("coverage.branchCoverage.configured", (EventField)EventFields.Int((String)"count"), (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Boolean((String)"branchCoverage"));
    public static final EventId3<Integer, Class<?>, Boolean> CONFIGURED_FORKED_PROCESSES_COVERAGE = GROUP.registerEvent("coverage.forkedProcessesCoverage.configured", (EventField)EventFields.Int((String)"count"), (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Boolean((String)"forkedProcessesCoverage"));
    private static final EventId3<Integer, Class<?>, PreLoadUtil.PreLoadServer> CONFIGURED_PRELOAD_SERVER = GROUP.registerEvent("preloadServer.configured", (EventField)EventFields.Int((String)"count"), (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Enum((String)"preloadServerType", PreLoadUtil.PreLoadServer.class));
    private static final EventId3<Integer, Class<?>, RubySdkSourceTypeRunConfiguration> CONFIGURED_RUBY_SDK_SOURCE_TYPE = GROUP.registerEvent("rubySdkSourceType.configured", (EventField)EventFields.Int((String)"count"), (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Enum((String)"rubySdkSourceType", RubySdkSourceTypeRunConfiguration.class));
    private static final EventId3<Integer, Class<?>, String> CONFIGURED_RAILS_SERVER = GROUP.registerEvent("railsServer.configured", (EventField)EventFields.Int((String)"count"), (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.String((String)"railsServerType", List.of(ExternalRailsSettings.getRailsServersTypes())));

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            RubyRunConfigurationSettingProjectCollector.$$$reportNull$$$0(0);
        }
        LinkedHashSet<MetricEvent> result = new LinkedHashSet<MetricEvent>();
        List runnerAndConfigurationSettings = RunManager.getInstance((Project)project).getAllSettings();
        ArrayList<Pair> configuredPreloadServerData = new ArrayList<Pair>();
        ArrayList<Pair> configuredRubySdkSourceTypeData = new ArrayList<Pair>();
        ArrayList<Pair> configuredRailsServerData = new ArrayList<Pair>();
        for (RunnerAndConfigurationSettings runAndConf : runnerAndConfigurationSettings) {
            RunConfiguration configuration = runAndConf.getConfiguration();
            ConfigurationType configurationType = configuration.getType();
            if (configuration instanceof PreloadedTestRunConfiguration) {
                configuredPreloadServerData.add(new Pair((Object)configurationType.getClass(), (Object)((PreloadedTestRunConfiguration)configuration).getPreloadServer()));
            }
            if (configuration instanceof AbstractRubyRunConfiguration) {
                boolean isAlternativeSdkSourceSelected = ((AbstractRubyRunConfiguration)configuration).shouldUseAlternativeSdk();
                configuredRubySdkSourceTypeData.add(new Pair((Object)configurationType.getClass(), (Object)RubySdkSourceTypeRunConfiguration.getSdkSourceType(isAlternativeSdkSourceSelected)));
            }
            if (!(configuration instanceof RailsServerRunConfiguration)) continue;
            configuredRailsServerData.add(new Pair((Object)configurationType.getClass(), (Object)((RailsServerRunConfiguration)configuration).getServerType().toLowerCase(Locale.ROOT)));
        }
        configuredPreloadServerData.stream().collect(Collectors.groupingBy(data1 -> data1, Collectors.counting())).forEach((value, count) -> result.add(CONFIGURED_PRELOAD_SERVER.metric((Object)count.intValue(), (Object)((Class)value.getFirst()), (Object)((PreLoadUtil.PreLoadServer)((Object)((Object)value.getSecond()))))));
        configuredRubySdkSourceTypeData.stream().collect(Collectors.groupingBy(data -> data, Collectors.counting())).forEach((value, count) -> result.add(CONFIGURED_RUBY_SDK_SOURCE_TYPE.metric((Object)count.intValue(), (Object)((Class)value.getFirst()), (Object)((RubySdkSourceTypeRunConfiguration)((Object)((Object)value.getSecond()))))));
        configuredRailsServerData.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((value, count) -> result.add(CONFIGURED_RAILS_SERVER.metric((Object)count.intValue(), (Object)((Class)value.getFirst()), (Object)((String)value.getSecond()))));
        List<AbstractRubyRunConfiguration<?>> runConfigurationList = runnerAndConfigurationSettings.stream().map(settings -> settings.getConfiguration()).filter(runConfiguration -> runConfiguration instanceof AbstractRubyRunConfiguration).map(runConfiguration -> (AbstractRubyRunConfiguration)runConfiguration).collect(Collectors.toList());
        result.addAll(RubyRunConfigurationExtensionsManager.getInstance().logConfiguredExtensionsSettings(runConfigurationList));
        LinkedHashSet<MetricEvent> linkedHashSet = result;
        if (linkedHashSet == null) {
            RubyRunConfigurationSettingProjectCollector.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/statistic/RubyRunConfigurationSettingProjectCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/statistic/RubyRunConfigurationSettingProjectCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

