/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.bundler.BundleExecSettings;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.statistic.RubySdkSourceTypeRunConfiguration;

public final class RubyRunConfigurationSettingChangesCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ruby.run.configuration.changes", 8);
    private static final EventId3<Class<?>, PreLoadUtil.PreLoadServer, PreLoadUtil.PreLoadServer> PRELOAD_SERVER_CHANGES = GROUP.registerEvent("preloadServerType.changed", (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Enum((String)"oldServerType", PreLoadUtil.PreLoadServer.class), (EventField)EventFields.Enum((String)"newServerType", PreLoadUtil.PreLoadServer.class));
    private static final EventId3<Class<?>, RubySdkSourceTypeRunConfiguration, RubySdkSourceTypeRunConfiguration> RUBY_SDK_SOURCE_TYPE_CHANGE = GROUP.registerEvent("rubySdkSourceType.changed", (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Enum((String)"oldSdkSourceType", RubySdkSourceTypeRunConfiguration.class), (EventField)EventFields.Enum((String)"newSdkSourceType", RubySdkSourceTypeRunConfiguration.class));
    private static final EventId3<Class<?>, Boolean, Boolean> NAILGUN_SERVER_ENABLED_CHANGE = GROUP.registerEvent("nailgunServerEnabled.changed", (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Boolean((String)"oldNailgunServerEnabledValue"), (EventField)EventFields.Boolean((String)"newNailgunServerEnabledValue"));
    private static final EventId3<Class<?>, BundleExecSettings.UsingBundleMode, BundleExecSettings.UsingBundleMode> USING_BUNDLE_MODE_CHANGE = GROUP.registerEvent("usingBundleMode.changed", (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Enum((String)"oldUsingBundleMode", BundleExecSettings.UsingBundleMode.class), (EventField)EventFields.Enum((String)"newUsingBundleMode", BundleExecSettings.UsingBundleMode.class));
    private static final EventId3<Class<?>, Boolean, Boolean> COVERAGE_IN_TEST_FOLDER_CHANGE = GROUP.registerEvent("coverage.coverageInTestFolder.changed", (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Boolean((String)"oldCoverageInTestFolder"), (EventField)EventFields.Boolean((String)"newCoverageInTestFolder"));
    private static final EventId3<Class<?>, Boolean, Boolean> BRANCH_COVERAGE = GROUP.registerEvent("coverage.branchCoverage.changed", (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Boolean((String)"oldBranchCoverage"), (EventField)EventFields.Boolean((String)"newBranchCoverage"));
    private static final EventId3<Class<?>, Boolean, Boolean> FORKED_PROCESSES_COVERAGE = GROUP.registerEvent("coverage.forkedProcessesCoverage.changed", (EventField)EventFields.Class((String)"configurationType"), (EventField)EventFields.Boolean((String)"oldForkedProcessesCoverage"), (EventField)EventFields.Boolean((String)"newForkedProcessesCoverage"));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void logPreloadServerChange(@NotNull ConfigurationType configurationType, @NotNull PreLoadUtil.PreLoadServer oldServerType, @NotNull PreLoadUtil.PreLoadServer newServerType) {
        if (configurationType == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(0);
        }
        if (oldServerType == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(1);
        }
        if (newServerType == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(2);
        }
        PRELOAD_SERVER_CHANGES.log((Object)configurationType.getClass(), (Object)oldServerType, (Object)newServerType);
    }

    public static void logRubySdkSourceTypeChange(@NotNull ConfigurationType configurationType, boolean oldIsAlternativeSdkSourceSelected, boolean newIsAlternativeSdkSourceSelected) {
        if (configurationType == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(3);
        }
        RUBY_SDK_SOURCE_TYPE_CHANGE.log((Object)configurationType.getClass(), (Object)RubySdkSourceTypeRunConfiguration.getSdkSourceType(oldIsAlternativeSdkSourceSelected), (Object)RubySdkSourceTypeRunConfiguration.getSdkSourceType(newIsAlternativeSdkSourceSelected));
    }

    public static void logNailgunServerEnabledChange(@NotNull ConfigurationType configurationType, boolean oldNailgunServerEnabledValue, boolean newNailgunServerEnabledValue) {
        if (configurationType == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(4);
        }
        NAILGUN_SERVER_ENABLED_CHANGE.log((Object)configurationType.getClass(), (Object)oldNailgunServerEnabledValue, (Object)newNailgunServerEnabledValue);
    }

    public static void logUsingBundleModeChange(@NotNull ConfigurationType configurationType, @NotNull BundleExecSettings.UsingBundleMode oldUsingBundleMode, @NotNull BundleExecSettings.UsingBundleMode newUsingBundleMode) {
        if (configurationType == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(5);
        }
        if (oldUsingBundleMode == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(6);
        }
        if (newUsingBundleMode == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(7);
        }
        USING_BUNDLE_MODE_CHANGE.log((Object)configurationType.getClass(), (Object)oldUsingBundleMode, (Object)newUsingBundleMode);
    }

    public static void logCoverageInTestFolderChange(@NotNull ConfigurationType configurationType, boolean oldCoverageInTestFolder, boolean newCoverageInTestFolder) {
        if (configurationType == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(8);
        }
        COVERAGE_IN_TEST_FOLDER_CHANGE.log((Object)configurationType.getClass(), (Object)oldCoverageInTestFolder, (Object)newCoverageInTestFolder);
    }

    public static void logBranchCoverageChange(@NotNull ConfigurationType configurationType, boolean oldBranchCoverage, boolean newBranchCoverage) {
        if (configurationType == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(9);
        }
        BRANCH_COVERAGE.log((Object)configurationType.getClass(), (Object)oldBranchCoverage, (Object)newBranchCoverage);
    }

    public static void logForkedProcessesCoverageChange(@NotNull ConfigurationType configurationType, boolean oldForkedProcessesCoverage, boolean newForkedProcessesCoverage) {
        if (configurationType == null) {
            RubyRunConfigurationSettingChangesCollector.$$$reportNull$$$0(10);
        }
        FORKED_PROCESSES_COVERAGE.log((Object)configurationType.getClass(), (Object)oldForkedProcessesCoverage, (Object)newForkedProcessesCoverage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldServerType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newServerType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldUsingBundleMode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newUsingBundleMode";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/statistic/RubyRunConfigurationSettingChangesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logPreloadServerChange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logRubySdkSourceTypeChange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "logNailgunServerEnabledChange";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "logUsingBundleModeChange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "logCoverageInTestFolderChange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "logBranchCoverageChange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "logForkedProcessesCoverageChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

