/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class RailsAppExtraArgsCountCollector
extends CounterUsagesCollector {
    private static final List<String> ALLOWED_ARG_TYPES = List.of("--skip-namespace", "--no-skip-namespace", "--skip-collision-check", "--no-skip-collision-check", "-r", "--ruby", "-m", "--template", "-d", "--database", "-G", "--skip-git", "--no-slip-git", "--skip-keeps", "--no-skip-keeps", "-M", "--skip-action-mailer", "--no-skip-action-mailer", "--skip-action-mailbox", "--no-skip-action-mailbox", "--skip-action-text", "--no-skip-action-text", "-O", "--skip-active-record", "--no-skip-active-record", "--skip-active-job", "--no-skip-active-job", "--skip-active-storage", "--no-skip-active-storage", "-C", "--skip-action-cable", "--no-skip-action-cable", "-A", "--skip-asset-pipeline", "--no-skip-asset-pipeline", "-a", "--asset-pipeline", "-J", "--skip-javascript", "--no-skip-javascript", "--skip-hotwire", "--no-skip-hotwire", "--skip-jbuilder", "--no-skip-jbuilder", "-T", "--skip-test", "--no-skip-test", "--skip-system-test", "--no-skip-system-test", "--skip-bootsnap", "--no-skip-bootsnap", "--dev", "--no-dev", "--edge", "--no-edge", "--master", "--main", "--no-main", "--rc", "--no-rc", "--no-no-rc", "--api", "--no-api", "--minimal", "--no-minimal", "-j", "--js", "--javascript", "-c", "--css", "-B", "--skip-bundle", "--no-skip-bundle", "-f", "--force", "-p", "--pretend", "--no-pretend", "-q", "--quite", "--no-quiet", "-s", "--skip", "--no-skip", "-h", "--help", "--no-help", "-v", "--version", "--no-version", "--webpack", "--webpacker");
    private static final Pattern equalArgRegexp = Pattern.compile(".*=.*");
    private static final EventLogGroup GROUP = new EventLogGroup("rails.new.app.extra.args", 2);
    private static final EventId2<String, String> RAILS_APP_CREATED = GROUP.registerEvent("rails.app.created", (EventField)EventFields.StringValidatedByInlineRegexp((String)"version", (String)"(\\d+\\.?)*\\d+"), (EventField)EventFields.String((String)"extraArg", ALLOWED_ARG_TYPES));

    @NotNull
    public EventLogGroup getGroup() {
        EventLogGroup eventLogGroup = GROUP;
        if (eventLogGroup == null) {
            RailsAppExtraArgsCountCollector.$$$reportNull$$$0(0);
        }
        return eventLogGroup;
    }

    public static void logExtraArgsRailsAppCreated(@NotNull String railsVersion, @NotNull String extraArgument) {
        if (railsVersion == null) {
            RailsAppExtraArgsCountCollector.$$$reportNull$$$0(1);
        }
        if (extraArgument == null) {
            RailsAppExtraArgsCountCollector.$$$reportNull$$$0(2);
        }
        if (equalArgRegexp.matcher(extraArgument).matches()) {
            String firstPartArg = StringUtil.substringBefore((String)extraArgument, (String)"=");
            RAILS_APP_CREATED.log((Object)railsVersion, (Object)firstPartArg);
            return;
        }
        RAILS_APP_CREATED.log((Object)railsVersion, (Object)extraArgument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/statistic/RailsAppExtraArgsCountCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/statistic/RailsAppExtraArgsCountCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logExtraArgsRailsAppCreated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

