/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FloatEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public final class NotEmptyGemsetsUsageCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ruby.not.empty.gemsets", 3);
    static final StringEventField TYPE = EventFields.String((String)"type", List.of("rbenv", "rvm"));
    private static final FloatEventField AVERAGE = EventFields.Float((String)"average");
    private static final VarargEventId GEMSET = GROUP.registerVarargEvent("gemset", new EventField[]{TYPE, AVERAGE});
    private static final Logger LOG = Logger.getInstance(NotEmptyGemsetsUsageCollector.class);

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            NotEmptyGemsetsUsageCollector.$$$reportNull$$$0(0);
        }
        HashMap<String, Integer> rbenvSdkToGemsets = new HashMap<String, Integer>();
        HashMap<String, Integer> rvmSdkToGemsets = new HashMap<String, Integer>();
        for (Sdk sdk : RubySdkUtil.getAllRubySdks()) {
            String path = sdk.getHomePath();
            if (path == null) continue;
            if (RbenvGemsetManager.isGemsetSdk(sdk)) {
                NotEmptyGemsetsUsageCollector.addUsage(rbenvSdkToGemsets, path, NotEmptyGemsetsUsageCollector.hasGems(sdk));
            }
            if (RVMSupportUtil.getGemsetName(sdk) == null) continue;
            NotEmptyGemsetsUsageCollector.addUsage(rvmSdkToGemsets, path, NotEmptyGemsetsUsageCollector.hasGems(sdk));
        }
        HashSet<MetricEvent> usageDescriptors = new HashSet<MetricEvent>();
        usageDescriptors.add(NotEmptyGemsetsUsageCollector.getAverage("rbenv", rbenvSdkToGemsets.values()));
        usageDescriptors.add(NotEmptyGemsetsUsageCollector.getAverage("rvm", rvmSdkToGemsets.values()));
        HashSet<MetricEvent> hashSet = usageDescriptors;
        if (hashSet == null) {
            NotEmptyGemsetsUsageCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static MetricEvent getAverage(@NotNull String type, @NotNull Collection<Integer> collection) {
        if (type == null) {
            NotEmptyGemsetsUsageCollector.$$$reportNull$$$0(2);
        }
        if (collection == null) {
            NotEmptyGemsetsUsageCollector.$$$reportNull$$$0(3);
        }
        float gemsAverage = (float)collection.stream().mapToInt(a -> a).average().orElse(0.0);
        return GEMSET.metric(new EventPair[]{TYPE.with((Object)type), AVERAGE.with((Object)Float.valueOf(gemsAverage))});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasGems(@NotNull Sdk sdk) {
        if (sdk == null) {
            NotEmptyGemsetsUsageCollector.$$$reportNull$$$0(4);
        }
        if (RbConfig.notNullFrom(sdk).isEmpty()) {
            return false;
        }
        Set<String> urls = GemUtil.determineGemUrlsForSDK(sdk);
        Iterator<String> iterator = urls.iterator();
        while (iterator.hasNext()) {
            String url = iterator.next();
            try {
                Path dir = Paths.get(VfsUtilCore.urlToPath((String)url), new String[0]);
                if (!dir.toFile().exists()) continue;
                DirectoryStream<Path> paths = Files.newDirectoryStream(dir);
                try {
                    if (!paths.iterator().hasNext()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return false;
            }
        }
        return false;
    }

    private static void addUsage(@NotNull Map<String, Integer> usages, @NotNull String name, boolean hasGems) {
        if (usages == null) {
            NotEmptyGemsetsUsageCollector.$$$reportNull$$$0(5);
        }
        if (name == null) {
            NotEmptyGemsetsUsageCollector.$$$reportNull$$$0(6);
        }
        usages.put(name, hasGems ? usages.getOrDefault(name, 0) + 1 : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/statistic/NotEmptyGemsetsUsageCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/statistic/NotEmptyGemsetsUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAverage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasGems";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

