/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.spellchecker;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.spellchecker.RubyIdentifierSplitter;
import org.jetbrains.plugins.ruby.spellchecker.StringWithEscapingSplitter;

public final class RubySpellCheckerStrategy
extends SpellcheckingStrategy
implements DumbAware {
    private static final Tokenizer<PsiElement> NAMED_ELEMENT_TOKENIZER = new Tokenizer<PsiElement>(){

        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer) {
            String text;
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((text = element.getText()) != null) {
                consumer.consumeToken(element, text, true, 0, TextRange.allOf((String)text), (Splitter)RubyIdentifierSplitter.getInstance());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/spellchecker/RubySpellCheckerStrategy$1";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final Tokenizer<PsiElement> STRING_WITH_ESCAPING_TOKENIZER = new Tokenizer<PsiElement>(){

        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                2.$$$reportNull$$$0(1);
            }
            if (element.getText() != null) {
                consumer.consumeToken(element, (Splitter)StringWithEscapingSplitter.getInstance());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/spellchecker/RubySpellCheckerStrategy$2";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final Class<?>[] IGNORED_ELEMENT_CLASSES = new Class[]{RAliasStatement.class, RClass.class, RMethod.class, RModule.class, RSymbol.class};
    private static final Class<?>[] NAMED_ELEMENT_CLASSES = new Class[]{RAssocKey.class, RConstant.class, RFid.class, RField.class, RFName.class, RGlobalVariable.class, RIdentifier.class};

    @NotNull
    public Tokenizer<?> getTokenizer(PsiElement element) {
        if (PsiTreeUtil.instanceOf((Object)element, (Class[])IGNORED_ELEMENT_CLASSES)) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                RubySpellCheckerStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (element instanceof RAssocKey && element.getFirstChild() instanceof RStringLiteral) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                RubySpellCheckerStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (PsiTreeUtil.instanceOf((Object)element, (Class[])NAMED_ELEMENT_CLASSES)) {
            Tokenizer<PsiElement> tokenizer = NAMED_ELEMENT_TOKENIZER;
            if (tokenizer == null) {
                RubySpellCheckerStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        IElementType elementType = element.getNode().getElementType();
        if (elementType == RubyTokenTypes.tREGEXP_CONTENT) {
            Tokenizer<PsiElement> tokenizer = STRING_WITH_ESCAPING_TOKENIZER;
            if (tokenizer == null) {
                RubySpellCheckerStrategy.$$$reportNull$$$0(3);
            }
            return tokenizer;
        }
        if (TokenBNF.tSTRING_LIKE_CONTENTS.contains(elementType)) {
            Tokenizer tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                RubySpellCheckerStrategy.$$$reportNull$$$0(4);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            RubySpellCheckerStrategy.$$$reportNull$$$0(5);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/spellchecker/RubySpellCheckerStrategy", "getTokenizer"));
    }
}

