/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.generator.SpellCheckerDictionaryGenerator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public class RubySpellCheckerDictionaryGenerator
extends SpellCheckerDictionaryGenerator {
    static final String RUBY_DIC_NAME = "ruby";

    public RubySpellCheckerDictionaryGenerator(Project project, String dictOutputFolder) {
        super(project, dictOutputFolder, RUBY_DIC_NAME);
    }

    protected void processFile(PsiFile file, final HashSet<String> seenNames) {
        if (!(file instanceof RFile)) {
            return;
        }
        file.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRClass(@NotNull RClass rClass) {
                if (rClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubySpellCheckerDictionaryGenerator.this.process((PsiElement)rClass.getClassName(), seenNames);
                super.visitRClass(rClass);
            }

            public void visitRModule(@NotNull RModule rModule) {
                if (rModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                RubySpellCheckerDictionaryGenerator.this.process((PsiElement)rModule.getModuleName(), seenNames);
                super.visitRModule(rModule);
            }

            public void visitRMethod(@NotNull RMethod rMethod) {
                if (rMethod == null) {
                    1.$$$reportNull$$$0(2);
                }
                RubySpellCheckerDictionaryGenerator.this.extractNames(rMethod, seenNames);
                super.visitRMethod(rMethod);
            }

            public void visitRSingletonMethod(@NotNull RSingletonMethod rsMethod) {
                if (rsMethod == null) {
                    1.$$$reportNull$$$0(3);
                }
                RubySpellCheckerDictionaryGenerator.this.extractNames((RMethod)rsMethod, seenNames);
                super.visitRSingletonMethod(rsMethod);
            }

            public void visitRConstant(@NotNull RConstant rConstant) {
                if (rConstant == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (RubyPsiUtilCore.isDeclaration((PsiElement)rConstant)) {
                    RubySpellCheckerDictionaryGenerator.this.process((PsiElement)rConstant, seenNames);
                }
                super.visitRConstant(rConstant);
            }

            public void visitRGlobalVariable(@NotNull RGlobalVariable rGlobalVariable) {
                if (rGlobalVariable == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (RubyPsiUtilCore.isDeclaration((PsiElement)rGlobalVariable)) {
                    RubySpellCheckerDictionaryGenerator.this.process((PsiElement)rGlobalVariable, seenNames);
                }
                super.visitRGlobalVariable(rGlobalVariable);
            }

            public void visitRAliasStatement(@NotNull RAliasStatement rAliasStatement) {
                if (rAliasStatement == null) {
                    1.$$$reportNull$$$0(6);
                }
                RubySpellCheckerDictionaryGenerator.this.process((PsiElement)rAliasStatement, seenNames);
                super.visitRAliasStatement(rAliasStatement);
            }

            public void visitRSymbol(@NotNull RSymbol rSymbol) {
                if (rSymbol == null) {
                    1.$$$reportNull$$$0(7);
                }
                RubySpellCheckerDictionaryGenerator.this.process((PsiElement)rSymbol, seenNames);
                super.visitRSymbol(rSymbol);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rModule";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rMethod";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rsMethod";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rConstant";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rGlobalVariable";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rAliasStatement";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rSymbol";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/spellchecker/RubySpellCheckerDictionaryGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRModule";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRMethod";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRSingletonMethod";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRConstant";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRGlobalVariable";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRAliasStatement";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRSymbol";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void extractNames(@NotNull RMethod rMethod, @NotNull HashSet<String> seenNames) {
        if (rMethod == null) {
            RubySpellCheckerDictionaryGenerator.$$$reportNull$$$0(0);
        }
        if (seenNames == null) {
            RubySpellCheckerDictionaryGenerator.$$$reportNull$$$0(1);
        }
        System.err.println(rMethod.getName());
        this.process(rMethod.getMethodName().getChildren()[0], seenNames);
        for (RArgument arg : rMethod.getArguments()) {
            this.process((PsiElement)arg, seenNames);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "seenNames";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/spellchecker/RubySpellCheckerDictionaryGenerator";
        objectArray[2] = "extractNames";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

