/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.sorbet.navigation;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.model.Pointer;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.navigation.EmptyNavigatable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.TargetLocation;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.navigation.RubyAssociatedDeclarationProvider;

public final class SorbetAssociatedDeclarationProvider
implements RubyAssociatedDeclarationProvider {
    @Override
    @NotNull
    public List<? extends com.intellij.model.Symbol> getAssociatedDeclarations(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull com.intellij.model.Symbol signature) {
        if (project == null) {
            SorbetAssociatedDeclarationProvider.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            SorbetAssociatedDeclarationProvider.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            SorbetAssociatedDeclarationProvider.$$$reportNull$$$0(2);
        }
        GlobalSearchScope declarationsScope = SorbetAssociatedDeclarationProvider.restrictSearchScope(GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)searchScope, (Project)project));
        PsiElement element = PsiSymbolService.getInstance().extractElementFromSymbol(signature);
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (!(element instanceof RElementWithFQN) || file == null || declarationsScope.contains(file)) {
            List list = Collections.emptyList();
            if (list == null) {
                SorbetAssociatedDeclarationProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        Symbol rubySymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)element);
        if (rubySymbol == null) {
            List list = Collections.emptyList();
            if (list == null) {
                SorbetAssociatedDeclarationProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        String name = StringUtil.notNullize((String)rubySymbol.getName());
        Icon icon = rubySymbol.getExplicitIcon();
        List<MySymbol> list = rubySymbol.getAllDeclarations(null).stream().filter(declaration -> Optional.ofNullable(PsiUtilCore.getVirtualFile((PsiElement)declaration)).map(arg_0 -> ((GlobalSearchScope)declarationsScope).contains(arg_0)).orElse(false)).map(declaration -> new MySymbol((PsiElement)declaration, name, (Icon)ObjectUtils.coalesce((Object)icon, (Object)declaration.getIcon(0)))).distinct().toList();
        if (list == null) {
            SorbetAssociatedDeclarationProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            SorbetAssociatedDeclarationProvider.$$$reportNull$$$0(6);
        }
        if (file == null) {
            SorbetAssociatedDeclarationProvider.$$$reportNull$$$0(7);
        }
        GlobalSearchScope declarationsScope = SorbetAssociatedDeclarationProvider.restrictSearchScope(GlobalSearchScope.allScope((Project)project));
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null && !declarationsScope.contains(virtualFile);
    }

    @NotNull
    private static GlobalSearchScope restrictSearchScope(@NotNull GlobalSearchScope baseScope) {
        if (baseScope == null) {
            SorbetAssociatedDeclarationProvider.$$$reportNull$$$0(8);
        }
        return new DelegatingGlobalSearchScope(GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)baseScope, (FileType[])new FileType[]{RubyFileType.RUBY})){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !"rbi".equals(file.getExtension());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/sorbet/navigation/SorbetAssociatedDeclarationProvider$1", "contains"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/sorbet/navigation/SorbetAssociatedDeclarationProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/sorbet/navigation/SorbetAssociatedDeclarationProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedDeclarations";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restrictSearchScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class MySymbol
    implements NavigatableSymbol,
    NavigationTarget {
        private final PsiElement myElement;
        private final TargetLocation myLocation;
        private final TargetPresentation myPresentation;
        @Nullable
        private final Pointer<MySymbol> myPointer;

        private MySymbol(@NotNull PsiElement element, @NotNull String name, @Nullable Icon icon) {
            if (element == null) {
                MySymbol.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MySymbol.$$$reportNull$$$0(1);
            }
            this(element, TargetLocation.fromElement(element), TargetPresentationUtil.createTargetPresentation(name, icon, element), null);
        }

        private MySymbol(@NotNull PsiElement element, @NotNull TargetLocation location, @NotNull TargetPresentation presentation, @Nullable Pointer<MySymbol> pointer) {
            if (element == null) {
                MySymbol.$$$reportNull$$$0(2);
            }
            if (location == null) {
                MySymbol.$$$reportNull$$$0(3);
            }
            if (presentation == null) {
                MySymbol.$$$reportNull$$$0(4);
            }
            this.myElement = element;
            this.myLocation = location;
            this.myPresentation = presentation;
            this.myPointer = pointer;
        }

        @NotNull
        public Pointer<MySymbol> createPointer() {
            if (this.myPointer != null) {
                Pointer<MySymbol> pointer2 = this.myPointer;
                if (pointer2 == null) {
                    MySymbol.$$$reportNull$$$0(5);
                }
                return pointer2;
            }
            TargetLocation location = this.myLocation;
            TargetPresentation presentation = this.myPresentation;
            Pointer pointer3 = Pointer.uroborosPointer((Pointer)SmartPointerManager.createPointer((PsiElement)this.myElement), (element, pointer) -> new MySymbol((PsiElement)element, location, presentation, (Pointer<MySymbol>)pointer));
            if (pointer3 == null) {
                MySymbol.$$$reportNull$$$0(6);
            }
            return pointer3;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.myElement.equals((Object)((MySymbol)obj).myElement);
        }

        @Override
        @NotNull
        public Navigatable getNavigatable() {
            Navigatable navigatable = (Navigatable)ObjectUtils.coalesce((Object)PsiNavigationSupport.getInstance().getDescriptor(this.myElement), (Object)EmptyNavigatable.INSTANCE);
            if (navigatable == null) {
                MySymbol.$$$reportNull$$$0(7);
            }
            return navigatable;
        }

        @Override
        @NotNull
        public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
            if (project == null) {
                MySymbol.$$$reportNull$$$0(8);
            }
            List<MySymbol> list = List.of(this);
            if (list == null) {
                MySymbol.$$$reportNull$$$0(9);
            }
            return list;
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        @Override
        @NotNull
        public TargetLocation location() {
            TargetLocation targetLocation = this.myLocation;
            if (targetLocation == null) {
                MySymbol.$$$reportNull$$$0(10);
            }
            return targetLocation;
        }

        @NotNull
        public TargetPresentation computePresentation() {
            TargetPresentation targetPresentation = this.myPresentation;
            if (targetPresentation == null) {
                MySymbol.$$$reportNull$$$0(11);
            }
            return targetPresentation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/sorbet/navigation/SorbetAssociatedDeclarationProvider$MySymbol";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/sorbet/navigation/SorbetAssociatedDeclarationProvider$MySymbol";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPointer";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatable";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationTargets";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "location";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computePresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigationTargets";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }
}

