/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.sinatra;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RequireInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.sinatra.SinatraCallTypeProvider;

public final class SinatraUtil {
    public static final String SINATRA_GEM_NAME = "sinatra";
    public static final String SINATRA = "sinatra";
    public static final String VIEWS = "views";

    public static boolean isSinatraEnabled(@NotNull PsiElement context) {
        Module module;
        if (context == null) {
            SinatraUtil.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GemInfo gem = RubyProjectGemSearchService.Companion.findGem(module, "sinatra");
            boolean result = gem != null;
            return new CachedValueProvider.Result((Object)result, new Object[]{ProjectRootModificationTracker.getInstance((Project)module.getProject())});
        });
    }

    public static boolean isSinatraAppFile(@NotNull PsiFile file) {
        if (file == null) {
            SinatraUtil.$$$reportNull$$$0(1);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            Project project = file.getProject();
            return CachedValueProvider.Result.create((Object)SinatraUtil.isSinatraAppFileImpl(file), (Object[])new Object[]{file, ProjectRootModificationTracker.getInstance((Project)project)});
        });
    }

    @Nullable
    public static VirtualFile getViewsFolder(Module module) {
        VirtualFile root;
        if (RModuleUtil.getInstance().hasRubySupport(module) && (root = RModuleUtil.getInstance().getFirstContentRoot(module)) != null) {
            VirtualFile[] children;
            for (VirtualFile child : children = root.getChildren()) {
                if (!child.isDirectory() || !child.getName().equals(VIEWS)) continue;
                return child;
            }
        }
        return null;
    }

    public static void processNamedTemplates(@NotNull RFile file, @NotNull Consumer<? super String> templateNameConsumer) {
        if (file == null) {
            SinatraUtil.$$$reportNull$$$0(2);
        }
        if (templateNameConsumer == null) {
            SinatraUtil.$$$reportNull$$$0(3);
        }
        if (SinatraUtil.isSinatraAppFile((PsiFile)file)) {
            SinatraUtil.processAllCalls(file, SinatraCallTypeProvider.TEMPLATE, (Consumer<? super RCall>)((Consumer)call -> ((List)call.getData(new RubyCallType[]{SinatraCallTypeProvider.TEMPLATE})).forEach(name -> templateNameConsumer.consume(name))));
        }
    }

    private static void processAllCalls(@NotNull RFile rFile, RubyCallType<?> type, Consumer<? super RCall> callConsumer) {
        if (rFile == null) {
            SinatraUtil.$$$reportNull$$$0(4);
        }
        List statements = rFile.getCompoundStatement().getStatements();
        for (RPsiElement statement : statements) {
            RCall call;
            RubyCallType callType;
            RBlockCall blockCall;
            ProgressManager.checkCanceled();
            if (!(statement instanceof RBlockCall) || !((blockCall = (RBlockCall)statement) instanceof RCall) || !(callType = (call = (RCall)blockCall.getCall()).getCallType()).equals(type)) continue;
            callConsumer.consume((Object)call);
        }
    }

    private static boolean isSinatraAppFileImpl(PsiFile file) {
        VirtualFile virtualFile;
        if (!SinatraUtil.isSinatraEnabled((PsiElement)file)) {
            return false;
        }
        if (file instanceof RFile && (virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)file)) != null) {
            RFile rFile = (RFile)file;
            List<RequireInfo> requires = RFileUtil.computeRequires(rFile);
            for (RequireInfo require : requires) {
                if (!require.getPath().contains("sinatra")) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateNameConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/sinatra/SinatraUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSinatraEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSinatraAppFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processNamedTemplates";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllCalls";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

