/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.security;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.MultiMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;

@Service(value={Service.Level.PROJECT})
public final class RubyTrustedProjectService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RubyTrustedProjectService.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MultiMap<Module, Object> myModuleListeners;
    @NotNull
    private final Set<Object> myProjectListeners;

    public RubyTrustedProjectService(@NotNull Project project) {
        if (project == null) {
            RubyTrustedProjectService.$$$reportNull$$$0(0);
        }
        this.myModuleListeners = MultiMap.createSet();
        this.myProjectListeners = ConcurrentCollectionFactory.createConcurrentSet();
        this.myProject = project;
    }

    public void addTrustedProjectCallback(@NotNull Object equalityObject, @RequiresEdt @NotNull Runnable callback) {
        if (equalityObject == null) {
            RubyTrustedProjectService.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            RubyTrustedProjectService.$$$reportNull$$$0(2);
        }
        if (!this.myProjectListeners.add(equalityObject)) {
            return;
        }
        TrustedProjectsListener.onceWhenProjectTrusted((Disposable)this, eventProject -> {
            if (!eventProject.equals((Object)this.myProject)) {
                return;
            }
            LOG.debug("Running project callback: ", new Object[]{equalityObject});
            callback.run();
            this.myProjectListeners.remove(equalityObject);
        });
        LOG.debug("Registered project callback: ", new Object[]{equalityObject});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrustedProjectCallback(@NotNull Module module, @NotNull Object equalityObject, @RequiresEdt @NotNull Runnable callback) {
        if (module == null) {
            RubyTrustedProjectService.$$$reportNull$$$0(3);
        }
        if (equalityObject == null) {
            RubyTrustedProjectService.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            RubyTrustedProjectService.$$$reportNull$$$0(5);
        }
        GemRequirementsChangeWatcher pluginModuleDisposable = GemRequirementsChangeWatcher.getInstance(module);
        MultiMap<Module, Object> multiMap = this.myModuleListeners;
        synchronized (multiMap) {
            if (this.myModuleListeners.get((Object)module).contains(equalityObject)) {
                return;
            }
            if (!this.myModuleListeners.containsKey((Object)module)) {
                Disposer.register((Disposable)pluginModuleDisposable, () -> this.myModuleListeners.remove((Object)module));
            }
            this.myModuleListeners.putValue((Object)module, equalityObject);
        }
        TrustedProjectsListener.onceWhenProjectTrusted((Disposable)pluginModuleDisposable, project -> {
            if (module.isDisposed() || !module.getProject().equals(project)) {
                return;
            }
            LOG.debug("Running module callback: ", new Object[]{equalityObject});
            callback.run();
            this.myModuleListeners.remove((Object)module, equalityObject);
        });
        LOG.debug("Registered module callback: ", new Object[]{equalityObject});
    }

    public boolean isTrusted() {
        return TrustedProjects.isProjectTrusted((Project)this.myProject);
    }

    public void dispose() {
    }

    @NotNull
    public static RubyTrustedProjectService getInstance(@NotNull Project project) {
        if (project == null) {
            RubyTrustedProjectService.$$$reportNull$$$0(6);
        }
        RubyTrustedProjectService rubyTrustedProjectService = (RubyTrustedProjectService)project.getService(RubyTrustedProjectService.class);
        if (rubyTrustedProjectService == null) {
            RubyTrustedProjectService.$$$reportNull$$$0(7);
        }
        return rubyTrustedProjectService;
    }

    @NotNull
    public static RubyTrustedProjectService getInstance(@NotNull Module module) {
        if (module == null) {
            RubyTrustedProjectService.$$$reportNull$$$0(8);
        }
        return RubyTrustedProjectService.getInstance(module.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityObject";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/security/RubyTrustedProjectService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/security/RubyTrustedProjectService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTrustedProjectCallback";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

