/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.search;

import com.intellij.ide.SearchTopHitProvider;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RubySearchTopHitProvider
implements SearchTopHitProvider {
    private static final String[][] RAILS_GENERATORS_MATRIX = new String[][]{{"gen", "generate ", "rails:generator:scaffold"}, {"gen", "generate ", "rails:generator:controller"}, {"gen", "generate ", "rails:generator:model"}};
    private final ActionManager myActionManager = ActionManager.getInstance();

    RubySearchTopHitProvider() {
    }

    public void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (pattern == null) {
            RubySearchTopHitProvider.$$$reportNull$$$0(0);
        }
        if (collector == null) {
            RubySearchTopHitProvider.$$$reportNull$$$0(1);
        }
        this.consumeRailsGenerators(pattern, collector);
        this.consumeBundlerActions(pattern, collector);
        this.consumeCapistrano(pattern, collector);
    }

    private void consumeRailsGenerators(String pattern, Consumer<Object> collector) {
        for (String[] strings : RAILS_GENERATORS_MATRIX) {
            if (!StringUtil.isBetween((String)pattern, (String)strings[0], (String)strings[1])) continue;
            for (int i = 2; i < strings.length; ++i) {
                AnAction action = this.myActionManager.getAction(strings[i]);
                if (action == null) continue;
                collector.accept(action);
            }
        }
    }

    private void consumeBundlerActions(String pattern, Consumer<Object> collector) {
        if (StringUtil.isBetween((String)pattern, (String)"bun", (String)"bundle")) {
            this.consumeActionGroup("BUNDLER_ACTIONS", collector);
        }
    }

    private void consumeCapistrano(String pattern, Consumer<Object> collector) {
        if (pattern.startsWith("capi")) {
            this.consumeActionGroup("CAPISTRANO_TOOLS", collector);
        }
    }

    private void consumeActionGroup(String groupName, Consumer<Object> collector) {
        AnAction actionGroup = this.myActionManager.getAction(groupName);
        if (actionGroup instanceof DefaultActionGroup) {
            AnAction[] actions;
            for (AnAction action : actions = ((DefaultActionGroup)actionGroup).getChildActionsOrStubs()) {
                collector.accept(action);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "collector";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/search/RubySearchTopHitProvider";
        objectArray[2] = "consumeTopHits";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

