/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.ui;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.SystemProperties;
import java.awt.Color;
import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class RubySdkRenderer
extends SimpleListCellRenderer<Object> {
    @NlsSafe
    public static final String SEPARATOR = "!!!separator!!!";
    private final Component mySeparator = new TitledSeparator();
    private final boolean myShowHomePath;
    private final boolean myShowLanguageLevel;

    public RubySdkRenderer(boolean showHomePath, boolean showLanguageLevel) {
        this.myShowHomePath = showHomePath;
        this.myShowLanguageLevel = showLanguageLevel;
    }

    public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return SEPARATOR.equals(value) ? this.mySeparator : super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
    }

    public void customize(@NotNull JList<?> list, Object value, int index, boolean selected, boolean hasFocus) {
        if (list == null) {
            RubySdkRenderer.$$$reportNull$$$0(0);
        }
        if (value == null) {
            this.setText(RBundle.message((String)"sdk.renderer.no.sdk.chosen"));
            this.setIcon(RubySdkType.getInstance().getIcon());
        } else if (value instanceof Sdk) {
            Sdk sdk = (Sdk)value;
            this.setIcon(((SdkType)sdk.getSdkType()).getIcon());
            this.setText(RubySdkRenderer.getSdkText(sdk, this.myShowHomePath, this.myShowLanguageLevel));
            if (!RubySdkUtil.isSDKValid(sdk)) {
                this.setForeground((Color)JBColor.RED);
            }
        } else if (value instanceof LanguageLevel) {
            this.setText(((LanguageLevel)value).getShortName());
        } else {
            @NlsSafe String stringifiedValue = value.toString();
            this.setText(stringifiedValue);
        }
    }

    @NlsSafe
    public static String getSdkText(@Nullable Sdk sdk) {
        return RubySdkRenderer.getSdkText(sdk, true, true);
    }

    @NlsSafe
    public static String getSdkText(@Nullable Sdk sdk, boolean showHomePath, boolean showLanguageLevel) {
        SdkAdditionalData data;
        if (sdk == null) {
            return "";
        }
        StringBuilder text = new StringBuilder(sdk.getName().replaceAll("\\s\\(.*\\)", ""));
        if (showHomePath) {
            String interpreterPath = sdk.getHomePath();
            if (interpreterPath == null) {
                return "";
            }
            if (!RVMSupportUtil.isRVMInterpreter(sdk)) {
                String relativePath = interpreterPath.replaceFirst(Pattern.quote(SystemProperties.getUserHome()), "~");
                text.append(" (").append(RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().toSystemDependentName(relativePath)).append(")");
            }
        }
        if (showLanguageLevel && !RubySdkUtil.isMRISdk(sdk) && (data = sdk.getSdkAdditionalData()) instanceof RubySdkAdditionalData) {
            RubySdkAdditionalData rData = (RubySdkAdditionalData)data;
            text.append(" [").append(rData.getLanguageLevel().getShortName()).append("]");
        }
        return text.toString();
    }

    public static void installSdkNameSpeedSearch(JComboBox sdkComboBox) {
        ComboboxSpeedSearch search = new ComboboxSpeedSearch(sdkComboBox, null){

            protected String getElementText(Object element) {
                return element instanceof Sdk ? RubySdkRenderer.getSdkText((Sdk)element) : String.valueOf(element);
            }
        };
        search.setupListeners();
        search.setComparator(new SpeedSearchComparator(false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/ruby/ruby/ui/RubySdkRenderer", "customize"));
    }
}

