/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.templates;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.newclass.CreateWithTemplatesDialogPanel;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;

final class CreateFileFromTemplateInDirectoryDialogPanel
extends CreateWithTemplatesDialogPanel {
    private static final TextComponentAccessor<? super CreateFileFromTemplateInDirectoryDialogPanel> DIRECTORY_FIELD_ACCESSOR = new TextComponentAccessor<CreateFileFromTemplateInDirectoryDialogPanel>(){

        public String getText(@NotNull CreateFileFromTemplateInDirectoryDialogPanel component) {
            if (component == null) {
                1.$$$reportNull$$$0(0);
            }
            return component.myDirectoryField.getText();
        }

        public void setText(@NotNull CreateFileFromTemplateInDirectoryDialogPanel component, @NotNull String text) {
            if (component == null) {
                1.$$$reportNull$$$0(1);
            }
            if (text == null) {
                1.$$$reportNull$$$0(2);
            }
            component.myDirectoryField.setText(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final MyDirectoryTextField myDirectoryField;
    @Nullable
    private JBPopup myDirectoryErrorPopup;
    private RelativePoint myDirectoryErrorShowPoint;

    CreateFileFromTemplateInDirectoryDialogPanel(@NotNull Project project, @NotNull VirtualFile root, @NotNull CreateWithTemplatesDialogPanel.TemplatePresentation template) {
        if (project == null) {
            CreateFileFromTemplateInDirectoryDialogPanel.$$$reportNull$$$0(0);
        }
        if (root == null) {
            CreateFileFromTemplateInDirectoryDialogPanel.$$$reportNull$$$0(1);
        }
        if (template == null) {
            CreateFileFromTemplateInDirectoryDialogPanel.$$$reportNull$$$0(2);
        }
        super(null, List.of(template));
        JBBox box = new JBBox(1);
        SeparatorComponent separator = new SeparatorComponent(JBUI.CurrentTheme.Popup.separatorColor(), SeparatorOrientation.HORIZONTAL);
        separator.setHGap(JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get());
        box.add((Component)separator);
        box.setOpaque(true);
        box.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
        this.myDirectoryField = this.createDirectoryField(project, root);
        box.add((Component)((Object)this.myDirectoryField));
        this.add((Component)box, "Center");
        this.myDirectoryErrorShowPoint = new RelativePoint((Component)((Object)this.myDirectoryField), new Point(0, this.myDirectoryField.getHeight()));
        this.setBorder(null);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (CreateFileFromTemplateInDirectoryDialogPanel.this.myErrorPopup != null && !CreateFileFromTemplateInDirectoryDialogPanel.this.myErrorPopup.isDisposed()) {
                    Disposer.dispose((Disposable)CreateFileFromTemplateInDirectoryDialogPanel.this.myErrorPopup);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
        if (this.myDirectoryErrorPopup != null && !this.myDirectoryErrorPopup.isDisposed()) {
            Disposer.dispose((Disposable)this.myDirectoryErrorPopup);
        }
    }

    @NotNull
    public JTextField getDirectoryField() {
        MyDirectoryTextField myDirectoryTextField = this.myDirectoryField;
        if (myDirectoryTextField == null) {
            CreateFileFromTemplateInDirectoryDialogPanel.$$$reportNull$$$0(3);
        }
        return myDirectoryTextField;
    }

    @NotNull
    public String getEnteredDirectory() {
        String string = this.myDirectoryField.getText().trim();
        if (string == null) {
            CreateFileFromTemplateInDirectoryDialogPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setDirectoryError(@NlsContexts.DialogMessage @Nullable String error) {
        this.myDirectoryField.putClientProperty("JComponent.outline", error != null ? "error" : null);
        if (this.myDirectoryErrorPopup != null && !this.myDirectoryErrorPopup.isDisposed()) {
            Disposer.dispose((Disposable)this.myDirectoryErrorPopup);
        }
        if (error == null) {
            return;
        }
        this.myDirectoryErrorPopup = ComponentValidator.createPopupBuilder((ValidationInfo)new ValidationInfo(error, (JComponent)((Object)this.myDirectoryField)), errorHint -> {
            Insets insets = this.myDirectoryField.getInsets();
            Dimension hintSize = errorHint.getPreferredSize();
            Point point = new Point(0, insets.top - JBUIScale.scale((int)6) - hintSize.height);
            this.myDirectoryErrorShowPoint = new RelativePoint((Component)((Object)this.myDirectoryField), point);
        }).setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true).createPopup();
        this.myDirectoryErrorPopup.show(this.myDirectoryErrorShowPoint);
    }

    @NotNull
    private MyDirectoryTextField createDirectoryField(@NotNull Project project, final @NotNull VirtualFile root) {
        if (project == null) {
            CreateFileFromTemplateInDirectoryDialogPanel.$$$reportNull$$$0(5);
        }
        if (root == null) {
            CreateFileFromTemplateInDirectoryDialogPanel.$$$reportNull$$$0(6);
        }
        MyDirectoryTextField directoryField = new MyDirectoryTextField();
        String title = RBundle.message((String)"ruby.dialog.create.file.from.template.in.directory.browse.directory.title");
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(title).withRoots(new VirtualFile[]{root}).withTreeRootVisible(true);
        BrowseFolderRunnable<CreateFileFromTemplateInDirectoryDialogPanel> runnable = new BrowseFolderRunnable<CreateFileFromTemplateInDirectoryDialogPanel>(project, descriptor, this, DIRECTORY_FIELD_ACCESSOR){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile file) {
                String relativePath;
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root)) != null) {
                    String string = (!relativePath.isBlank() ? FileUtil.toSystemDependentName((String)relativePath) : ".") + File.separator;
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl(), (boolean)false) + File.separator;
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            protected String expandPath(@NotNull String path) {
                String expandedPath;
                if (path == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (OSAgnosticPathUtil.isAbsolute((String)(expandedPath = FileUtil.toCanonicalPath((String)OSAgnosticPathUtil.expandUserHome((String)CreateFileFromTemplateInDirectoryDialogPanel.this.myDirectoryField.getText().trim()))))) {
                    String string = expandedPath;
                    if (string == null) {
                        3.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                String string = "%s/%s".formatted(root.getPath(), expandedPath);
                if (string == null) {
                    3.$$$reportNull$$$0(5);
                }
                return string;
            }

            @NotNull
            protected VirtualFile getInitialFile() {
                VirtualFile virtualFile = (VirtualFile)ObjectUtils.coalesce((Object)super.getInitialFile(), (Object)root);
                if (virtualFile == null) {
                    3.$$$reportNull$$$0(6);
                }
                return virtualFile;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 4, 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$3";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expandPath";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInitialFile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "expandPath";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 4, 5, 6 -> new IllegalStateException(string);
                };
            }
        };
        PathChooserDialog dialog = FileChooserFactoryImpl.createNativePathChooserIfEnabled((FileChooserDescriptor)descriptor, (Project)project, (Component)((Object)this));
        if (dialog != null) {
            directoryField.addBrowseExtension((Runnable)runnable, (Disposable)this);
            if (dialog instanceof Disposable) {
                Disposable disposable = (Disposable)dialog;
                Disposer.dispose((Disposable)disposable);
            }
        }
        directoryField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                CreateFileFromTemplateInDirectoryDialogPanel.this.setDirectoryError(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$4", "textChanged"));
            }
        });
        directoryField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (CreateFileFromTemplateInDirectoryDialogPanel.this.myDirectoryErrorPopup != null && !CreateFileFromTemplateInDirectoryDialogPanel.this.myDirectoryErrorPopup.isDisposed()) {
                    Disposer.dispose((Disposable)CreateFileFromTemplateInDirectoryDialogPanel.this.myDirectoryErrorPopup);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        directoryField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (event.getKeyCode() == 10 && CreateFileFromTemplateInDirectoryDialogPanel.this.myApplyAction != null) {
                    CreateFileFromTemplateInDirectoryDialogPanel.this.myApplyAction.consume((Object)event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$6", "keyPressed"));
            }
        });
        MyDirectoryTextField myDirectoryTextField = directoryField;
        if (myDirectoryTextField == null) {
            CreateFileFromTemplateInDirectoryDialogPanel.$$$reportNull$$$0(7);
        }
        return myDirectoryTextField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnteredDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7 -> new IllegalStateException(string);
        };
    }

    private static final class MyDirectoryTextField
    extends ExtendableTextField {
        private MyDirectoryTextField() {
            this.addExtension(new ExtendableTextComponent.Extension(this){

                @NotNull
                public Icon getIcon(boolean hovered) {
                    Icon icon = AllIcons.Nodes.Folder;
                    if (icon == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon;
                }

                public boolean isIconBeforeText() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$MyDirectoryTextField$1", "getIcon"));
                }
            });
            Dimension minimumSize = this.getMinimumSize();
            minimumSize.height = JBUIScale.scale((int)32);
            Dimension preferredSize = this.getPreferredSize();
            preferredSize.height = JBUIScale.scale((int)32);
            this.setMinimumSize(minimumSize);
            this.setPreferredSize(preferredSize);
            this.setColumns(30);
            MyErrorBorder border = new MyErrorBorder(this.getBorder());
            this.setBorder(JBUI.Borders.compound((Border)border, (Border)JBUI.Borders.empty((int)0, (int)13, (int)0, (int)JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get())));
            this.setBackground(JBUI.CurrentTheme.NewClassDialog.searchFieldBackground());
            this.putClientProperty("StatusVisibleFunction", field -> field.getText().isEmpty());
            this.getEmptyText().setText(RBundle.message((String)"ruby.dialog.create.file.from.template.in.directory.empty.directory"));
        }

        private static final class MyErrorBorder
        implements Border {
            private final Border myDelegate;

            private MyErrorBorder(@NotNull Border delegate) {
                if (delegate == null) {
                    MyErrorBorder.$$$reportNull$$$0(0);
                }
                this.myDelegate = delegate;
            }

            @Override
            @NotNull
            public Insets getBorderInsets(@NotNull Component component) {
                if (component == null) {
                    MyErrorBorder.$$$reportNull$$$0(1);
                }
                Object object = MyErrorBorder.checkError(component) ? this.myDelegate.getBorderInsets(component) : JBInsets.emptyInsets();
                if (object == null) {
                    MyErrorBorder.$$$reportNull$$$0(2);
                }
                return object;
            }

            @Override
            public void paintBorder(@NotNull Component component, @Nullable Graphics graphics, int x, int y, int width, int height) {
                if (component == null) {
                    MyErrorBorder.$$$reportNull$$$0(3);
                }
                if (MyErrorBorder.checkError(component)) {
                    this.myDelegate.paintBorder(component, graphics, x, y, width, height);
                }
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            private static boolean checkError(@NotNull Component component) {
                if (component == null) {
                    MyErrorBorder.$$$reportNull$$$0(4);
                }
                DarculaUIUtil.Outline outline = DarculaUIUtil.getOutline((JComponent)((JComponent)component));
                return DarculaUIUtil.isWarningOrError((DarculaUIUtil.Outline)outline);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "delegate";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$MyDirectoryTextField$MyErrorBorder";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialogPanel$MyDirectoryTextField$MyErrorBorder";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBorderInsets";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getBorderInsets";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "paintBorder";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "checkError";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }
}

