/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk.jruby;

import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import icons.RubyIcons;
import java.io.File;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class JRubySdkType
extends RubySdkType {
    @NonNls
    private static final String JRUBY_SDK_NAME = "JRUBY_SDK";
    private static final String JRUBY_SDK_NAME_PREFIX = "jruby";
    @NonNls
    private static final String JRUBY_INTERPRETER_NAME = "jruby";
    @NonNls
    private static final String JRUBY_WIN_EXE = "jruby.exe";
    @NonNls
    private static final String JRUBY_UNIX_EXE = "jruby";
    @NonNls
    private static final String[] JRUBY_WIN_DEFAULT_HOME_PATH = new String[]{"C:\\jruby\\bin\\jruby.exe"};
    @NonNls
    private static final String[] JRUBY_UNIX_DEFAULT_HOME_PATH = new String[]{"/usr/local/jruby", "/Library/Frameworks/JRuby.framework/Versions/Current/bin/jruby"};
    @Deprecated
    private static String JRUBY_EXE;

    @Override
    @NotNull
    public String getRubyExecutable() {
        String string = JRUBY_EXE;
        if (string == null) {
            JRubySdkType.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JRubySdkType() {
        super(JRUBY_SDK_NAME);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = RBundle.message((String)"sdk.jruby.title");
        if (string == null) {
            JRubySdkType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isValidInterpreter(@NotNull File existingCandidate, boolean isWindows) {
        if (existingCandidate == null) {
            JRubySdkType.$$$reportNull$$$0(2);
        }
        return JRubySdkType.isValidJrubySdkInterpreter(existingCandidate, isWindows);
    }

    public static boolean isValidJrubySdkInterpreter(@NotNull File existingCandidate, boolean isWindows) {
        if (existingCandidate == null) {
            JRubySdkType.$$$reportNull$$$0(3);
        }
        if (!StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)existingCandidate.getName())).startsWith("jruby")) {
            return false;
        }
        boolean isWinExecutable = existingCandidate.getName().endsWith(".exe");
        return isWindows == isWinExecutable;
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths() {
        Collection<String> collection = RubySdkUtil.suggestRubyHomePaths(JRubySdkType.getInstance(), JRUBY_WIN_DEFAULT_HOME_PATH, JRUBY_UNIX_DEFAULT_HOME_PATH);
        if (collection == null) {
            JRubySdkType.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NonNls
    @NotNull
    public String getGetVersionScript() {
        return "print JRUBY_VERSION";
    }

    @Override
    protected String getSdkNamePrefix() {
        return "jruby";
    }

    @Override
    public Icon getIcon() {
        return RubyIcons.Jruby.Jruby;
    }

    @Override
    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.jruby";
    }

    @Override
    public String getBuiltinsName() {
        return "jruby_builtin.rb";
    }

    public static JRubySdkType getInstance() {
        return (JRubySdkType)SdkType.findInstance(JRubySdkType.class);
    }

    @Override
    public String expectedExecutableName() {
        return "jruby";
    }

    public static boolean isJRubyExecutable(String executablePath) {
        String executableName = VfsUtil.extractFileName((String)executablePath);
        return executableName != null && executableName.startsWith("jruby");
    }

    static {
        if (SystemInfo.isWindows) {
            JRUBY_EXE = JRUBY_WIN_EXE;
        } else if (SystemInfo.isUnix) {
            JRUBY_EXE = "jruby";
        } else {
            LOG.error(RBundle.message((String)"os.not.supported"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/jruby/JRubySdkType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingCandidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyExecutable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/jruby/JRubySdkType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidInterpreter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidJrubySdkInterpreter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

