/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk.implementation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.MriImplementationHandler;

class TruffleImplementationHandler
extends MriImplementationHandler {
    private static final Logger LOG = Logger.getInstance(TruffleImplementationHandler.class);

    TruffleImplementationHandler(@NotNull Sdk sdk) {
        if (sdk == null) {
            TruffleImplementationHandler.$$$reportNull$$$0(0);
        }
        super(sdk);
    }

    @Override
    @NotNull
    public List<String> getLoadPath() {
        RbConfig rbConfig = RbConfig.notNullFrom(this.getSdk());
        String libdir = rbConfig.get("libdir");
        if (StringUtil.isEmpty((String)libdir)) {
            LOG.warn("No libdir entry for " + String.valueOf(this.getSdk()));
            List<String> list = Collections.emptyList();
            if (list == null) {
                TruffleImplementationHandler.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<String> list = Arrays.asList(libdir + "/truffle", libdir + "/mri", libdir + "/json/lib");
        if (list == null) {
            TruffleImplementationHandler.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public String getImplementationName() {
        return "truffleruby";
    }

    @Override
    @Nullable
    public String getShortVersion() {
        return RubyVersionUtil.getTruffleShortVersion(this.getSdk().getVersionString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/implementation/TruffleImplementationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/implementation/TruffleImplementationHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

