/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk.implementation;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.Strings;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.JrubyImplementationHandler;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.MriImplementationHandler;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.TruffleImplementationHandler;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;

@ApiStatus.Experimental
public abstract class RubyImplementationHandler {
    @NotNull
    @NonNls
    private static final String MACOS_BUNDLED_RUBY_FRAMEWORK_PATH = "/System/Library/Frameworks/Ruby.framework";
    @NotNull
    private final Sdk mySdk;

    protected RubyImplementationHandler(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyImplementationHandler.$$$reportNull$$$0(0);
        }
        this.mySdk = sdk;
    }

    @NotNull
    protected final Sdk getSdk() {
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            RubyImplementationHandler.$$$reportNull$$$0(1);
        }
        return sdk;
    }

    @NotNull
    protected final RbConfig getRbConfig() {
        RbConfig rbConfig = RbConfig.notNullFrom(this.getSdk());
        if (rbConfig == null) {
            RubyImplementationHandler.$$$reportNull$$$0(2);
        }
        return rbConfig;
    }

    @NotNull
    public abstract List<String> getLoadPath();

    @NotNull
    public abstract String getDefaultGemBoxPath();

    public long getNormalizedExecutionTimeout(long baseTimeout) {
        return baseTimeout;
    }

    public final boolean isMacOsBundledRubySdk() {
        return RubySdkSystemAccessor.notNullFrom(this.mySdk).isMac() && Strings.notNullize((String)this.getRbConfig().getLibDir()).startsWith(MACOS_BUNDLED_RUBY_FRAMEWORK_PATH);
    }

    @NotNull
    public abstract String getImplementationName();

    @Nullable
    public abstract String getShortVersion();

    @Contract(value="null->null")
    @Nullable
    public static RubyImplementationHandler from(@Nullable Sdk sdk) {
        String interpreterName;
        if (!RubySdkUtil.isRubySDK(sdk)) {
            return null;
        }
        if (sdk.getSdkType() instanceof JRubySdkType) {
            return new JrubyImplementationHandler(sdk);
        }
        String interpreterPath = sdk.getHomePath();
        if (interpreterPath != null && (interpreterName = new File(interpreterPath).getName()).startsWith("truffleruby")) {
            return new TruffleImplementationHandler(sdk);
        }
        return new MriImplementationHandler(sdk);
    }

    @NotNull
    public static RubyImplementationHandler notNullFrom(@NotNull Sdk rubySdk) {
        if (rubySdk == null) {
            RubyImplementationHandler.$$$reportNull$$$0(3);
        }
        RubyImplementationHandler rubyImplementationHandler = Objects.requireNonNull(RubyImplementationHandler.from(rubySdk));
        if (rubyImplementationHandler == null) {
            RubyImplementationHandler.$$$reportNull$$$0(4);
        }
        return rubyImplementationHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/implementation/RubyImplementationHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/implementation/RubyImplementationHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbConfig";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

