/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.AbstractSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherUtilKt;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemVersionManagerHandler;

@ApiStatus.Internal
public final class RubyTestSdkUtil {
    private static final Logger LOG = Logger.getInstance(RubyTestSdkUtil.class);

    private RubyTestSdkUtil() {
    }

    public static void discoverLocalSdks() {
        RubySdkType rubySdkType = RubySdkType.getInstance();
        Collection<Sdk> localValidSdks = RubyTestSdkUtil.getLocalValidSdks();
        Set existingSdkPaths = localValidSdks.stream().map(sdk -> FileUtil.toSystemIndependentName((String)Objects.requireNonNull(sdk.getHomePath()))).collect(Collectors.toSet());
        Collection<String> interpreterPaths = rubySdkType.suggestHomePaths();
        for (String interpreterPath : interpreterPaths) {
            if (existingSdkPaths.contains(FileUtil.toSystemIndependentName((String)interpreterPath))) {
                LOG.warn("Sdk is already registered: " + interpreterPath);
                continue;
            }
            VirtualFile interpreterFile = LocalFileSystem.getInstance().findFileByIoFile(new File(interpreterPath));
            if (interpreterFile == null) {
                throw new RuntimeException("Unable to find interpreter with path: " + interpreterPath + "; all suggested paths: " + String.valueOf(interpreterPaths));
            }
            rubySdkType.createAndAddLocalSdk(interpreterFile, RubySystemVersionManagerHandler.getInstance().createAdditionalData());
        }
        AbstractSdkRefresher.doWithAllSdkRefreshersPermitted(() -> SdkRefresherUtilKt.refreshAllWhenReady(() -> false));
    }

    @NotNull
    private static Collection<Sdk> getLocalValidSdks() {
        RubySdkType rubySdkType = RubySdkType.getInstance();
        List list = ContainerUtil.filter((Collection)ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)rubySdkType), sdk -> rubySdkType.isLocalSdk((Sdk)sdk) && RubySdkUtil.isSDKValid(sdk));
        if (list == null) {
            RubyTestSdkUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public static Sdk selectRubySdkByInfix(@NotNull Project project, @NotNull String sdkNameInfix) {
        Sdk rubySdk;
        if (project == null) {
            RubyTestSdkUtil.$$$reportNull$$$0(1);
        }
        if (sdkNameInfix == null) {
            RubyTestSdkUtil.$$$reportNull$$$0(2);
        }
        if ((rubySdk = RubyTestSdkUtil.findRubySdkByInfix(sdkNameInfix)) != null) {
            LOG.warn("Sdk selected: " + String.valueOf(rubySdk));
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)rubySdk)));
            }
        }
        return rubySdk;
    }

    @Nullable
    public static Sdk findRubySdkByInfix(@NotNull String sdkNameInfix) {
        if (sdkNameInfix == null) {
            RubyTestSdkUtil.$$$reportNull$$$0(3);
        }
        Collection<Sdk> rubySdks = RubyTestSdkUtil.getLocalValidSdks();
        LOG.warn("All detected ruby sdks: " + String.valueOf(rubySdks));
        for (Sdk rubySdk : rubySdks) {
            String sdkName = rubySdk.getName();
            if (!sdkName.contains(sdkNameInfix)) continue;
            return rubySdk;
        }
        return null;
    }

    public static void cleanupVersionFiles(@NotNull Path projectRootPath) {
        if (projectRootPath == null) {
            RubyTestSdkUtil.$$$reportNull$$$0(4);
        }
        List.of(".ruby-version", ".ruby-gemset").forEach(fileName -> {
            Path filePath = projectRootPath.resolve((String)fileName);
            if (Files.exists(filePath, new LinkOption[0])) {
                LOG.warn("Deleting: " + String.valueOf(filePath));
                try {
                    Files.delete(filePath);
                }
                catch (IOException e) {
                    LOG.warn("Failed to delete " + String.valueOf(filePath), (Throwable)e);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyTestSdkUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkNameInfix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalValidSdks";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyTestSdkUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectRubySdkByInfix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRubySdkByInfix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cleanupVersionFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

