/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.io.IOException;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class RubyStubsEditorNotificationsProvider
implements EditorNotificationProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance(RubyStubsEditorNotificationsProvider.class);

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        String rubyVersion;
        if (project == null) {
            RubyStubsEditorNotificationsProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RubyStubsEditorNotificationsProvider.$$$reportNull$$$0(1);
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)RubyFileType.RUBY)) {
            return null;
        }
        Sdk sdk = RubySdkUtil.findRubySdk(project);
        if (sdk == null) {
            return null;
        }
        VirtualFile root = VirtualFileManager.getInstance().findFileByNioPath(RubySdkUtil.getStubsDir(sdk));
        if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) {
            return null;
        }
        VirtualFile versionFile = root.findChild(".ruby-version");
        if (versionFile == null) {
            return null;
        }
        try {
            rubyVersion = VfsUtilCore.loadText((VirtualFile)versionFile).trim();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return null;
        }
        return fileEditor -> new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info).text(RBundle.message((String)"ruby.rubystubs.banner", (Object[])new Object[]{rubyVersion}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyStubsEditorNotificationsProvider";
        objectArray[2] = "collectNotificationData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

