/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyFileSystemUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.nativerb.RubyStubBuilderService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkInvalidator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkLoadPathInitializer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemData;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemVersionManagerHandler;

public final class RubySdkUtil {
    @NonNls
    private static final String CYGDRIVE = "/cygdrive/";
    @NonNls
    private static final String USR = "/usr/";
    @NonNls
    public static final String RUBYSTUBS = "rubystubs";
    @NonNls
    private static final String RUBYSTUBS_DIR18 = "rubystubs18";
    @NonNls
    private static final String RUBYSTUBS_DIR19 = "rubystubs19";
    @NonNls
    private static final String RUBYSTUBS_DIR20 = "rubystubs20";
    @NonNls
    private static final String RUBYSTUBS_DIR21 = "rubystubs21";
    @NonNls
    private static final String RUBYSTUBS_DIR22 = "rubystubs22";
    @NonNls
    private static final String RUBYSTUBS_DIR23 = "rubystubs23";
    @NonNls
    private static final String RUBYSTUBS_DIR24 = "rubystubs24";
    @NonNls
    private static final String RUBYSTUBS_DIR25 = "rubystubs25";
    @NonNls
    private static final String RUBYSTUBS_DIR26 = "rubystubs26";
    @NonNls
    private static final String RUBYSTUBS_DIR27 = "rubystubs27";
    @NonNls
    private static final String RUBYSTUBS_DIR30 = "rubystubs30";
    @NonNls
    private static final String RUBYSTUBS_DIR31 = "rubystubs31";
    @NonNls
    private static final String RUBYSTUBS_DIR32 = "rubystubs32";
    @NonNls
    private static final String RUBYSTUBS_DIR33 = "rubystubs33";
    @NonNls
    private static final String RUBYSTUBS_DIR34 = "rubystubs34";
    @NonNls
    public static final String RUBYSIGS = "rubysigs";
    @NonNls
    private static final String JAR = ".jar";
    private static final Logger LOGGER = Logger.getInstance(RubySdkUtil.class);
    @NonNls
    private static final Pattern WINDOWS_PATH = Pattern.compile("(([a-zA-Z]):[\\\\/]).*");
    private static final Key<Boolean> MOCK_SDK_KEY = Key.create((String)"ruby.mock.sdk");

    private RubySdkUtil() {
    }

    public static boolean isRubySDK(@Nullable Sdk sdk) {
        LOGGER.debug("SDK: " + String.valueOf(sdk));
        if (sdk == null) {
            return false;
        }
        boolean isRubySdkType = RubySdkUtil.isRubySdkType(sdk.getSdkType());
        LOGGER.debug("isRubySdkType: " + isRubySdkType + ". Sdk type: " + String.valueOf(sdk.getSdkType()));
        return isRubySdkType;
    }

    public static boolean isRubySdkType(@Nullable SdkTypeId sdkTypeId) {
        return sdkTypeId instanceof RubySdkType;
    }

    @Contract(value="null -> false")
    public static boolean isSDKValid(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubySdkUtil.isRubyInterpreterExist(sdk);
    }

    public static boolean isRubyInterpreterExist(@Nullable Sdk rubySdk) {
        if (rubySdk == null) {
            return false;
        }
        String homePath = rubySdk.getHomePath();
        if (homePath == null) {
            return false;
        }
        return RubySdkUtil.isMockSdk(rubySdk) ? ((RubySdkType)rubySdk.getSdkType()).isValidSdkHome(homePath, false) : ((RubySdkType)rubySdk.getSdkType()).isValidSdkHome(homePath, RubySdkSystemAccessor.notNullFrom(rubySdk).isWindows());
    }

    public static boolean isRubySdkDisposed(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(0);
        }
        return !RubySdkInvalidator.getInstance().isValid(sdk);
    }

    public static void checkIfRubySdkDisposed(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(1);
        }
        if (RubySdkUtil.isRubySdkDisposed(sdk)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    public static String getGemsBinFolderPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(2);
        }
        String string = RubySdkAdditionalData.notNullFrom(sdk).getGemsBinDirectory();
        if (string == null) {
            RubySdkUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static VirtualFile[] getSdkRoots(@NotNull Sdk sdk) {
        SdkAdditionalData sdkAdditionalData;
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(4);
        }
        if ((sdkAdditionalData = sdk.getSdkAdditionalData()) instanceof RubySdkAdditionalData && !((RubySdkAdditionalData)sdkAdditionalData).myInitializedPaths) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Requesting immediate init for " + String.valueOf(sdk) + "; isDispatchThread=" + ApplicationManager.getApplication().isDispatchThread());
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> RubySdkLoadPathInitializer.INSTANCE.requestInitializationSynchronized(sdk), RBundle.message((String)"ruby.ide.sdk.init.progress.title", (Object[])new Object[]{sdk.getName()}), false, null);
            } else {
                RubySdkLoadPathInitializer.INSTANCE.requestInitializationSynchronized(sdk);
            }
            List<VirtualFile> roots = ((RubySdkAdditionalData)sdkAdditionalData).myTemporaryRoots;
            if (roots != null) {
                LOGGER.debug("Taken temporary results because modificator is not committed yet");
                return roots.toArray(VirtualFile.EMPTY_ARRAY);
            }
        }
        return sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public static RubySdkAdditionalData getRubySdkAdditionalData(@NotNull Sdk sdk) {
        SdkAdditionalData data;
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(5);
        }
        if (!((data = sdk.getSdkAdditionalData()) instanceof RubySdkAdditionalData)) {
            throw new IllegalArgumentException("Unexpected type of sdk (" + String.valueOf(sdk) + ") addition data - " + String.valueOf(data));
        }
        RubySdkAdditionalData rubySdkAdditionalData = (RubySdkAdditionalData)data;
        if (rubySdkAdditionalData == null) {
            RubySdkUtil.$$$reportNull$$$0(6);
        }
        return rubySdkAdditionalData;
    }

    public static PathMappingSettings getDefaultPathMappings(@NotNull Sdk sdk, @Nullable Module module) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(7);
        }
        return RubySdkUtil.getRubySdkAdditionalData(sdk).getRunnerMappings(module);
    }

    public static VirtualFile[] getSdkRootsWithAllGems(@NotNull Sdk sdk, @Nullable Project project) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(8);
        }
        ArrayList<VirtualFile> urls = new ArrayList<VirtualFile>();
        ContainerUtil.addAll(urls, (Object[])RubySdkUtil.getSdkRoots(sdk));
        if (project != null) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                for (GemInfo gem : RubyProjectGemSearchService.Companion.getAllGems(module)) {
                    VirtualFile stubs;
                    VirtualFile virtualFile = stubs = ApplicationManager.getApplication().isUnitTestMode() ? null : RubyStubBuilderService.getInstance().getStubs(gem);
                    if (stubs != null) {
                        urls.add(stubs);
                    }
                    urls.addAll(gem.getValidRequirePaths());
                }
            }
        }
        return VfsUtilCore.toVirtualFileArray(urls);
    }

    @TestOnly
    @NotNull
    public static Sdk findOrCreateMockSdk(@NotNull SdkType sdkType, @NotNull String versionName, @NotNull String interpreterPath, @NotNull List<String> sdkRoots) {
        if (sdkType == null) {
            RubySdkUtil.$$$reportNull$$$0(9);
        }
        if (versionName == null) {
            RubySdkUtil.$$$reportNull$$$0(10);
        }
        if (interpreterPath == null) {
            RubySdkUtil.$$$reportNull$$$0(11);
        }
        if (sdkRoots == null) {
            RubySdkUtil.$$$reportNull$$$0(12);
        }
        return RubySdkUtil.findOrCreateMockSdk(sdkType, versionName, interpreterPath, sdkRoots, null);
    }

    @TestOnly
    @NotNull
    public static Sdk findOrCreateMockSdk(@NotNull SdkType sdkType, @NotNull String versionName, @NotNull String interpreterPath, @NotNull List<String> sdkRoots, @Nullable RubyVersionManagerSdkData<?> rubyVersionManagerSdkData) {
        if (sdkType == null) {
            RubySdkUtil.$$$reportNull$$$0(13);
        }
        if (versionName == null) {
            RubySdkUtil.$$$reportNull$$$0(14);
        }
        if (interpreterPath == null) {
            RubySdkUtil.$$$reportNull$$$0(15);
        }
        if (sdkRoots == null) {
            RubySdkUtil.$$$reportNull$$$0(16);
        }
        if (rubyVersionManagerSdkData == null) {
            rubyVersionManagerSdkData = RubySdkUtil.computeMockSdkVersionManagerData(interpreterPath);
        }
        String sdkName = RubySdkUtil.computeMockSdkName(sdkType, versionName, interpreterPath, rubyVersionManagerSdkData);
        List existingSdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)sdkType);
        for (Sdk sdk : existingSdks) {
            if (!sdk.getName().equals(sdkName)) continue;
            if (FileUtil.toSystemIndependentName((String)interpreterPath).equals(sdk.getHomePath()) && RubySdkUtil.sdkRootsEqual(sdk, sdkRoots)) {
                MOCK_SDK_KEY.set((UserDataHolder)sdk, (Object)Boolean.TRUE);
                Sdk sdk2 = sdk;
                if (sdk2 == null) {
                    RubySdkUtil.$$$reportNull$$$0(17);
                }
                return sdk2;
            }
            WriteAction.runAndWait(() -> ProjectJdkTable.getInstance().removeJdk(sdk));
        }
        return RubySdkUtil.createMockSdk(sdkType, versionName, interpreterPath, sdkRoots, rubyVersionManagerSdkData);
    }

    private static boolean sdkRootsEqual(@NotNull Sdk sdk, @NotNull List<String> sdkRoots) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(18);
        }
        if (sdkRoots == null) {
            RubySdkUtil.$$$reportNull$$$0(19);
        }
        HashSet<String> existingRoots = new HashSet<String>(ContainerUtil.map((Object[])sdk.getRootProvider().getFiles(OrderRootType.CLASSES), VirtualFile::getPresentableUrl));
        Set newRoots = ContainerUtil.map2Set(sdkRoots, FileUtil::toSystemDependentName);
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof RubySdkAdditionalData) {
            RubySdkAdditionalData data = (RubySdkAdditionalData)sdkAdditionalData;
            for (String url : data.getGemsRootUrls()) {
                existingRoots.add(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
            }
        }
        return existingRoots.size() == newRoots.size() && existingRoots.containsAll(newRoots);
    }

    @TestOnly
    @NotNull
    public static Sdk createMockSdk(@NotNull SdkType sdkType, @NotNull String versionName, @NotNull String interpreterPath, @NotNull List<String> sdkRoots, @Nullable RubyVersionManagerSdkData<?> versionManagerSdkData) {
        SdkAdditionalData sdkAdditionalData;
        if (sdkType == null) {
            RubySdkUtil.$$$reportNull$$$0(20);
        }
        if (versionName == null) {
            RubySdkUtil.$$$reportNull$$$0(21);
        }
        if (interpreterPath == null) {
            RubySdkUtil.$$$reportNull$$$0(22);
        }
        if (sdkRoots == null) {
            RubySdkUtil.$$$reportNull$$$0(23);
        }
        if (versionManagerSdkData == null) {
            versionManagerSdkData = RubySdkUtil.computeMockSdkVersionManagerData(interpreterPath);
        }
        String sdkName = RubySdkUtil.computeMockSdkName(sdkType, versionName, interpreterPath, versionManagerSdkData);
        Sdk sdk = ProjectJdkTable.getInstance().createSdk(sdkName, (SdkTypeId)sdkType);
        RubyGemsEnvironment.init(sdk);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.setHomePath(interpreterPath);
        sdkModificator.setVersionString(versionName);
        for (String sdkRoot : sdkRoots) {
            VirtualFile root;
            if (VirtualFileManager.extractProtocol((String)sdkRoot) == null) {
                sdkRoot = VfsUtilCore.pathToUrl((String)sdkRoot);
            }
            if ((root = VirtualFileManager.getInstance().refreshAndFindFileByUrl(sdkRoot)) == null) {
                if (!sdkRoot.contains("gemsData")) continue;
                throw new IllegalStateException("Cannot find SDK root \"" + sdkRoot + "\". Make sure that your development environment is set up according to https://confluence.jetbrains.com/display/RUBYDEV/RubyMine+development+hints#RubyMinedevelopmenthints-Tests");
            }
            if (FileTypeRegistry.getInstance().isFileOfType(root, (FileType)ArchiveFileType.INSTANCE)) {
                root = JarFileSystem.getInstance().getJarRootForLocalFile(root);
                RubySdkUtil.addToSourceAndClasses(sdkModificator, root != null ? root.findFileByRelativePath("META-INF/jruby.home/lib/ruby/1.8") : null);
            }
            RubySdkUtil.addToSourceAndClasses(sdkModificator, root);
        }
        if (sdkType instanceof RubySdkType) {
            RubySdkAdditionalData sdkAdditionalData2 = new RubySdkAdditionalData().withVersionManagerSdkAdditionalData(versionManagerSdkData);
            RbConfig.initEmpty(sdkAdditionalData2);
            sdkModificator.setSdkAdditionalData((SdkAdditionalData)sdkAdditionalData2);
            String versionString = sdkModificator.getVersionString();
            sdkAdditionalData2.setNormalizedVersionString(versionString);
            sdkAdditionalData2.setLanguageLevel(RubyVersionUtil.extractLanguageLevelFromVersion(versionString));
            sdkAdditionalData2.setGemsBinDirectory(sdkAdditionalData2.computeInterpreterDir(interpreterPath));
            sdkAdditionalData2.setGemsRootUrls(Collections.emptyList());
        }
        if ((sdkAdditionalData = sdkModificator.getSdkAdditionalData()) instanceof RubySdkAdditionalData) {
            RubySdkAdditionalData sdkData = (RubySdkAdditionalData)sdkAdditionalData;
            sdkData.setGemsRootUrls(RubySdkType.findGemsRoots(sdkModificator));
        }
        ApplicationManager.getApplication().runWriteAction(() -> sdkModificator.commitChanges());
        MOCK_SDK_KEY.set((UserDataHolder)sdk, (Object)Boolean.TRUE);
        Sdk sdk2 = sdk;
        if (sdk2 == null) {
            RubySdkUtil.$$$reportNull$$$0(24);
        }
        return sdk2;
    }

    public static boolean isMockSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(25);
        }
        return MOCK_SDK_KEY.isIn((UserDataHolder)sdk);
    }

    @TestOnly
    private static String computeMockSdkName(@NotNull SdkType sdkType, @NotNull String versionName, @NotNull String interpreterPath, @NotNull RubyVersionManagerSdkData<?> versionManagerSdkData) {
        String string;
        if (sdkType == null) {
            RubySdkUtil.$$$reportNull$$$0(26);
        }
        if (versionName == null) {
            RubySdkUtil.$$$reportNull$$$0(27);
        }
        if (interpreterPath == null) {
            RubySdkUtil.$$$reportNull$$$0(28);
        }
        if (versionManagerSdkData == null) {
            RubySdkUtil.$$$reportNull$$$0(29);
        }
        if (sdkType instanceof RubySdkType) {
            RubySdkType rubySdkType = (RubySdkType)sdkType;
            string = rubySdkType.createSdkName(interpreterPath, versionName, versionManagerSdkData);
        } else {
            string = versionName;
        }
        return string;
    }

    @TestOnly
    @NotNull
    private static RubyVersionManagerSdkData<?> computeMockSdkVersionManagerData(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            RubySdkUtil.$$$reportNull$$$0(30);
        }
        RubySystemData rubySystemData = RVMSupportUtil.isRVMInterpreter(interpreterPath, LocalRvmPathsSettings.getInstance()) ? ((RvmSdkData)RvmVersionManagerHandler.getInstance().createAdditionalData().withDistributionId(Paths.get(interpreterPath, new String[0]).getParent().getParent().getFileName().toString())).withVersionManagerPath("mock_rvm_path") : RubySystemVersionManagerHandler.getInstance().createAdditionalData();
        if (rubySystemData == null) {
            RubySdkUtil.$$$reportNull$$$0(31);
        }
        return rubySystemData;
    }

    static void addToSourceAndClasses(@NotNull SdkModificator sdkModificator, @Nullable VirtualFile vFile) {
        if (sdkModificator == null) {
            RubySdkUtil.$$$reportNull$$$0(32);
        }
        if (vFile != null) {
            sdkModificator.addRoot(vFile, OrderRootType.CLASSES);
            sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
        }
    }

    @NotNull
    private static List<String> findInterpreters(@NotNull RubySdkType sdkType) {
        if (sdkType == null) {
            RubySdkUtil.$$$reportNull$$$0(33);
        }
        String interpreterName = sdkType.getRubyExecutable();
        ArrayList<String> list = new ArrayList<String>();
        if (SystemInfo.isMac) {
            list.addAll(OSUtil.findExecutableInMacOSProfile(interpreterName));
        } else if (SystemInfo.isWindows) {
            list.addAll(OSUtil.findExecutableOnWindowsRootAndProgramFiles(interpreterName));
        }
        list.addAll(OSUtil.findExecutablesByName(interpreterName));
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            RubySdkUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    public static Collection<String> suggestRubyHomePaths(RubySdkType type, String[] winDefaultHomePaths, String[] unixDefaultHomePaths) {
        HashSet<String> paths = new HashSet<String>(RubySdkUtil.findInterpreters(type));
        if (SystemInfo.isWindows) {
            for (String winDefaultHomePath : winDefaultHomePaths) {
                RubySdkUtil.checkedPathAdd(winDefaultHomePath, paths);
            }
        }
        if (SystemInfo.isUnix) {
            for (String unixDefaultHomePath : unixDefaultHomePaths) {
                RubySdkUtil.checkedPathAdd(unixDefaultHomePath, paths);
            }
        }
        return paths;
    }

    private static void checkedPathAdd(String homePath, Set<String> paths) {
        File file = new File(homePath);
        if (file.exists() && file.isFile()) {
            paths.add(homePath);
        }
    }

    public static String unCygwinizePath(@NotNull Sdk sdk, String path) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(35);
        }
        if (!RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().isWindows() || !path.contains("/") || JRubySdkUtil.isJRubySDK(sdk)) {
            return path;
        }
        if (path.startsWith(CYGDRIVE)) {
            path = path.substring(CYGDRIVE.length());
            return path.charAt(0) + ":" + path.substring(1);
        }
        if (path.startsWith(USR)) {
            RubySdkType type = (RubySdkType)sdk.getSdkType();
            VirtualFile directory = sdk.getHomeDirectory();
            assert (directory != null) : "sdk home directory must not bee null (" + String.valueOf(sdk) + ")";
            String bin = directory.getPath().replace(type.getRubyExecutable(), "");
            String BIN = "bin/";
            String cygwin = bin.endsWith("bin/") ? bin.substring(0, bin.length() - "bin/".length()) : bin;
            path = path.replaceFirst(USR, cygwin);
        }
        return path;
    }

    public static String cygwinizePath(Sdk sdk, String path) {
        if (sdk == null || !SystemInfo.isWindows || JRubySdkUtil.isJRubySDK(sdk)) {
            return path;
        }
        if (!RubySdkUtil.isCygwin(RubySdkType.getPlatform(sdk))) {
            return path;
        }
        Matcher m = WINDOWS_PATH.matcher(path);
        if (m.matches()) {
            String drive = m.group(2);
            return path.replace(m.group(1), CYGDRIVE + drive + "/").replace('\\', '/');
        }
        return path;
    }

    @NotNull
    public static Path getRubystubsRoot() {
        return RubySdkUtil.getStubsRoot(RUBYSTUBS);
    }

    public static Path getStubsDir(@NotNull LanguageLevel level) {
        if (level == null) {
            RubySdkUtil.$$$reportNull$$$0(36);
        }
        return RubySdkUtil.getStubsDir(RUBYSTUBS, RubySdkUtil.getStubsFolderName(level));
    }

    public static Path getStubsDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(37);
        }
        return RubySdkUtil.getStubsDir(RUBYSTUBS, RubySdkUtil.getStubsFolderName(sdk));
    }

    @NotNull
    public static Path getRubysigsRoot() {
        return RubySdkUtil.getStubsRoot(RUBYSIGS);
    }

    @NotNull
    public static Path getRubysigsDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(38);
        }
        return RubySdkUtil.getStubsDir(RUBYSIGS, RubySdkUtil.getRubysigsFolderName(sdk));
    }

    @NotNull
    public static Path getRubysigsDir(@NotNull LanguageLevel level) {
        if (level == null) {
            RubySdkUtil.$$$reportNull$$$0(39);
        }
        return RubySdkUtil.getStubsDir(RUBYSIGS, RubySdkUtil.getRubysigsFolderName(level));
    }

    public static String getRubysigsFolderName(@NotNull LanguageLevel level) {
        if (level == null) {
            RubySdkUtil.$$$reportNull$$$0(40);
        }
        return RUBYSIGS + level.getCode();
    }

    public static String getRubysigsFolderName(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(41);
        }
        return RubySdkUtil.getRubysigsFolderName(RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk));
    }

    public static String getStubsFolderName(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(42);
        }
        return RubySdkUtil.getStubsFolderName(RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk));
    }

    public static String getStubsFolderName(LanguageLevel level) {
        return switch (level) {
            case LanguageLevel.RUBY34 -> RUBYSTUBS_DIR34;
            case LanguageLevel.RUBY33 -> RUBYSTUBS_DIR33;
            case LanguageLevel.RUBY32 -> RUBYSTUBS_DIR32;
            case LanguageLevel.RUBY31 -> RUBYSTUBS_DIR31;
            case LanguageLevel.RUBY30 -> RUBYSTUBS_DIR30;
            case LanguageLevel.RUBY27 -> RUBYSTUBS_DIR27;
            case LanguageLevel.RUBY26 -> RUBYSTUBS_DIR26;
            case LanguageLevel.RUBY25 -> RUBYSTUBS_DIR25;
            case LanguageLevel.RUBY24 -> RUBYSTUBS_DIR24;
            case LanguageLevel.RUBY23 -> RUBYSTUBS_DIR23;
            case LanguageLevel.RUBY22 -> RUBYSTUBS_DIR22;
            case LanguageLevel.RUBY21 -> RUBYSTUBS_DIR21;
            case LanguageLevel.RUBY20 -> RUBYSTUBS_DIR20;
            case LanguageLevel.RUBY19 -> RUBYSTUBS_DIR19;
            case LanguageLevel.RUBY18 -> RUBYSTUBS_DIR18;
            default -> throw new IllegalArgumentException("unexpected language level - " + String.valueOf(level));
        };
    }

    public static boolean isRuby18(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY18;
    }

    public static boolean isRuby19(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY19;
    }

    public static boolean isRuby20(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY20;
    }

    public static boolean isRuby21(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY21;
    }

    public static boolean isRuby22(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY22;
    }

    public static boolean isRuby23(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY23;
    }

    public static boolean isRuby24(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY24;
    }

    public static boolean isRuby25(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY25;
    }

    public static boolean isRuby26(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY26;
    }

    public static boolean isRuby27(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY27;
    }

    public static boolean isRuby30(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY30;
    }

    public static boolean isRuby31(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY31;
    }

    public static boolean isRuby32(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY32;
    }

    public static boolean isRuby33(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY33;
    }

    public static boolean isRuby34(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == LanguageLevel.RUBY34;
    }

    public static boolean isNativeRuby19(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby19(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby20(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby20(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby21(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby21(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby22(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby22(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby23(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby23(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby24(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby24(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby25(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby25(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby26(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby26(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby27(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby27(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby30(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby30(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby31(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby31(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby32(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby32(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby33(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby33(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby34(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby34(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isMRISdk(@Nullable Sdk sdk) {
        return sdk != null && "ruby".equals(RbConfig.notNullFrom(sdk).getNormalizeInstallName());
    }

    public static String getRubySdkIsntSetOrValideErrorText() {
        return RBundle.message((String)"progress.dialog.generate.common.help.no.sdk.set", (Object[])new Object[]{PlatformUtils.isRubyMine() ? RBundle.message((String)"progress.dialog.generate.common.help.no.sdk.set.rubymine", (Object[])new Object[]{CommonBundle.settingsActionPath()}) : RBundle.message((String)"progress.dialog.generate.common.help.no.sdk.set.ruby.plugin")});
    }

    public static boolean isMswin32(@Nullable String platform) {
        return platform != null && platform.contains("mswin32");
    }

    public static boolean isMingw32(@Nullable String platform) {
        return platform != null && platform.contains("mingw32");
    }

    private static boolean isCygwin(@Nullable String platform) {
        return platform != null && platform.contains("cygwin");
    }

    public static boolean isWindows(@Nullable String platform) {
        return RubySdkUtil.isMingw32(platform) || RubySdkUtil.isMswin32(platform) || RubySdkUtil.isCygwin(platform);
    }

    public static boolean isIronRuby(@Nullable Sdk sdk) {
        return sdk != null && RubyVersionUtil.isIronRuby(sdk.getVersionString());
    }

    public static boolean isMacRuby(@Nullable Sdk sdk) {
        return sdk != null && RubyVersionUtil.isMacRuby(sdk.getVersionString());
    }

    public static boolean isRubinius(@Nullable Sdk sdk) {
        return sdk != null && RubyVersionUtil.isRubinius(sdk.getVersionString());
    }

    public static boolean isMaglev(@Nullable Sdk sdk) {
        return sdk != null && RubyVersionUtil.isMaglev(sdk.getVersionString());
    }

    public static boolean equalSdks(@Nullable Sdk sdk1, @Nullable Sdk sdk2) {
        if (sdk1 == null || sdk2 == null) {
            return sdk1 == sdk2;
        }
        return sdk1.getSdkType() == sdk2.getSdkType() && StringUtil.equals((CharSequence)sdk1.getHomePath(), (CharSequence)sdk2.getHomePath()) && Objects.equals(sdk1.getSdkAdditionalData(), sdk2.getSdkAdditionalData());
    }

    @Contract(value="null, null -> null")
    @Nullable
    public static Sdk getEffectiveSdk(@Nullable Sdk sdk, @Nullable Module module) {
        return RubySdkUtil.isRubySDK(sdk) ? sdk : RModuleUtil.getInstance().findRubySdkForModule(module);
    }

    @Nullable
    public static Sdk getFileSdk(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            RubySdkUtil.$$$reportNull$$$0(43);
        }
        if (virtualFile == null) {
            RubySdkUtil.$$$reportNull$$$0(44);
        }
        return virtualFile.isInLocalFileSystem() ? RModuleUtil.getInstance().findRubySdkForVirtualFile(project, virtualFile) : null;
    }

    @NotNull
    private static Path getStubsDir(@NotNull String rubyStubsParentName, @NotNull String rubyStubsDirName) {
        if (rubyStubsParentName == null) {
            RubySdkUtil.$$$reportNull$$$0(45);
        }
        if (rubyStubsDirName == null) {
            RubySdkUtil.$$$reportNull$$$0(46);
        }
        Path root = RubySdkUtil.getStubsRoot(rubyStubsParentName);
        Path dir = root.resolve(rubyStubsDirName);
        LOGGER.assertTrue(Files.exists(dir, new LinkOption[0]), (Object)"Installation seems to be corrupted: %s directory cannot be null".formatted(dir));
        Path path = dir;
        if (path == null) {
            RubySdkUtil.$$$reportNull$$$0(47);
        }
        return path;
    }

    @NotNull
    private static Path getStubsRoot(@NotNull String rubyStubsParentName) {
        if (rubyStubsParentName == null) {
            RubySdkUtil.$$$reportNull$$$0(48);
        }
        if (PluginManagerCore.isRunningFromSources()) {
            if (PathUtil.getJarPathForClass(RubyUtil.class).endsWith(JAR)) {
                Path path = Path.of(PathManager.getHomePath(), new String[0]).resolve("ruby/backend").resolve(rubyStubsParentName);
                if (path == null) {
                    RubySdkUtil.$$$reportNull$$$0(49);
                }
                return path;
            }
            Path path = RubyUtil.getRubyPluginHomePath();
            if (path == null) {
                RubySdkUtil.$$$reportNull$$$0(50);
            }
            return path;
        }
        Path pluginHomePath = RubyUtil.getRubyPluginHomePath();
        Path rubyStubsDir = pluginHomePath.resolve(rubyStubsParentName);
        Path path = Files.exists(rubyStubsDir, new LinkOption[0]) ? rubyStubsDir : pluginHomePath;
        if (path == null) {
            RubySdkUtil.$$$reportNull$$$0(51);
        }
        return path;
    }

    @RequiresReadLock
    @Nullable
    public static Sdk findRubySdk(@NotNull Project project) {
        if (project == null) {
            RubySdkUtil.$$$reportNull$$$0(52);
        }
        ThreadingAssertions.softAssertReadAccess();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (!RubySdkUtil.isRubySDK(moduleSdk)) continue;
            return moduleSdk;
        }
        return null;
    }

    @RequiresReadLock
    @Nullable
    public static Sdk findRubySdk(@NotNull PsiElement element) {
        if (element == null) {
            RubySdkUtil.$$$reportNull$$$0(53);
        }
        ThreadingAssertions.softAssertReadAccess();
        Project project = element.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return RubySdkUtil.findRubySdk(module);
    }

    @RequiresReadLock
    @Nullable
    public static Sdk findRubySdk(@Nullable Module module) {
        Module module2;
        ThreadingAssertions.softAssertReadAccess();
        return RModuleUtil.getInstance().findRubySdkForModule(module2);
    }

    @Deprecated
    @RequiresReadLock
    @Nullable
    public static Sdk findRubySdk(@Nullable Module module, @Nullable Project project) {
        Module module2;
        ThreadingAssertions.softAssertReadAccess();
        return RubySdkUtil.findRubySdk(module2);
    }

    @NotNull
    public static String convertToRemote(@NotNull Sdk sdk, @Nullable Module module, @NotNull String localPath) {
        String canonicalLocalPath;
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(54);
        }
        if (localPath == null) {
            RubySdkUtil.$$$reportNull$$$0(55);
        }
        if (!RubyRemoteInterpreterManager.isRemoteSdk(sdk)) {
            String string = localPath;
            if (string == null) {
                RubySdkUtil.$$$reportNull$$$0(56);
            }
            return string;
        }
        String localCacheRoot = RubyRemoteSdkAdditionalData.getLocalGemsRootPath(sdk);
        String string = canonicalLocalPath = SystemInfo.isWindows ? RubyFileSystemUtil.tryResolveShortWindowsName(FileUtil.toCanonicalPath((String)localPath)) : FileUtil.toCanonicalPath((String)localPath);
        if (StringUtil.startsWith((CharSequence)canonicalLocalPath, (CharSequence)localCacheRoot)) {
            String string2 = FileUtil.toSystemIndependentName((String)canonicalLocalPath.substring(localCacheRoot.length()));
            if (string2 == null) {
                RubySdkUtil.$$$reportNull$$$0(57);
            }
            return string2;
        }
        String string3 = RubySdkUtil.getDefaultPathMappings(sdk, module).convertToRemote(canonicalLocalPath);
        if (string3 == null) {
            RubySdkUtil.$$$reportNull$$$0(58);
        }
        return string3;
    }

    @NotNull
    public static List<String> convertToRemote(@NotNull Sdk sdk, @Nullable Module module, @NotNull List<String> localPath) {
        if (sdk == null) {
            RubySdkUtil.$$$reportNull$$$0(59);
        }
        if (localPath == null) {
            RubySdkUtil.$$$reportNull$$$0(60);
        }
        List list = ContainerUtil.map(localPath, it -> RubySdkUtil.convertToRemote(sdk, module, it));
        if (list == null) {
            RubySdkUtil.$$$reportNull$$$0(61);
        }
        return list;
    }

    @NotNull
    public static List<Sdk> getAllRubySdks() {
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        sdks.addAll(ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)RubySdkType.getInstance()));
        sdks.addAll(ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JRubySdkType.getInstance()));
        ArrayList<Sdk> arrayList = sdks;
        if (arrayList == null) {
            RubySdkUtil.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 17, 24, 31, 34, 47, 49, 50, 51, 56, 57, 58, 61, 62 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: 
            case 6: 
            case 17: 
            case 24: 
            case 31: 
            case 34: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkUtil";
                break;
            }
            case 9: 
            case 13: 
            case 20: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 10: 
            case 14: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionName";
                break;
            }
            case 11: 
            case 15: 
            case 22: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 12: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRoots";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkData";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 36: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 43: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyStubsParentName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyStubsDirName";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsBinFolderPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubySdkAdditionalData";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateMockSdk";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createMockSdk";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMockSdkVersionManagerData";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findInterpreters";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsDir";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsRoot";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRemote";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRubySdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRubySdkDisposed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkIfRubySdkDisposed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGemsBinFolderPath";
                break;
            }
            case 3: 
            case 6: 
            case 17: 
            case 24: 
            case 31: 
            case 34: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRubySdkAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPathMappings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRootsWithAllGems";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateMockSdk";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sdkRootsEqual";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createMockSdk";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isMockSdk";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "computeMockSdkName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "computeMockSdkVersionManagerData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addToSourceAndClasses";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findInterpreters";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "unCygwinizePath";
                break;
            }
            case 36: 
            case 37: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getStubsDir";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getRubysigsDir";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRubysigsFolderName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getStubsFolderName";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getFileSdk";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getStubsRoot";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findRubySdk";
                break;
            }
            case 54: 
            case 55: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "convertToRemote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 17, 24, 31, 34, 47, 49, 50, 51, 56, 57, 58, 61, 62 -> new IllegalStateException(string);
        };
    }
}

