/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.NullableConsumer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.intellij.util.messages.Topic;
import icons.RubyIcons;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.ui.SdkComparator;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurableUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurationException;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkLoadPathInitializer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemData;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemVersionManagerHandler;

public class RubySdkType
extends SdkType {
    public static final Topic<SdkPathsInitializedListener> SDK_PATHS_INITIALIZED_TOPIC = Topic.create((String)"SDK_PATHS_INITIALIZED", SdkPathsInitializedListener.class);
    @NonNls
    public static final String GEMS_SUBDIR = "/gems";
    @NonNls
    public static final String MAGLEV_INTERPRETER_NAME = "maglev-ruby";
    protected static final Logger LOG = Logger.getInstance(RubySdkType.class);
    public static final NullableConsumer<String> DEFAULT_SDK_VALIDATION_CALLBACK = arg_0 -> ((Logger)LOG).warn(arg_0);
    @NonNls
    public static final String RUBY_DEFAULT_UNIX_HOME_PATH = "/usr/bin/ruby";
    @NonNls
    private static final String[] RUBY_UNIX_DEFAULT_HOME_PATHS = new String[]{"/usr/bin/ruby"};
    @NonNls
    private static final String[] RUBY_WIN_DEFAULT_HOME_PATHS = new String[]{"C:\\ruby\\bin\\ruby.exe"};
    @NonNls
    private static final String GET_VERSION_SCRIPT = "print RUBY_VERSION";
    @NonNls
    private static final String RUBY_SDK_NAME = "RUBY_SDK";
    @NonNls
    private static final String RUBY_SDKNAME_PREFIX = "ruby";
    @NonNls
    private static final String RUBY_INTERPRETER_NAME = "ruby";
    @NonNls
    private static final String RUBY_WIN_EXE = "ruby.exe";
    @NonNls
    private static final String RUBY_UNIX_EXE = "ruby";
    @NonNls
    private static final String IRON_RUBY_INTERPRETER_NAME_PREFIX = "ir";
    @NonNls
    private static final String MACRUBY_INTERPRETER_NAME = "macruby";
    @NonNls
    private static final String RUBINIUS_INTERPRETER_NAME = "rbx";
    @NonNls
    private static String RUBY_EXE;

    protected RubySdkType() {
        super(RUBY_SDK_NAME);
    }

    protected RubySdkType(@NotNull String type) {
        if (type == null) {
            RubySdkType.$$$reportNull$$$0(0);
        }
        super(type);
    }

    @NotNull
    public String getRubyExecutable() {
        String string = RUBY_EXE;
        if (string == null) {
            RubySdkType.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected String getSdkNamePrefix() {
        return "ruby";
    }

    protected String expectedExecutableName() {
        return "ruby";
    }

    @NonNls
    public String getBuiltinsName() {
        return "builtin.rb";
    }

    public boolean isValidInterpreter(@NotNull File existingCandidate, boolean isWindows) {
        if (existingCandidate == null) {
            RubySdkType.$$$reportNull$$$0(2);
        }
        return RubySdkType.isValidRubySdkInterpreter(existingCandidate, isWindows);
    }

    @NonNls
    @NotNull
    public String getGetVersionScript() {
        return GET_VERSION_SCRIPT;
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(this::doSuggestHomePath, RBundle.message((String)"sdk.ruby.scanning"), false, null);
        }
        return this.doSuggestHomePath();
    }

    @Nullable
    private String doSuggestHomePath() {
        Collection<String> candidates = this.suggestHomePaths();
        if (!candidates.isEmpty()) {
            return candidates.iterator().next();
        }
        return null;
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        Collection<String> collection = RubySdkUtil.suggestRubyHomePaths(RubySdkType.getInstance(), RUBY_WIN_DEFAULT_HOME_PATHS, RUBY_UNIX_DEFAULT_HOME_PATHS);
        if (collection == null) {
            RubySdkType.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Comparator<Sdk> getComparator() {
        SdkComparator sdkComparator = SdkComparator.SDK_COMPARATOR;
        if (sdkComparator == null) {
            RubySdkType.$$$reportNull$$$0(4);
        }
        return sdkComparator;
    }

    public final boolean isValidSdkHome(@NotNull String path) {
        if (path == null) {
            RubySdkType.$$$reportNull$$$0(5);
        }
        return this.isValidSdkHome(path, SystemInfo.isWindows);
    }

    public final boolean isValidSdkHome(@NotNull String path, boolean isWindows) {
        if (path == null) {
            RubySdkType.$$$reportNull$$$0(6);
        }
        File f = new File(path);
        if (RubyRemoteInterpreterManager.getInstance().isRemoteSdk(path)) {
            return this.isValidInterpreter(f, false);
        }
        return f.exists() && this.isValidInterpreter(f, isWindows);
    }

    public final boolean supportsCustomCreateUI() {
        return true;
    }

    public final void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            RubySdkType.$$$reportNull$$$0(7);
        }
        if (parentComponent == null) {
            RubySdkType.$$$reportNull$$$0(8);
        }
        if (sdkCreatedCallback == null) {
            RubySdkType.$$$reportNull$$$0(9);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        RelativePoint point = RelativePoint.getNorthWestOf((JComponent)parentComponent);
        Consumer<? super Sdk> callback = sdkCreatedCallback;
        if (parentComponent instanceof JComboBox) {
            point = RelativePoint.getSouthEastOf((JComponent)parentComponent);
            callback = sdk -> {
                String gemset = RVMSupportUtil.getGemsetName(sdk);
                if (RVMSupportUtil.isRVMInterpreter(sdk) && gemset != null) {
                    Sdk rootRVMSdk = RVMSupportUtil.findRootRVMSdk(sdk, List.of(sdkModel.getSdks()));
                    if (rootRVMSdk != null) {
                        RvmSdkRefresher.createRVMGemset(project, rootRVMSdk, gemset, (NullableConsumer<? super Sdk>)((NullableConsumer)sdkCreatedCallback::accept));
                    }
                } else {
                    sdkCreatedCallback.accept((Sdk)sdk);
                }
            };
        }
        Consumer<? super Sdk> sdkConsumer = callback;
        RubySdkConfigurableUtil.suggestAndAddSdk(project, sdkModel.getSdks(), point, (NullableConsumer<? super Sdk>)((NullableConsumer)sdk -> {
            if (sdk != null) {
                sdkConsumer.accept((Sdk)sdk);
            }
        }), selectedSdk, this);
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(10);
        }
        return RubyRemoteInterpreterManager.isRemoteSdk(sdk) || super.sdkHasValidPath(sdk);
    }

    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(11);
        }
        return RubyVersionUtil.createFakeVersionStringFromSdkName(sdk.getName());
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @NotNull String sdkHome) {
        String patchLevel;
        String version;
        if (sdkHome == null) {
            RubySdkType.$$$reportNull$$$0(12);
        }
        RubyLocalRunner runner = RubyLocalRunner.getRunner(null);
        try {
            version = this.getShortVersion(runner, sdkHome);
        }
        catch (Exception e) {
            version = null;
        }
        try {
            patchLevel = RubyVersionUtil.getPatchLevel(runner, sdkHome);
        }
        catch (Exception e) {
            patchLevel = null;
        }
        return this.createSuggestedSdkName(version, patchLevel);
    }

    @NotNull
    public final String createSuggestedSdkName(@Nullable String version, @Nullable String patchLevel) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getSdkNamePrefix());
        if (!StringUtil.isEmpty((String)version)) {
            buff.append("-").append(version);
            if (!StringUtil.isEmpty((String)patchLevel)) {
                buff.append("-p").append(patchLevel);
            }
        }
        String string = buff.toString();
        if (string == null) {
            RubySdkType.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(14);
        }
        if (sdkModel == null) {
            RubySdkType.$$$reportNull$$$0(15);
        }
        try {
            return super.setupSdkPaths(sdk, sdkModel);
        }
        catch (Exception e) {
            LOG.warn("Exception while configuring " + String.valueOf(sdk), (Throwable)e);
            return false;
        }
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        RubySdkAdditionalData sdkAdditionalData;
        RbConfig rbConfig;
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(16);
        }
        if ((rbConfig = (sdkAdditionalData = RubySdkType.getAdditionalDataWithLazyInitialization(sdk)).getRbConfig()).isEmpty()) {
            throw new RuntimeException("Unable to read RbConfig for " + String.valueOf(sdk));
        }
        try {
            RubySdkConfigurator.from(sdkAdditionalData).initSdk(sdk);
        }
        catch (RubySdkConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        sdkAdditionalData.myInitializedPaths = false;
        Runnable sdkInitRunnable = () -> {
            LOG.debug("Starting init for ", new Object[]{sdk});
            String fullVersion = RubyVersionUtil.getFullVersion(sdk, (NullableConsumer<? super String>)((NullableConsumer)msg -> {
                if (msg == null) {
                    return;
                }
                throw new RuntimeException((String)msg);
            }));
            DataManager.getInstance();
            VirtualFileManager.getInstance();
            RubySdkType.setupSdkPaths(sdk, fullVersion);
            LOG.debug("Ending init for ", new Object[]{sdk});
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            sdkInitRunnable.run();
        } else {
            RubySdkLoadPathInitializer.INSTANCE.scheduleInitialization(sdk, sdkInitRunnable);
        }
    }

    @NotNull
    private static RubySdkAdditionalData getAdditionalDataWithLazyInitialization(@NotNull Sdk sdk) {
        Object sdkAdditionalData;
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(17);
        }
        if ((sdkAdditionalData = sdk.getSdkAdditionalData()) != null) {
            assert (sdkAdditionalData instanceof RubySdkAdditionalData) : "RubySdkAdditionalData expected, got " + String.valueOf(sdkAdditionalData);
            RubySdkAdditionalData rubySdkAdditionalData = (RubySdkAdditionalData)((Object)sdkAdditionalData);
            if (rubySdkAdditionalData == null) {
                RubySdkType.$$$reportNull$$$0(18);
            }
            return rubySdkAdditionalData;
        }
        SdkModificator modificator = sdk.getSdkModificator();
        RubySystemData versionManagerSdkAdditionalData = RubySystemVersionManagerHandler.getInstance().createAdditionalData();
        sdkAdditionalData = new RubySdkAdditionalData().withVersionManagerSdkAdditionalData(versionManagerSdkAdditionalData);
        modificator.setSdkAdditionalData(sdkAdditionalData);
        WriteAction.run(() -> modificator.commitChanges());
        RubySdkAdditionalDataBase.modify((Sdk)sdk, additionalData -> RbConfig.init(additionalData, additionalData.getInterpreterPath(sdk)));
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        if (rubySdkAdditionalData == null) {
            RubySdkType.$$$reportNull$$$0(19);
        }
        return rubySdkAdditionalData;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            RubySdkType.$$$reportNull$$$0(20);
        }
        if (sdkModificator == null) {
            RubySdkType.$$$reportNull$$$0(21);
        }
        return new RubySdkConfigurable();
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            RubySdkType.$$$reportNull$$$0(22);
        }
        if (additional == null) {
            RubySdkType.$$$reportNull$$$0(23);
        }
        if (additionalData instanceof RubySdkAdditionalData) {
            ((RubySdkAdditionalData)additionalData).save(additional);
        }
    }

    @NotNull
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk sdk, @NotNull Element additional) {
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(24);
        }
        if (additional == null) {
            RubySdkType.$$$reportNull$$$0(25);
        }
        if (additional.getAttributes().isEmpty() && additional.getContent().isEmpty()) {
            RubySdkAdditionalDataBase rubySdkAdditionalDataBase = RubySdkAdditionalDataBase.getEmtpy();
            if (rubySdkAdditionalDataBase == null) {
                RubySdkType.$$$reportNull$$$0(26);
            }
            return rubySdkAdditionalDataBase;
        }
        String interpreterPath = sdk.getHomePath();
        assert (interpreterPath != null);
        if (RubyRemoteInterpreterManager.getInstance().isRemoteSdk(interpreterPath)) {
            RubyRemoteSdkAdditionalData rubyRemoteSdkAdditionalData = RubyRemoteSdkAdditionalData.loadRemote(interpreterPath, sdk, additional);
            if (rubyRemoteSdkAdditionalData == null) {
                RubySdkType.$$$reportNull$$$0(27);
            }
            return rubyRemoteSdkAdditionalData;
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.load(new RubySdkAdditionalData(), interpreterPath, sdk, additional);
        if (rubySdkAdditionalData == null) {
            RubySdkType.$$$reportNull$$$0(28);
        }
        return rubySdkAdditionalData;
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Element additional) {
        if (additional == null) {
            RubySdkType.$$$reportNull$$$0(29);
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = RBundle.message((String)"sdk.ruby.title");
        if (string == null) {
            RubySdkType.$$$reportNull$$$0(30);
        }
        return string;
    }

    public Icon getIcon() {
        return RubyIcons.Ruby.Ruby;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.ruby";
    }

    @Nullable
    public String getShortVersion(@NotNull RubyRunner runner, @NotNull String sdkHome) throws ExecutionException {
        if (runner == null) {
            RubySdkType.$$$reportNull$$$0(31);
        }
        if (sdkHome == null) {
            RubySdkType.$$$reportNull$$$0(32);
        }
        ProcessOutput output2 = runner.executeInSameThread(RubyRunnerExecutionContext.create(RunnerUtil.collectCommands(sdkHome, this.getGetVersionScript())));
        return RubyVersionUtil.getSDKVersionByOutput(output2, true, DEFAULT_SDK_VALIDATION_CALLBACK);
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                boolean valid;
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (files.length != 0 && !(valid = RubySdkType.this.isValidSdkHome(files[0].getPath()))) {
                    throw new Exception(RBundle.message((String)"sdk.error.invalid.interpreter.name", (Object[])new Object[]{files[0].getName(), RubySdkType.this.expectedExecutableName(), RubySdkType.this.getRubyExecutable()}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkType$1", "validateSelectedFiles"));
            }
        }.withTitle(RBundle.message((String)"ruby.ide.sdk.type.home.chooser.descriptor.title")).withShowHiddenFiles(SystemInfo.isUnix);
        if (fileChooserDescriptor2 == null) {
            RubySdkType.$$$reportNull$$$0(33);
        }
        return fileChooserDescriptor2;
    }

    @NotNull
    public String getHomeFieldLabel() {
        String string = RBundle.message((String)"ruby.ide.sdk.type.home.field.label");
        if (string == null) {
            RubySdkType.$$$reportNull$$$0(34);
        }
        return string;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            RubySdkType.$$$reportNull$$$0(35);
        }
        return type == OrderRootType.CLASSES;
    }

    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    public void createAndAddLocalSdk(@NotNull VirtualFile rubyInterpreter, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        if (rubyInterpreter == null) {
            RubySdkType.$$$reportNull$$$0(36);
        }
        if (versionManagerSdkAdditionalData == null) {
            RubySdkType.$$$reportNull$$$0(37);
        }
        ThreadingAssertions.assertNoReadAccess();
        Application application = ApplicationManager.getApplication();
        String interpreterPath = rubyInterpreter.getPath();
        if (!application.isUnitTestMode() && !new File(FileUtil.toSystemDependentName((String)interpreterPath)).exists()) {
            LOG.warn("Interpreter file is missing: " + String.valueOf(rubyInterpreter));
            return;
        }
        RubySdkAdditionalData additionalData = new RubySdkAdditionalData().withVersionManagerSdkAdditionalData(versionManagerSdkAdditionalData);
        RbConfig.init(additionalData, interpreterPath);
        if (additionalData.getRbConfig().isEmpty()) {
            LOG.warn("Can't create sdk for " + String.valueOf(rubyInterpreter) + "; Failed to load RBConfig");
            return;
        }
        VirtualFile sdkBinFolder = rubyInterpreter.getParent();
        VirtualFile sdkHomeFolder = sdkBinFolder.getParent();
        String sdkName = this.createSdkName(interpreterPath, sdkHomeFolder.getName(), versionManagerSdkAdditionalData);
        Sdk[] allSdks = ProjectJdkTable.getInstance().getAllJdks();
        Sdk sdk = SdkConfigurationUtil.setupSdk((Sdk[])allSdks, (VirtualFile)rubyInterpreter, (SdkType)this, (boolean)true, (SdkAdditionalData)additionalData, (String)sdkName);
        if (sdk == null) {
            LOG.warn("Sdk creation failed for " + String.valueOf(rubyInterpreter));
            return;
        }
        LOG.debug("Sdk creation current stacktrace: " + Arrays.toString(Thread.currentThread().getStackTrace()));
        application.invokeAndWait(() -> SdkConfigurationUtil.addSdk((Sdk)sdk));
    }

    @NotNull
    public String createSdkName(@NotNull String interpreterPath, String distributionId, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        if (interpreterPath == null) {
            RubySdkType.$$$reportNull$$$0(38);
        }
        if (versionManagerSdkAdditionalData == null) {
            RubySdkType.$$$reportNull$$$0(39);
        }
        for (SdkRefresher refresher : SdkRefresher.EP_NAME.getExtensionList()) {
            String sdkName = refresher.suggestSdkName(interpreterPath, distributionId, versionManagerSdkAdditionalData);
            if (sdkName == null) continue;
            String string = sdkName;
            if (string == null) {
                RubySdkType.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = this.suggestSdkName(null, interpreterPath);
        if (string == null) {
            RubySdkType.$$$reportNull$$$0(41);
        }
        return string;
    }

    public boolean isLocalSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(42);
        }
        return !RubyRemoteInterpreterManager.isRemoteSdk(sdk);
    }

    public static RubySdkType getInstance() {
        return (RubySdkType)SdkType.findInstance(RubySdkType.class);
    }

    @Nullable
    public static String getPlatform(@NotNull Sdk sdk) {
        SdkTypeId type;
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(43);
        }
        return (type = sdk.getSdkType()) instanceof RubySdkType ? RubySdkAdditionalData.notNullFrom(sdk).getPlatform() : null;
    }

    @NotNull
    static List<String> findGemsRoots(@NotNull SdkModificator sdkModificator) {
        VirtualFile[] roots;
        if (sdkModificator == null) {
            RubySdkType.$$$reportNull$$$0(44);
        }
        LinkedList<String> gemsRoots = new LinkedList<String>();
        for (VirtualFile root : roots = sdkModificator.getRoots(OrderRootType.SOURCES)) {
            String url = root.getUrl();
            if (!GemUtil.isGemsRootUrl(url)) continue;
            gemsRoots.add(url);
            sdkModificator.removeRoot(root, OrderRootType.CLASSES);
            sdkModificator.removeRoot(root, OrderRootType.SOURCES);
        }
        LinkedList<String> linkedList = gemsRoots;
        if (linkedList == null) {
            RubySdkType.$$$reportNull$$$0(45);
        }
        return linkedList;
    }

    public static boolean isValidRubySdkInterpreter(@NotNull File existingCandidate, boolean isWindows) {
        if (existingCandidate == null) {
            RubySdkType.$$$reportNull$$$0(46);
        }
        String exeName = StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)existingCandidate.getName()));
        String fullName = StringUtil.toLowerCase((String)existingCandidate.getName());
        if (isWindows && !fullName.endsWith(".exe") && !fullName.endsWith(".bat") && !fullName.endsWith(".cmd")) {
            return false;
        }
        return (exeName.startsWith("ruby") || exeName.startsWith(IRON_RUBY_INTERPRETER_NAME_PREFIX) || exeName.startsWith(RUBINIUS_INTERPRETER_NAME) || exeName.startsWith(MACRUBY_INTERPRETER_NAME) || exeName.startsWith("truffleruby") || exeName.startsWith(MAGLEV_INTERPRETER_NAME)) && !JRubySdkType.isValidJrubySdkInterpreter(existingCandidate, isWindows);
    }

    private static void setupSdkPaths(@NotNull Sdk sdk, String fullVersion) {
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(47);
        }
        RubySdkAdditionalData sdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        Set<String> urls = RubySdkType.buildSdkLoadpath(sdk);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        List roots = urls.stream().map(arg_0 -> ((VirtualFileManager)virtualFileManager).findFileByUrl(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        sdkAdditionalData.myTemporaryRoots = roots;
        ApplicationManager.getApplication().invokeLater(() -> {
            LOG.debug("Enter transaction for ", new Object[]{sdk});
            if (RubySdkUtil.isRubySdkDisposed(sdk)) {
                return;
            }
            SdkModificator sdkModificator = sdk.getSdkModificator();
            for (VirtualFile virtualFile : roots) {
                RubySdkUtil.addToSourceAndClasses(sdkModificator, virtualFile);
            }
            sdkModificator.setVersionString(fullVersion);
            LOG.debug("Request write action");
            WriteAction.run(() -> ((SdkModificator)sdkModificator).commitChanges());
            sdkAdditionalData.myInitializedPaths = true;
            sdkAdditionalData.myTemporaryRoots = null;
            ((SdkPathsInitializedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SDK_PATHS_INITIALIZED_TOPIC)).sdkPathsInitialized(sdk);
            LOG.debug("End of write action and flush for ", new Object[]{sdkModificator});
        });
    }

    public static Set<String> buildSdkLoadpath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(48);
        }
        return RubySdkAdditionalData.notNullFrom(sdk).buildSdkLoadPath(sdk);
    }

    public static void addRubyStubsUrls(Set<String> urls, @NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkType.$$$reportNull$$$0(49);
        }
        Path stubsDirPath = RubySdkUtil.getStubsDir(sdk);
        try {
            URL url = stubsDirPath.toUri().toURL();
            urls.add(VfsUtilCore.convertFromUrl((URL)url));
        }
        catch (MalformedURLException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public static ArrayList<Sdk> getAllValidRubySdks() {
        Sdk[] allSdk;
        ArrayList<Sdk> foundSdks = new ArrayList<Sdk>();
        for (Sdk sdk : allSdk = ProjectJdkTable.getInstance().getAllJdks()) {
            if (!RubySdkUtil.isSDKValid(sdk)) continue;
            foundSdks.add(sdk);
        }
        ArrayList<Sdk> arrayList = foundSdks;
        if (arrayList == null) {
            RubySdkType.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    public static boolean hasValidRubySdk() {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!RubySdkUtil.isSDKValid(sdk)) continue;
            return true;
        }
        return false;
    }

    static {
        if (SystemInfo.isWindows) {
            RUBY_EXE = RUBY_WIN_EXE;
        } else if (SystemInfo.isUnix) {
            RUBY_EXE = "ruby";
        } else {
            LOG.error(RBundle.message((String)"os.not.supported"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 13, 18, 19, 26, 27, 28, 30, 33, 34, 40, 41, 45, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 13: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 40: 
            case 41: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkType";
                break;
            }
            case 2: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingCandidate";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 24: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 21: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 23: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyInterpreter";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyExecutable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuggestedSdkName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalDataWithLazyInitialization";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAdditionalData";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeFieldLabel";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkName";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findGemsRoots";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValidRubySdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 13: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 40: 
            case 41: 
            case 45: 
            case 50: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidInterpreter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalDataWithLazyInitialization";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 24: 
            case 25: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getShortVersion";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddLocalSdk";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createSdkName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findGemsRoots";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isValidRubySdkInterpreter";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkLoadpath";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addRubyStubsUrls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 13, 18, 19, 26, 27, 28, 30, 33, 34, 40, 41, 45, 50 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface SdkPathsInitializedListener {
        public void sdkPathsInitialized(@NotNull Sdk var1);
    }
}

