/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.progress.CancellationUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public enum RubySdkLoadPathInitializer {
    INSTANCE;

    private static final Logger LOG;
    private final ThreadPoolExecutor myExecutor = new ThreadPoolExecutor(this, 1, 1, 1L, TimeUnit.SECONDS, new PriorityBlockingQueue()){
        private final AtomicInteger myCurrentPriority = new AtomicInteger(0);

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            if (runnable instanceof PriorityFutureTask) {
                ((PriorityFutureTask)runnable).setPriority(this.myCurrentPriority.incrementAndGet());
                return (RunnableFuture)runnable;
            }
            return new PriorityFutureTask<T>(runnable, value, this.myCurrentPriority.incrementAndGet());
        }
    };
    private final Map<Sdk, Future<?>> myFutureMap = Collections.synchronizedMap(new HashMap());

    @NotNull
    Future<?> scheduleInitialization(@NotNull Sdk sdk, @NotNull Runnable runnable) {
        if (sdk == null) {
            RubySdkLoadPathInitializer.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            RubySdkLoadPathInitializer.$$$reportNull$$$0(1);
        }
        Future<?> future = this.myExecutor.submit(runnable);
        this.myFutureMap.put(sdk, future);
        Future<?> future2 = future;
        if (future2 == null) {
            RubySdkLoadPathInitializer.$$$reportNull$$$0(2);
        }
        return future2;
    }

    void requestInitializationSynchronized(@NotNull Sdk sdk) throws ProcessCanceledException {
        block9: {
            if (sdk == null) {
                RubySdkLoadPathInitializer.$$$reportNull$$$0(3);
            }
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            Future<?> futureNeeded = this.myFutureMap.get(sdk);
            if (!(futureNeeded instanceof PriorityFutureTask)) {
                throw new IllegalStateException("Sdk " + String.valueOf(sdk) + " should have tried to initialize itself, future is " + String.valueOf(futureNeeded));
            }
            try {
                if (this.myExecutor.remove((PriorityFutureTask)futureNeeded)) {
                    this.scheduleInitialization(sdk, (PriorityFutureTask)futureNeeded).get();
                    break block9;
                }
                try {
                    CancellationUtil.getCancellable(futureNeeded);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        LOG = Logger.getInstance(RubySdkLoadPathInitializer.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkLoadPathInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkLoadPathInitializer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleInitialization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scheduleInitialization";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requestInitializationSynchronized";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class PriorityFutureTask<T>
    extends FutureTask<T>
    implements Comparable<PriorityFutureTask<T>> {
        private volatile int myPriority;
        private Runnable myRunnable;

        private PriorityFutureTask(Runnable runnable, T value, int priority) {
            super(runnable, value);
            this.myRunnable = runnable;
            this.myPriority = priority;
        }

        public Runnable getRunnable() {
            return this.myRunnable;
        }

        public void setPriority(int priority) {
            this.myPriority = priority;
        }

        @Override
        protected void done() {
            this.myRunnable = null;
        }

        @Override
        public int compareTo(PriorityFutureTask<T> o) {
            return -(this.myPriority - o.myPriority);
        }
    }
}

