/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.gem.inspection.quickfixes.RunBundlerInstallQuickFix;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurationException;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkTransfer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;

public abstract class RubySdkConfigurator<T extends RubySdkAdditionalData> {
    private static final Logger LOG = Logger.getInstance(RubySdkConfigurator.class);
    private static final ExtensionPointName<RubySdkConfigurator> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.rubySdkConfigurator");
    protected static final String LOCALHOST = "127.0.0.1";

    public abstract boolean supports(@NotNull SdkAdditionalData var1);

    @NotNull
    public abstract RubyAbstractRunner buildRunner(@NotNull RubySdkAdditionalData var1, @Nullable Module var2);

    @NotNull
    public abstract RubySdkTransfer buildSdkTransfer(@Nullable Project var1, @NotNull Sdk var2) throws ExecutionException, InterruptedException;

    public void initSdk(@NotNull Sdk sdk) throws RubySdkConfigurationException {
        if (sdk == null) {
            RubySdkConfigurator.$$$reportNull$$$0(0);
        }
        RubySdkAdditionalDataBase.modify((Sdk)sdk, sdkAdditionalData -> {
            RubyGemsEnvironment gemsEnvironment;
            String interpreterPath = sdkAdditionalData.getInterpreterPath(sdk);
            String versionString = RubySdkType.getInstance().getVersionString(interpreterPath);
            sdkAdditionalData.setNormalizedVersionString(versionString);
            if (SystemInfo.isWindows && !ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    sdkAdditionalData.setPlatform(RubyVersionUtil.extractPlatformFromVersion(RubyVersionUtil.getFullVersion(sdkAdditionalData.getRunner(null), interpreterPath, false)));
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            }
            if ((gemsEnvironment = this.getEnvironment(sdk)).isEmpty()) {
                throw new RubySdkConfigurationException("Could not get RubyGems environment for " + String.valueOf(sdk));
            }
            String executableDirectory = gemsEnvironment.getExecutableDirectory();
            if (StringUtil.isEmpty((String)executableDirectory)) {
                LOG.warn("No EXECUTABLE DIRECTORY: " + String.valueOf(gemsEnvironment));
                throw new RubySdkConfigurationException("No EXECUTABLE DIRECTORY in `gem env` response, see logs for more details");
            }
            sdkAdditionalData.setGemsBinDirectory(Objects.requireNonNull(executableDirectory));
            sdkAdditionalData.setGemsRootUrls(Collections.emptyList());
            sdkAdditionalData.setLanguageLevel(RubyVersionUtil.extractLanguageLevelFromRbConfigVersion(sdkAdditionalData.getRbConfig().getRubyVersion()));
        });
    }

    @NotNull
    protected RubyGemsEnvironment getEnvironment(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkConfigurator.$$$reportNull$$$0(1);
        }
        RubyGemsEnvironment rubyGemsEnvironment = RubyGemsEnvironment.get(sdk);
        if (rubyGemsEnvironment == null) {
            RubySdkConfigurator.$$$reportNull$$$0(2);
        }
        return rubyGemsEnvironment;
    }

    @NotNull
    public List<LocalQuickFix> getBundleInstallQuickFixes(@NotNull Sdk sdk, @NotNull Module module) {
        if (sdk == null) {
            RubySdkConfigurator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            RubySdkConfigurator.$$$reportNull$$$0(4);
        }
        List<LocalQuickFix> list = Collections.singletonList(new RunBundlerInstallQuickFix(module));
        if (list == null) {
            RubySdkConfigurator.$$$reportNull$$$0(5);
        }
        return list;
    }

    protected void doCheckSdkAdditionalData(@NotNull RubySdkAdditionalData additionalData) {
        if (additionalData == null) {
            RubySdkConfigurator.$$$reportNull$$$0(6);
        }
    }

    public abstract boolean supportsGenericCoverageRunning();

    @NotNull
    public abstract String getHost(@NotNull SdkAdditionalData var1);

    @NotNull
    public static <T extends RubySdkAdditionalData> RubySdkConfigurator<T> notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkConfigurator.$$$reportNull$$$0(7);
        }
        RubySdkConfigurator<Sdk> rubySdkConfigurator = Objects.requireNonNull(RubySdkConfigurator.from(sdk));
        if (rubySdkConfigurator == null) {
            RubySdkConfigurator.$$$reportNull$$$0(8);
        }
        return rubySdkConfigurator;
    }

    @Contract(value="null -> null")
    @Nullable
    public static <T extends RubySdkAdditionalData> RubySdkConfigurator<T> from(@Nullable Sdk sdk) {
        if (sdk == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof RubySdkAdditionalData)) {
            return null;
        }
        return RubySdkConfigurator.from((RubySdkAdditionalData)sdkAdditionalData);
    }

    @NotNull
    public static <T extends RubySdkAdditionalData> RubySdkConfigurator<T> from(@NotNull T sdkAdditionalData) {
        if (sdkAdditionalData == null) {
            RubySdkConfigurator.$$$reportNull$$$0(9);
        }
        for (RubySdkConfigurator sdkConfigurator : EP_NAME.getExtensionList()) {
            if (!sdkConfigurator.supports((SdkAdditionalData)sdkAdditionalData)) continue;
            RubySdkConfigurator rubySdkConfigurator = sdkConfigurator;
            if (rubySdkConfigurator == null) {
                RubySdkConfigurator.$$$reportNull$$$0(10);
            }
            return rubySdkConfigurator;
        }
        throw new RuntimeException("Unable to find SdkConfigurator for " + String.valueOf(sdkAdditionalData));
    }

    public static void checkSdkAdditionalData(@NotNull RubySdkAdditionalData additionalData) {
        if (additionalData == null) {
            RubySdkConfigurator.$$$reportNull$$$0(11);
        }
        RubySdkConfigurator.from(additionalData).doCheckSdkAdditionalData(additionalData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleInstallQuickFixes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBundleInstallQuickFixes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCheckSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkSdkAdditionalData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 10 -> new IllegalStateException(string);
        };
    }
}

