/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.ui.RubySdkCustomConfiguratorDialog;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherUtilKt;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemVersionManagerHandler;

public final class RubySdkConfigurableUtil {
    private static final Logger LOG = Logger.getInstance(RubySdkConfigurableUtil.class);

    private RubySdkConfigurableUtil() {
    }

    public static void suggestAndAddSdk(@Nullable Project project, Sdk @NotNull [] existingSdks, @NotNull RelativePoint point, @NotNull NullableConsumer<? super Sdk> callback, @Nullable Sdk selectedSdk, SdkType ... sdkTypes) {
        if (point == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(1);
        }
        if (existingSdks == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(2);
        }
        if (sdkTypes == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(3);
        }
        assert (sdkTypes.length > 0);
        MultiMap suggestedSdkHomes = MultiMap.createLinked();
        for (SdkType sdkType : sdkTypes) {
            for (String sdkHome : RubySdkConfigurableUtil.getUnusedSdkPaths(sdkType, existingSdks, sdkType.suggestHomePaths())) {
                suggestedSdkHomes.putValue((Object)sdkHome, (Object)sdkType);
            }
        }
        List<SdkType> sdkTypesList = List.of(sdkTypes);
        suggestedSdkHomes.put((Object)RBundle.message((String)"ruby.ide.sdk.configurable.new.local"), sdkTypesList);
        suggestedSdkHomes.put((Object)RBundle.message((String)"ruby.ide.sdk.configurable.new.local.version.manager"), sdkTypesList);
        suggestedSdkHomes.put((Object)RBundle.message((String)"ruby.ide.sdk.configurable.new.local.with.configuration.script"), sdkTypesList);
        suggestedSdkHomes.put((Object)RBundle.message((String)"ruby.ide.sdk.configurable.new.remote"), sdkTypesList);
        if (suggestedSdkHomes.size() > 1) {
            RubySdkConfigurableUtil.showSuggestedHomesPopup(project, existingSdks, (MultiMap<String, SdkType>)suggestedSdkHomes, point, callback);
        } else {
            SdkConfigurationUtil.createSdk((Project)project, (Sdk[])existingSdks, callback, (SdkType[])sdkTypes);
        }
    }

    private static void showSuggestedHomesPopup(final @Nullable Project project, final Sdk @NotNull [] existingSdks, final @NotNull MultiMap<String, SdkType> suggestedSdkHomes, @NotNull RelativePoint point, final @NotNull NullableConsumer<? super Sdk> callback) {
        if (suggestedSdkHomes == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(4);
        }
        if (point == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(6);
        }
        if (existingSdks == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(7);
        }
        ArrayList list = new ArrayList(suggestedSdkHomes.keySet());
        BaseListPopupStep<String> sdkHomesStep = new BaseListPopupStep<String>(null, list){

            @NotNull
            public String getTextFor(String value) {
                String string = FileUtil.toSystemDependentName((String)value);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    SdkType[] sdkTypes = suggestedSdkHomes.get((Object)selectedValue).toArray(new SdkType[0]);
                    if (RBundle.message((String)"ruby.ide.sdk.configurable.new.local").equals(selectedValue)) {
                        ApplicationManager.getApplication().invokeLater(() -> SdkConfigurationUtil.createSdk((Project)project, (Sdk[])existingSdks, (NullableConsumer)callback, (boolean)false, (SdkType[])sdkTypes), ModalityState.current());
                    } else if (RBundle.message((String)"ruby.ide.sdk.configurable.new.local.version.manager").equals(selectedValue)) {
                        SdkRefresherUtilKt.chooseCustomManagerLocation(project);
                    } else if (RBundle.message((String)"ruby.ide.sdk.configurable.new.local.with.configuration.script").equals(selectedValue)) {
                        ApplicationManager.getApplication().invokeLater(() -> RubySdkConfigurableUtil.createSdkWithCustomEnvironment(project, existingSdks, (NullableConsumer<? super Sdk>)callback, sdkTypes[0]), ModalityState.current());
                    } else if (RBundle.message((String)"ruby.ide.sdk.configurable.new.remote").equals(selectedValue)) {
                        RubyRemoteInterpreterManager remoteInterpreterManager = RubyRemoteInterpreterManager.getInstance();
                        if (remoteInterpreterManager.isEnabled()) {
                            Sdk sdk = remoteInterpreterManager.addRemoteSdk(project, Collections.unmodifiableCollection(Arrays.asList(existingSdks)), sdkTypes);
                            callback.consume((Object)sdk);
                        } else {
                            Messages.showErrorDialog((String)RBundle.message((String)"ruby.ide.sdk.configurable.create.remote.host.warning", (Object[])new Object[]{ShowSettingsUtil.getSettingsMenuName()}), (String)RBundle.message((String)"ruby.ide.sdk.configurable.create.remote.host.warning.title"));
                        }
                    } else {
                        if (sdkTypes.length <= 0) {
                            LOG.error("Sdk type must be selected.");
                            return;
                        }
                        VirtualFile homeDir = RubySdkConfigurableUtil.findSdkHomeDir(selectedValue);
                        if (homeDir == null) {
                            return;
                        }
                        callback.consume((Object)SdkConfigurationUtil.setupSdk((Sdk[])existingSdks, (VirtualFile)homeDir, (SdkType)sdkTypes[0], (boolean)false, null, null));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurableUtil$1", "getTextFor"));
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
        popup.show(point);
    }

    public static void onCreateNewRvmGemsetItemClicked(SdkType @NotNull [] sdkTypes, Sdk @NotNull [] existingSdks, @Nullable Project project, @Nullable Sdk selectedSdk, @NotNull NullableConsumer<? super Sdk> callback) {
        if (callback == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(8);
        }
        if (sdkTypes == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(9);
        }
        if (existingSdks == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(10);
        }
        Sdk[] sdksOfType = (Sdk[])Arrays.stream(existingSdks).filter(sdk -> ContainerUtil.exists((Object[])sdkTypes, sdkType1 -> sdkType1 == sdk.getSdkType())).toArray(Sdk[]::new);
        Sdk preferableRVMSdk = RVMSupportUtil.getPreferableRVMSdk(project, sdksOfType, selectedSdk);
        RVMSupportUtil.showNewRVMGemsetDialog(project, preferableRVMSdk, sdksOfType, callback);
    }

    private static void createSdkWithCustomEnvironment(@Nullable Project project, Sdk @NotNull [] existingSdks, @NotNull NullableConsumer<? super Sdk> callback, @NotNull SdkType sdkType) {
        if (callback == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(11);
        }
        if (sdkType == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(12);
        }
        if (existingSdks == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(13);
        }
        Sdk sdk = null;
        String homePath = "";
        List<String> configuratorAndArguments = ContainerUtil.emptyList();
        boolean dialogReopened = false;
        while (sdk == null) {
            RubySdkCustomConfiguratorDialog dialog = new RubySdkCustomConfiguratorDialog(project, dialogReopened);
            dialogReopened = true;
            dialog.show(homePath, configuratorAndArguments);
            if (!dialog.isOK()) break;
            homePath = dialog.getInterpreterPath();
            VirtualFile sdkHome = RubySdkConfigurableUtil.findSdkHomeDir(homePath);
            if (sdkHome == null) {
                return;
            }
            configuratorAndArguments = dialog.getConfiguratorAndArguments();
            RubySdkAdditionalData additionalData = new RubySdkAdditionalData().withVersionManagerSdkAdditionalData(RubySystemVersionManagerHandler.getInstance().createAdditionalData(configuratorAndArguments));
            RbConfig.init(additionalData, homePath);
            String sdkName = sdkType.suggestSdkName(null, homePath) + " (" + (String)ParametersListUtil.DEFAULT_LINE_JOINER.fun(configuratorAndArguments) + ")";
            sdk = SdkConfigurationUtil.setupSdk((Sdk[])existingSdks, (VirtualFile)sdkHome, (SdkType)sdkType, (boolean)false, (SdkAdditionalData)additionalData, (String)sdkName);
        }
        callback.consume(sdk);
    }

    @Nullable
    private static VirtualFile findSdkHomeDir(@NotNull String homePath) {
        VirtualFile homeDir;
        if (homePath == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(14);
        }
        if ((homeDir = LocalFileSystem.getInstance().findFileByPath(homePath)) == null) {
            LOG.debug("Home directory " + homePath + " wasn't found.");
        }
        return homeDir;
    }

    @NotNull
    private static List<String> getUnusedSdkPaths(@NotNull SdkType sdkType, Sdk @NotNull [] existingSdks, @NotNull Collection<String> sdkHomes) {
        if (sdkType == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(15);
        }
        if (sdkHomes == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(16);
        }
        if (existingSdks == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(17);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String sdkHome : sdkHomes) {
            if (RubySdkConfigurableUtil.findSdkWithoutCustomConfiguratorByPath(sdkType, existingSdks, sdkHome) != null) continue;
            result.add(sdkHome);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Nullable
    private static Sdk findSdkWithoutCustomConfiguratorByPath(@NotNull SdkType sdkType, Sdk @NotNull [] existingSdks, @NotNull String sdkHome) {
        if (sdkType == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(19);
        }
        if (sdkHome == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(20);
        }
        if (existingSdks == null) {
            RubySdkConfigurableUtil.$$$reportNull$$$0(21);
        }
        for (Sdk sdk : existingSdks) {
            String path = sdk.getHomePath();
            if (sdk.getSdkType() != sdkType || path == null || !FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path), (String)FileUtil.toSystemIndependentName((String)sdkHome)) || RubySystemVersionManagerHandler.hasCustomConfigurator(sdk)) continue;
            return sdk;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedSdkHomes";
                break;
            }
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurableUtil";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurableUtil";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedSdkPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestAndAddSdk";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showSuggestedHomesPopup";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onCreateNewRvmGemsetItemClicked";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSdkWithCustomEnvironment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSdkHomeDir";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedSdkPaths";
                break;
            }
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findSdkWithoutCustomConfiguratorByPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }
}

