/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.ui.RubySdkConfigurablePanel;

public class RubySdkConfigurable
implements AdditionalDataConfigurable {
    private Sdk mySdk;
    private final RubySdkConfigurablePanel myRubyConfigurablePanel = new RubySdkConfigurablePanel();

    public void setSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkConfigurable.$$$reportNull$$$0(0);
        }
        this.mySdk = sdk;
        this.myRubyConfigurablePanel.setLanguageLevel(RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)this.mySdk));
    }

    public JComponent createComponent() {
        return this.myRubyConfigurablePanel.getPanel();
    }

    public boolean isModified() {
        return !RubySdkUtil.getGemsBinFolderPath(this.mySdk).equals(this.myRubyConfigurablePanel.getGemsBinFolder()) || this.myRubyConfigurablePanel.getLanguageLevel() != RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)this.mySdk);
    }

    public void apply() {
        String newGemsBinFolder = this.myRubyConfigurablePanel.getGemsBinFolder();
        RubySdkAdditionalDataBase.modify((Sdk)this.mySdk, it -> it.setGemsBinDirectory(newGemsBinFolder));
        LanguageLevel oldLanguageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)this.mySdk);
        LanguageLevel newLanguageLevel = this.myRubyConfigurablePanel.getLanguageLevel();
        RubySdkAdditionalDataBase.modify((Sdk)this.mySdk, data -> data.setLanguageLevel(newLanguageLevel));
        RubyLanguageLevelPusher.pushLanguageLevelIfNeeded(oldLanguageLevel, newLanguageLevel, ProjectManager.getInstance().getOpenProjects());
        RubySdkGemLibraryManager.getInstance().refresh();
    }

    public void reset() {
        this.myRubyConfigurablePanel.setGemsBinFolder(RubySdkUtil.getGemsBinFolderPath(this.mySdk));
        this.myRubyConfigurablePanel.getPanel().repaint();
    }

    public void disposeUIResources() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurable", "setSdk"));
    }
}

