/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.SdkAdditionalDataBase;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.LocalRubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.RubyImplementationHandler;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSettings;

public class RubySdkAdditionalData
extends SdkAdditionalDataBase
implements RubySdkAdditionalDataBase {
    @NonNls
    private static final String PLATFORM = "PLATFORM";
    @NonNls
    private static final String GEMS_BIN_DIR_PATH = "GEMS_BIN_DIR_PATH";
    @NonNls
    private static final String GEMS_ROOTS_URLS_ROOT = "GEMS_ROOTS_URLS_ROOT";
    @NonNls
    private static final String GEMS_ROOTS_URL = "GEMS_ROOTS_URL";
    @NonNls
    private static final String NORMALIZED_VERSION_STRING = "NORMALIZED_VERSION_STRING";
    protected static final Logger LOG = Logger.getInstance(RubySdkAdditionalData.class);
    volatile transient boolean myInitializedPaths;
    @Nullable
    volatile transient List<VirtualFile> myTemporaryRoots;
    @Nullable
    private String myGemsBinDirectory;
    private List<String> myGemsRootsUrls;
    @NotNull
    private LanguageLevel myLanguageLevel;
    private String myPlatform;
    @Nullable
    private RubyVersionManagerSdkData myVersionManagerSdkAdditionalData;
    @Nullable
    private RbConfig myRbConfig;
    @Nullable
    private String myNormalizedVersionString;

    protected RubySdkAdditionalData() {
        this.myInitializedPaths = true;
        this.myTemporaryRoots = null;
    }

    public RubySdkAdditionalData(@NotNull RubySdkAdditionalData original) {
        if (original == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(0);
        }
        this.myInitializedPaths = true;
        this.myTemporaryRoots = null;
        this.myInitializedPaths = original.myInitializedPaths;
        this.myTemporaryRoots = RubySdkAdditionalData.copyIfNotNull(original.myTemporaryRoots);
        this.myGemsBinDirectory = original.myGemsBinDirectory;
        this.myGemsRootsUrls = RubySdkAdditionalData.copyIfNotNull(original.myGemsRootsUrls);
        this.myLanguageLevel = original.myLanguageLevel;
        this.myPlatform = original.myPlatform;
        this.myVersionManagerSdkAdditionalData = Objects.requireNonNull(original.myVersionManagerSdkAdditionalData).copy();
        this.myNormalizedVersionString = original.myNormalizedVersionString;
        this.myRbConfig = original.myRbConfig;
    }

    @Contract(pure=true, value="null->null; !null -> !null")
    @Nullable
    private static <T> List<T> copyIfNotNull(@Nullable List<T> original) {
        return original == null ? null : new ArrayList<T>(original);
    }

    @NotNull
    public RubyVersionManagerSdkData getVersionManagerSdkAdditionalData() {
        RubyVersionManagerSdkData rubyVersionManagerSdkData = Objects.requireNonNull(this.myVersionManagerSdkAdditionalData, "Attempt to fetch data before initialization");
        if (rubyVersionManagerSdkData == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(1);
        }
        return rubyVersionManagerSdkData;
    }

    @NotNull
    public RbConfig getRbConfig() {
        RbConfig rbConfig = (RbConfig)ObjectUtils.notNull((Object)this.myRbConfig, (Object)RbConfig.EMPTY_CONFIG);
        if (rbConfig == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(2);
        }
        return rbConfig;
    }

    public void setRbConfig(@NotNull RbConfig rbConfig) {
        if (rbConfig == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(3);
        }
        this.assertWritable();
        this.myRbConfig = rbConfig;
    }

    @NotNull
    public RubySdkAdditionalData withVersionManagerSdkAdditionalData(@NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        if (versionManagerSdkAdditionalData == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(4);
        }
        this.assertWritable();
        this.myVersionManagerSdkAdditionalData = versionManagerSdkAdditionalData;
        RubySdkAdditionalData rubySdkAdditionalData = this;
        if (rubySdkAdditionalData == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(5);
        }
        return rubySdkAdditionalData;
    }

    @NotNull
    public String getGemsBinDirectory() {
        String string = Objects.requireNonNull(this.myGemsBinDirectory, "Attempt to fetch data before initialization");
        if (string == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setGemsBinDirectory(@NotNull String path) {
        if (path == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(7);
        }
        this.assertWritable();
        this.myGemsBinDirectory = path;
    }

    @Contract(pure=true)
    public boolean hasGemsBinDirectory() {
        return this.myGemsBinDirectory != null;
    }

    public List<String> getGemsRootUrls() {
        return this.getRunner(null).customizeGemsRootUrls(this.myGemsRootsUrls);
    }

    public void setGemsRootUrls(@NotNull List<String> urls) {
        if (urls == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(8);
        }
        this.assertWritable();
        this.myGemsRootsUrls = Collections.unmodifiableList(urls);
    }

    public void checkValid(SdkModel sdkModel) throws ConfigurationException {
        File file = new File(this.getGemsBinDirectory());
        if (!file.exists()) {
            throw new ConfigurationException(RBundle.message((String)"sdk.error.gems.bindir.doesnt.exist"));
        }
        if (!file.isDirectory()) {
            throw new ConfigurationException(RBundle.message((String)"sdk.error.gems.bindir.isnt.directory"));
        }
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(9);
        }
        if (this.myNormalizedVersionString != null) {
            rootElement.setAttribute(NORMALIZED_VERSION_STRING, this.myNormalizedVersionString);
        }
        if (this.getPlatform() != null) {
            rootElement.setAttribute(PLATFORM, this.getPlatform());
        }
        assert (this.myVersionManagerSdkAdditionalData != null);
        this.myVersionManagerSdkAdditionalData.save(rootElement);
        this.getRbConfig().save(rootElement);
        if (this.myGemsBinDirectory != null) {
            rootElement.setAttribute(GEMS_BIN_DIR_PATH, this.getGemsBinDirectory());
        }
        if (this.myGemsRootsUrls != null) {
            for (String url : this.myGemsRootsUrls) {
                Element child = new Element(GEMS_ROOTS_URLS_ROOT);
                child.setAttribute(GEMS_ROOTS_URL, url);
                rootElement.addContent(child);
            }
        }
    }

    @NotNull
    public String getInterpreterPath(@NotNull Sdk sdk) {
        SdkAdditionalData additionalData;
        if (sdk == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(10);
        }
        if (!this.equals(additionalData = sdk.getSdkAdditionalData())) {
            LOG.error("Looks like inconsistent additional data for local sdk in " + String.valueOf(sdk) + "; this: " + String.valueOf((Object)this) + "; sdk has: " + String.valueOf(additionalData));
            throw new IllegalArgumentException("Wrong sdk - " + String.valueOf(sdk));
        }
        String path = sdk.getHomePath();
        String string = Objects.requireNonNull(path, () -> "Interpreter home path is expected to be set for " + String.valueOf(sdk));
        if (string == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getInterpreterPathFor(@NotNull Sdk rubySdk) {
        if (rubySdk == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(12);
        }
        String string = RubySdkAdditionalData.notNullFrom(rubySdk).getInterpreterPath(rubySdk);
        if (string == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(14);
        }
        return languageLevel;
    }

    public void setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(15);
        }
        this.assertWritable();
        this.myLanguageLevel = languageLevel;
    }

    public String getPlatform() {
        return this.myPlatform;
    }

    public void setPlatform(String platform) {
        this.assertWritable();
        this.myPlatform = platform;
    }

    @NotNull
    public RubyRunner getRunner(@Nullable Module module) {
        RubyLocalRunner rubyLocalRunner = RubyLocalRunner.getRunner(module);
        if (rubyLocalRunner == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(16);
        }
        return rubyLocalRunner;
    }

    @NotNull
    public PathMappingSettings getRunnerMappings(@Nullable Module module) {
        PathMappingSettings pathMappingSettings = this.getRunnerMappings(module, null);
        if (pathMappingSettings == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(17);
        }
        return pathMappingSettings;
    }

    @NotNull
    public PathMappingSettings getRunnerMappings(@NotNull AbstractRubyRunConfiguration configurationParams) {
        if (configurationParams == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(18);
        }
        PathMappingSettings pathMappingSettings = this.getRunnerMappings(configurationParams.getModule(), configurationParams.getMappingSettings());
        if (pathMappingSettings == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(19);
        }
        return pathMappingSettings;
    }

    @NotNull
    public PathMappingSettings getRunnerMappings(@Nullable Module module, @Nullable PathMappingSettings baseMappings) {
        PathMappingSettings pathMappingSettings = this.getRunner(module).addDefaultMappings(baseMappings);
        if (pathMappingSettings == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(20);
        }
        return pathMappingSettings;
    }

    @NotNull
    public RubySdkSystemAccessor getSdkSystemAccessor() {
        LocalRubySdkSystemAccessor localRubySdkSystemAccessor = LocalRubySdkSystemAccessor.getInstance();
        if (localRubySdkSystemAccessor == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(21);
        }
        return localRubySdkSystemAccessor;
    }

    @NotNull
    public RvmSettings getRvmSettings() {
        LocalRvmPathsSettings localRvmPathsSettings = LocalRvmPathsSettings.getInstance();
        if (localRvmPathsSettings == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(22);
        }
        return localRvmPathsSettings;
    }

    @NotNull
    public String getConnectionCredentialId() {
        return "";
    }

    @Nullable
    public String getNormalizedVersionString() {
        return this.myNormalizedVersionString;
    }

    @Nullable
    public String getNormalizedVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(23);
        }
        return this.myNormalizedVersionString == null ? sdk.getVersionString() : this.myNormalizedVersionString;
    }

    public void setNormalizedVersionString(@Nullable String normalizedVersionString) {
        this.assertWritable();
        this.myNormalizedVersionString = normalizedVersionString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return this.fieldsEqual((RubySdkAdditionalData)((Object)o));
    }

    protected boolean fieldsEqual(@NotNull RubySdkAdditionalData otherData) {
        if (otherData == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(24);
        }
        return Objects.equals(this.myGemsBinDirectory, otherData.myGemsBinDirectory) && Objects.equals(this.myPlatform, otherData.myPlatform) && Objects.equals(this.myVersionManagerSdkAdditionalData, otherData.myVersionManagerSdkAdditionalData);
    }

    @NotNull
    protected final String computeInterpreterDir(@NotNull String interpreterPath) {
        String parent;
        if (interpreterPath == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(25);
        }
        if ((parent = new File(interpreterPath).getParent()) == null) {
            throw new IllegalArgumentException("Incorrect interpreter path: " + interpreterPath);
        }
        String string = this.getSdkSystemAccessor().toSystemDependentName(parent);
        if (string == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(26);
        }
        return string;
    }

    public int hashCode() {
        return this.fieldsHashCode();
    }

    public void addLoadPathMappings(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(27);
        }
    }

    protected void markInternalsAsCommited(@NotNull Throwable commitStackTrace) {
        if (commitStackTrace == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(28);
        }
        if (this.myVersionManagerSdkAdditionalData != null) {
            this.myVersionManagerSdkAdditionalData.markAsCommited(commitStackTrace);
        }
    }

    public Set<String> buildSdkLoadPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(29);
        }
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        RubyImplementationHandler.notNullFrom(sdk).getLoadPath().forEach(it -> urls.add(VirtualFileUtil.constructLocalUrl(RubySdkUtil.unCygwinizePath(sdk, it))));
        if (JRubySdkUtil.isJRubySDK(sdk)) {
            urls.add(JRubySdkUtil.getSourcesPathInJRubyJarFile(sdk, null));
        }
        RubySdkType.addRubyStubsUrls(urls, sdk);
        return urls;
    }

    protected int fieldsHashCode() {
        int result = this.myGemsBinDirectory != null ? this.myGemsBinDirectory.hashCode() : 0;
        result = 31 * result + (this.myPlatform != null ? this.myPlatform.hashCode() : 0);
        result = 31 * result + (this.myVersionManagerSdkAdditionalData != null ? this.myVersionManagerSdkAdditionalData.hashCode() : 0);
        return result;
    }

    @NotNull
    public static String getInterpreterDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(30);
        }
        RubySdkAdditionalData data = RubySdkAdditionalData.notNullFrom(sdk);
        return data.computeInterpreterDir(data.getInterpreterPath(sdk));
    }

    @NotNull
    public static <T extends RubySdkAdditionalData> T load(@NotNull T data, @NotNull String interpreterPath, @NotNull Sdk sdk, @NotNull Element element) {
        if (data == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(31);
        }
        if (interpreterPath == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(32);
        }
        if (sdk == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(33);
        }
        if (element == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(34);
        }
        String normalizedVersionString = element.getAttributeValue(NORMALIZED_VERSION_STRING);
        data.setNormalizedVersionString(normalizedVersionString);
        data.withVersionManagerSdkAdditionalData(RubyVersionManagerSdkData.load(element, interpreterPath));
        RbConfig rbConfig = RbConfig.load(element);
        data.setRbConfig(rbConfig);
        LanguageLevel languageLevel = (LanguageLevel)ObjectUtils.coalesce((Object)((LanguageLevel)ObjectUtils.doIfNotNull((Object)rbConfig.getRubyVersion(), RubyVersionUtil::extractLanguageLevelFromRbConfigVersion)), (Object)RubyVersionUtil.extractLanguageLevelFromVersion(normalizedVersionString));
        data.setLanguageLevel(languageLevel);
        String gemsBinPathString = element.getAttributeValue(GEMS_BIN_DIR_PATH);
        if (gemsBinPathString != null) {
            data.setGemsBinDirectory(gemsBinPathString);
        }
        String platformString = element.getAttributeValue(PLATFORM);
        if (platformString == null && SystemInfo.isWindows && !ApplicationManager.getApplication().isUnitTestMode()) {
            data.setPlatform(rbConfig.getArchitecture());
        } else {
            data.setPlatform(platformString);
        }
        LinkedList<String> gemsRoots = new LinkedList<String>();
        List list = element.getChildren(GEMS_ROOTS_URLS_ROOT);
        if (list.isEmpty()) {
            if (sdk instanceof SdkModificator) {
                gemsRoots.addAll(RubySdkType.findGemsRoots((SdkModificator)sdk));
            }
        } else {
            for (Element o : list) {
                Attribute attribute = o.getAttribute(GEMS_ROOTS_URL);
                if (attribute == null) continue;
                gemsRoots.add(attribute.getValue());
            }
        }
        data.setGemsRootUrls(gemsRoots);
        T t = data;
        if (t == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(35);
        }
        return t;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static RubySdkAdditionalData from(@Nullable Sdk sdk) {
        LOG.debug("Sdk: " + String.valueOf(sdk));
        RubySdkAdditionalDataBase additionalData = RubySdkAdditionalDataBase.from((Sdk)sdk);
        LOG.debug("SdkAdditionalData: " + String.valueOf(additionalData));
        return additionalData instanceof RubySdkAdditionalData ? (RubySdkAdditionalData)additionalData : null;
    }

    @NotNull
    public static RubySdkAdditionalData notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(36);
        }
        RubySdkAdditionalData rubySdkAdditionalData = Objects.requireNonNull(RubySdkAdditionalData.from(sdk), () -> "Failed to extract sdk data from " + String.valueOf(sdk));
        if (rubySdkAdditionalData == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(37);
        }
        return rubySdkAdditionalData;
    }

    public static boolean areGemsUserLocal(@NotNull Sdk rubySdk) {
        if (rubySdk == null) {
            RubySdkAdditionalData.$$$reportNull$$$0(38);
        }
        return RubyVersionManagerSdkData.notNullFrom(rubySdk).areGemsUserLocal(rubySdk);
    }

    public String toString() {
        return "RubySdkAdditionalData{myInitializedPaths=" + this.myInitializedPaths + ", myTemporaryRoots=" + String.valueOf(this.myTemporaryRoots) + ", myGemsBinDirectory='" + this.myGemsBinDirectory + "', myGemsRootsUrls=" + String.valueOf(this.myGemsRootsUrls) + ", myLanguageLevel=" + String.valueOf(this.myLanguageLevel) + ", myPlatform='" + this.myPlatform + "', myVersionManagerSdkAdditionalData=" + String.valueOf(this.myVersionManagerSdkAdditionalData) + ", myRbConfig=" + String.valueOf(this.myRbConfig) + ", myNormalizedVersionString='" + this.myNormalizedVersionString + "', myIsWritable=" + this.isWritable() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 11, 13, 14, 16, 17, 19, 20, 21, 22, 26, 35, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkAdditionalData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rbConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 10: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdk";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationParams";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherData";
                break;
            }
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitStackTrace";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerSdkAdditionalData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withVersionManagerSdkAdditionalData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsBinDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPathFor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerMappings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkSystemAccessor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRvmSettings";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInterpreterDir";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 35: 
            case 37: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRbConfig";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withVersionManagerSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setGemsBinDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setGemsRootUrls";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPathFor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerMappings";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedVersionString";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fieldsEqual";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeInterpreterDir";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addLoadPathMappings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "markInternalsAsCommited";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkLoadPath";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterDir";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "areGemsUserLocal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 11, 13, 14, 16, 17, 19, 20, 21, 22, 26, 35, 37 -> new IllegalStateException(string);
        };
    }
}

