/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.PathMappingSettings;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkTransfer;

public class RubyLocalSdkTransfer
implements RubySdkTransfer {
    private final RubySdkSystemAccessor myAccessor;

    public RubyLocalSdkTransfer(@NotNull RubySdkAdditionalData data) {
        if (data == null) {
            RubyLocalSdkTransfer.$$$reportNull$$$0(0);
        }
        this.myAccessor = RubySdkSystemAccessor.from(data);
    }

    @Override
    public void updateLocalGemsCopy(@NotNull Sdk sdk, @NotNull List<PathMappingSettings.PathMapping> pathMappings, @NotNull ProgressIndicator indicator) {
        if (sdk == null) {
            RubyLocalSdkTransfer.$$$reportNull$$$0(1);
        }
        if (pathMappings == null) {
            RubyLocalSdkTransfer.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            RubyLocalSdkTransfer.$$$reportNull$$$0(3);
        }
    }

    @Override
    @NotNull
    public RubySdkSystemAccessor getSystemAccessor() {
        RubySdkSystemAccessor rubySdkSystemAccessor = this.myAccessor;
        if (rubySdkSystemAccessor == null) {
            RubyLocalSdkTransfer.$$$reportNull$$$0(4);
        }
        return rubySdkSystemAccessor;
    }

    @Override
    public void moveFileToLocalPath(@NotNull String sourcePath, @NotNull String newParentDir, boolean replaceExisting, @NotNull ProgressIndicator __) throws IOException {
        CopyOption[] copyOptionArray;
        if (sourcePath == null) {
            RubyLocalSdkTransfer.$$$reportNull$$$0(5);
        }
        if (newParentDir == null) {
            RubyLocalSdkTransfer.$$$reportNull$$$0(6);
        }
        if (__ == null) {
            RubyLocalSdkTransfer.$$$reportNull$$$0(7);
        }
        LOG.debug("Transferring file '" + sourcePath + "' to new parent dir, '" + newParentDir + "', replace: " + replaceExisting);
        Path source = Paths.get(sourcePath, new String[0]);
        if (!Files.exists(source, new LinkOption[0])) {
            throw new IOException("'%s' does not exist".formatted(sourcePath));
        }
        Path parent = Paths.get(newParentDir, new String[0]);
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            throw new IOException("'%s' not a directory".formatted(newParentDir));
        }
        Path target = parent.resolve(source.getFileName());
        if (replaceExisting) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        Files.move(source, target, copyOptionArray);
        LOG.debug("'%s' is transferred to '%s' successfully".formatted(source, target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyLocalSdkTransfer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParentDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "__";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyLocalSdkTransfer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalGemsCopy";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveFileToLocalPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

