/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;

public final class RbConfig {
    private static final Logger LOG = Logger.getInstance(RbConfig.class);
    private static Map<String, String> ourMockMap = null;
    static final RbConfig EMPTY_CONFIG = new RbConfig(Collections.emptyMap());
    private boolean myEmptyReported;
    @NotNull
    private final Map<String, String> myConfig;

    private RbConfig(@NotNull MyBean bean) {
        if (bean == null) {
            RbConfig.$$$reportNull$$$0(0);
        }
        this(bean.config);
        if (!bean.isValidAndActual()) {
            throw new RuntimeException("Invalid or legacy bean should not be used");
        }
    }

    private RbConfig(@NotNull Map<String, String> config) {
        if (config == null) {
            RbConfig.$$$reportNull$$$0(1);
        }
        this.myEmptyReported = false;
        this.myConfig = Collections.unmodifiableMap(ContainerUtil.filter(config, it -> StringUtil.isNotEmpty((String)((String)config.get(it)))));
    }

    @NotNull
    public Map<String, String> getConfig() {
        Map<String, String> map = this.myConfig;
        if (map == null) {
            RbConfig.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Contract(value="null -> null")
    @Nullable
    public String get(@Nullable String key) {
        if (ourMockMap != null) {
            return ourMockMap.get(key);
        }
        Application application = ApplicationManager.getApplication();
        if (!this.myEmptyReported && !application.isUnitTestMode() && this.isEmpty()) {
            this.myEmptyReported = true;
            LOG.warn("Accessing empty environment");
        }
        return this.getConfig().get(key);
    }

    @Nullable
    public String getArchitecture() {
        return this.get("arch");
    }

    @Nullable
    public String getRubyVersion() {
        return this.get("ruby_version");
    }

    @Nullable
    public String getRubyLibPrefix() {
        return this.get("rubylibprefix");
    }

    @Nullable
    public String getRubyBaseName() {
        return this.get("RUBY_BASE_NAME");
    }

    @Nullable
    public String getLibDir() {
        return this.get("libdir");
    }

    @Nullable
    public String getInstallName() {
        return this.get("RUBY_INSTALL_NAME");
    }

    @Nullable
    public String getNormalizeInstallName() {
        String installName = this.getInstallName();
        if (installName == null) {
            return null;
        }
        int index = StringUtil.findFirst((CharSequence)installName, Character::isDigit);
        return index < 0 ? installName : installName.substring(0, index);
    }

    @NotNull
    public List<String> get(@Nullable List<String> keys) {
        List<String> list = keys == null || keys.isEmpty() ? Collections.emptyList() : keys.stream().map(this::get).filter(StringUtil::isNotEmpty).collect(Collectors.toList());
        if (list == null) {
            RbConfig.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isEmpty() {
        return (ourMockMap == null || ourMockMap.isEmpty()) && this.myConfig.isEmpty();
    }

    public void save(@NotNull Element parentElement) {
        if (parentElement == null) {
            RbConfig.$$$reportNull$$$0(4);
        }
        XmlSerializer.serializeObjectInto((Object)new MyBean(this.myConfig), (Element)parentElement);
    }

    public static void init(@NotNull RubySdkAdditionalData sdkAdditionalData, @NotNull String interpreterPath) {
        ProcessOutput processOutput;
        if (sdkAdditionalData == null) {
            RbConfig.$$$reportNull$$$0(5);
        }
        if (interpreterPath == null) {
            RbConfig.$$$reportNull$$$0(6);
        }
        LOG.debug("Getting RBConfig from " + interpreterPath);
        long currentTime = System.currentTimeMillis();
        String startMarker = "START-" + String.valueOf(RbConfig.class) + currentTime;
        String endMarker = "END-" + String.valueOf(RbConfig.class) + currentTime;
        try {
            processOutput = sdkAdditionalData.getRunner(null).execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(interpreterPath, "-r", "rbconfig", "-e", "print %q<" + startMarker + ">;RbConfig::CONFIG.each{|k,v| print %Q<#{k}=#{v}\\0>};print %q<" + endMarker + ">;").inSameThreadCancelableUnderProgressIndicator(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message((String)"rbconfig.fetching.progress", (Object[])new Object[]{interpreterPath})));
        }
        catch (ExecutionException e) {
            sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
            LOG.warn("Error loading RBConfig for " + interpreterPath, (Throwable)e);
            return;
        }
        assert (processOutput != null);
        String stdout = processOutput.getStdout();
        if (processOutput.getExitCode() != 0 || StringUtil.isEmpty((String)stdout)) {
            sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
            LOG.warn("Error getting RbConfig from " + interpreterPath + ", error code " + processOutput.getExitCode() + "; STDOUT: " + stdout + "; STDERR: " + processOutput.getStderr());
            return;
        }
        int startMarkerOffset = stdout.indexOf(startMarker);
        int dataStartOffset = startMarkerOffset + startMarker.length();
        int dataEndOffset = stdout.indexOf(endMarker, dataStartOffset);
        if (dataEndOffset == -1) {
            sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
            LOG.warn("Missing start or end marker: startMarker=" + startMarker + "; startMarkerOffset=" + startMarkerOffset + "; endMarker=" + endMarker + "; endMarkerOffset=" + dataEndOffset + "; text=" + stdout);
            return;
        }
        try {
            MyBean config = new MyBean(EnvironmentUtil.parseEnv((String[])stdout.substring(dataStartOffset, dataEndOffset).split("\u0000")));
            config.version = 1;
            sdkAdditionalData.setRbConfig(new RbConfig(config));
        }
        catch (Exception e) {
            sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
            LOG.warn("Error parsing RbConfig output from " + interpreterPath + ":\n" + stdout, (Throwable)e);
        }
    }

    @TestOnly
    public static void initEmpty(@NotNull RubySdkAdditionalData sdkAdditionalData) {
        if (sdkAdditionalData == null) {
            RbConfig.$$$reportNull$$$0(7);
        }
        sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
    }

    @NotNull
    public static RbConfig load(@NotNull Element rootElement) {
        MyBean bean;
        if (rootElement == null) {
            RbConfig.$$$reportNull$$$0(8);
        }
        if ((bean = (MyBean)XmlSerializer.deserialize((Element)rootElement, MyBean.class)) != null && bean.isValidAndActual()) {
            return new RbConfig(bean.config);
        }
        RbConfig rbConfig = EMPTY_CONFIG;
        if (rbConfig == null) {
            RbConfig.$$$reportNull$$$0(9);
        }
        return rbConfig;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RbConfig from(@Nullable Sdk sdk) {
        return (RbConfig)ObjectUtils.doIfNotNull((Object)((Object)RubySdkAdditionalData.from(sdk)), RubySdkAdditionalData::getRbConfig);
    }

    @NotNull
    public static RbConfig notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbConfig.$$$reportNull$$$0(10);
        }
        RbConfig rbConfig = Objects.requireNonNull(RbConfig.from(sdk));
        if (rbConfig == null) {
            RbConfig.$$$reportNull$$$0(11);
        }
        return rbConfig;
    }

    @TestOnly
    public static void doWithMockConfig(@NotNull Map<String, String> mockMap, @NotNull Runnable runnable) {
        if (mockMap == null) {
            RbConfig.$$$reportNull$$$0(12);
        }
        if (runnable == null) {
            RbConfig.$$$reportNull$$$0(13);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("For tests only");
        }
        ourMockMap = mockMap;
        try {
            runnable.run();
        }
        finally {
            ourMockMap = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RbConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockMap";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RbConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initEmpty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doWithMockConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9, 11 -> new IllegalStateException(string);
        };
    }

    private static final class MyBean {
        private static final int CURRENT_VERSION = 1;
        @XMap(propertyElementName="RbConfig", entryTagName="item")
        public Map<String, String> config;
        @Attribute(value="version")
        public int version;

        private MyBean() {
        }

        private boolean isValid() {
            return this.config != null;
        }

        private boolean isValidAndActual() {
            return this.isValid() && this.version >= 1;
        }

        private MyBean(@NotNull Map<String, String> config) {
            if (config == null) {
                MyBean.$$$reportNull$$$0(0);
            }
            this.version = 1;
            this.config = config;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/plugins/ruby/ruby/sdk/RbConfig$MyBean", "<init>"));
        }
    }
}

