/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.filters;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;

public class OpenIOFilesHyperlinkInfo
implements FileHyperlinkInfo {
    private static final Logger LOG = Logger.getInstance(OpenIOFilesHyperlinkInfo.class);
    private static final String PARENT_DIRECTORY_PREFIX = ".." + File.separator;
    private final Project myProject;
    private final List<File> myFiles;
    private final int myLine;
    private final int myColumn;
    private OpenFileDescriptor myDescriptor;

    public OpenIOFilesHyperlinkInfo(Project project, List<File> files, int line, int column) {
        this.myProject = project;
        this.myFiles = files;
        this.myLine = line;
        this.myColumn = column;
    }

    public OpenIOFilesHyperlinkInfo(Project project, List<File> files, int line) {
        this(project, files, line, 0);
    }

    @NotNull
    public OpenFileDescriptor getDescriptor() {
        if (this.myDescriptor == null) {
            this.myDescriptor = new MyOpenFileDescriptorWithVfsRefresh(this.myProject, this.myFiles.get(0).toPath(), this.myLine, this.myColumn);
        }
        OpenFileDescriptor openFileDescriptor = this.myDescriptor;
        if (openFileDescriptor == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(0);
        }
        return openFileDescriptor;
    }

    @NotNull
    public List<File> getFiles() {
        List<File> list = this.myFiles;
        if (list == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(1);
        }
        return list;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void navigate(@NotNull Project project) {
        if (project == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(2);
        }
        if (this.myFiles.size() == 1) {
            this.navigate(this.myFiles.get(0));
            return;
        }
        this.createAndShowPopup();
    }

    private void createAndShowPopup() {
        Path projectPath = (Path)ObjectUtils.doIfNotNull((Object)ProjectUtil.guessProjectDir((Project)this.myProject), VirtualFile::toNioPath);
        SimpleListCellRenderer renderer = SimpleListCellRenderer.create((String)"", file -> {
            Path filePath = file.toPath();
            String relativePath = (projectPath != null ? projectPath.relativize(filePath) : filePath).toString();
            return relativePath.startsWith(PARENT_DIRECTORY_PREFIX) ? relativePath.substring(PARENT_DIRECTORY_PREFIX.length()) : relativePath;
        });
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(this.myFiles).setTitle(RBundle.message((String)"stacktrace.filter.navigate.to.title")).setRenderer((ListCellRenderer)renderer).setItemChosenCallback(file -> this.navigate((File)file)).createPopup();
        popup.showInFocusCenter();
    }

    private void navigate(@NotNull File file) {
        MyOpenFileDescriptorWithVfsRefresh fileDesc;
        if (file == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(3);
        }
        if (!(fileDesc = new MyOpenFileDescriptorWithVfsRefresh(this.myProject, file.toPath(), this.myLine, this.myColumn)).isVfsRefreshCompleted()) {
            OpenIOFilesHyperlinkInfo.asyncNavigateWhenVirtualFileReady(this.myProject, fileDesc);
        } else {
            OpenIOFilesHyperlinkInfo.openInTextEditor(this.myProject, fileDesc);
        }
    }

    private static void asyncNavigateWhenVirtualFileReady(@NotNull Project project, @NotNull MyOpenFileDescriptorWithVfsRefresh fileDesc) {
        if (project == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(4);
        }
        if (fileDesc == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(5);
        }
        Component component = PopupUtil.getActiveComponent();
        Function<ProgressIndicator, CompletableFuture> waitAndNavigate = indicator -> {
            if (!fileDesc.awaitVfsRefreshCompletion((ProgressIndicator)indicator, 5)) {
                return OpenIOFilesHyperlinkInfo.asyncShowInfoBalloon(component, RBundle.message((String)"info.navigation.file.not.ready"), indicator);
            }
            if (!fileDesc.isRealVirtualFileFound()) {
                return OpenIOFilesHyperlinkInfo.asyncShowInfoBalloon(component, RBundle.message((String)"info.navigation.file.not.found"), indicator);
            }
            indicator.checkCanceled();
            return Futures.runInEdtAsync(() -> OpenIOFilesHyperlinkInfo.openInTextEditor(project, fileDesc));
        };
        Futures.runAsyncProgressInBackground((Project)project, (String)RBundle.message((String)"navigation.indicator.title.file.preparation"), (boolean)true, waitAndNavigate);
    }

    @NotNull
    private static CompletableFuture<Void> asyncShowInfoBalloon(@NotNull Component component, @Nls String message, @NotNull ProgressIndicator indicator) {
        if (component == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(7);
        }
        indicator.checkCanceled();
        CompletableFuture completableFuture = Futures.runInEdtAsync(() -> PopupUtil.showBalloonForComponent((Component)component, (String)message, (MessageType)MessageType.INFO, (boolean)true, null));
        if (completableFuture == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(8);
        }
        return completableFuture;
    }

    private static void openInTextEditor(@NotNull Project project, @NotNull OpenFileDescriptor fileDesc) {
        if (project == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(9);
        }
        if (fileDesc == null) {
            OpenIOFilesHyperlinkInfo.$$$reportNull$$$0(10);
        }
        if (fileDesc.getFile().isValid()) {
            FileEditorManager.getInstance((Project)project).openTextEditor(fileDesc, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/filters/OpenIOFilesHyperlinkInfo";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDesc";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/filters/OpenIOFilesHyperlinkInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncShowInfoBalloon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asyncNavigateWhenVirtualFileReady";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "asyncShowInfoBalloon";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "openInTextEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyOpenFileDescriptorWithVfsRefresh
    extends OpenFileDescriptor {
        private final AtomicReference<@Nullable VirtualFile> myRealVirtualFileRef;
        private final CountDownLatch myLoadingLatch;

        MyOpenFileDescriptorWithVfsRefresh(@NotNull Project project, @NotNull Path path, int logicalLine, int logicalColumn) {
            if (project == null) {
                MyOpenFileDescriptorWithVfsRefresh.$$$reportNull$$$0(0);
            }
            if (path == null) {
                MyOpenFileDescriptorWithVfsRefresh.$$$reportNull$$$0(1);
            }
            super(project, (VirtualFile)new CoreLocalVirtualFile(new CoreLocalFileSystem(), path), logicalLine, logicalColumn);
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(path);
            if (virtualFile != null) {
                this.myRealVirtualFileRef = new AtomicReference<VirtualFile>(virtualFile);
                this.myLoadingLatch = new CountDownLatch(0);
            } else {
                this.myRealVirtualFileRef = new AtomicReference<Object>(null);
                this.myLoadingLatch = new CountDownLatch(1);
                Path absolutePath = path.toAbsolutePath();
                VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)LocalFileSystem.getInstance(), (String)absolutePath.toString(), realVirtualFile -> {
                    if (realVirtualFile == null) {
                        LOG.debug("Failed to locate virtual file for: ", new Object[]{absolutePath});
                    }
                    this.myRealVirtualFileRef.compareAndSet(null, (VirtualFile)realVirtualFile);
                    this.myLoadingLatch.countDown();
                });
            }
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.isRealVirtualFileFound() ? Objects.requireNonNull(this.myRealVirtualFileRef.get()) : super.getFile();
            if (virtualFile == null) {
                MyOpenFileDescriptorWithVfsRefresh.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        public boolean isVfsRefreshCompleted() {
            return this.myLoadingLatch.getCount() <= 0L;
        }

        public boolean isRealVirtualFileFound() {
            return this.myRealVirtualFileRef.get() != null;
        }

        public boolean awaitVfsRefreshCompletion(@NotNull ProgressIndicator indicator, int timeoutInSeconds) {
            if (indicator == null) {
                MyOpenFileDescriptorWithVfsRefresh.$$$reportNull$$$0(3);
            }
            try {
                for (int i = 0; i < timeoutInSeconds; ++i) {
                    indicator.checkCanceled();
                    if (!this.myLoadingLatch.await(1L, TimeUnit.SECONDS)) continue;
                    return true;
                }
            }
            catch (InterruptedException e) {
                LOG.debug("Await was interrupted: ", (Throwable)e);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/filters/OpenIOFilesHyperlinkInfo$MyOpenFileDescriptorWithVfsRefresh";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/filters/OpenIOFilesHyperlinkInfo$MyOpenFileDescriptorWithVfsRefresh";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "awaitVfsRefreshCompletion";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

