/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.context;

import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.CmdlinePreprocessor;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;

public abstract class RubyAbstractExecutionContext<T extends RubyAbstractExecutionContext>
implements Cloneable {
    @Nullable
    private Sdk mySdk;
    @Nullable
    private String myWorkingDirPath;
    @NotNull
    private ExecutionMode myExecutionMode;
    @Nullable
    private CmdlinePreprocessor myCommandLinePreprocessor;
    @Nullable
    private Project myProject;
    @Nullable
    private Module myModule;
    @Nullable
    private String myExecutionID;
    private boolean myWithParentEnv;
    private boolean myAskForSudo;
    private boolean myAllocatePty;
    private boolean mySpringPreloaderEnabled;
    private boolean myAddBundleExec;
    @NotNull
    private Map<String, String> myAdditionalEnvs;

    protected RubyAbstractExecutionContext() {
        this.myExecutionMode = new ExecutionModes.SameThreadMode();
        this.myWithParentEnv = true;
        this.myAskForSudo = false;
        this.myAllocatePty = false;
        this.mySpringPreloaderEnabled = true;
        this.myAddBundleExec = true;
        this.myAdditionalEnvs = new HashMap<String, String>();
    }

    public RubyAbstractExecutionContext(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(0);
        }
        this.myExecutionMode = new ExecutionModes.SameThreadMode();
        this.myWithParentEnv = true;
        this.myAskForSudo = false;
        this.myAllocatePty = false;
        this.mySpringPreloaderEnabled = true;
        this.myAddBundleExec = true;
        this.myAdditionalEnvs = new HashMap<String, String>();
        this.withSdk(sdk);
    }

    public RubyAbstractExecutionContext(@NotNull Module module) {
        if (module == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(1);
        }
        this.myExecutionMode = new ExecutionModes.SameThreadMode();
        this.myWithParentEnv = true;
        this.myAskForSudo = false;
        this.myAllocatePty = false;
        this.mySpringPreloaderEnabled = true;
        this.myAddBundleExec = true;
        this.myAdditionalEnvs = new HashMap<String, String>();
        this.withModule(module);
    }

    public RubyAbstractExecutionContext(@NotNull RubyAbstractExecutionContext source) {
        if (source == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(2);
        }
        this.myExecutionMode = new ExecutionModes.SameThreadMode();
        this.myWithParentEnv = true;
        this.myAskForSudo = false;
        this.myAllocatePty = false;
        this.mySpringPreloaderEnabled = true;
        this.myAddBundleExec = true;
        this.myAdditionalEnvs = new HashMap<String, String>();
        this.mySdk = source.mySdk;
        this.myModule = source.myModule;
        this.myProject = source.myProject;
        this.myWorkingDirPath = source.myWorkingDirPath;
        this.myExecutionMode = source.myExecutionMode;
        this.myCommandLinePreprocessor = source.myCommandLinePreprocessor;
        this.myWithParentEnv = source.myWithParentEnv;
        this.myAskForSudo = source.myAskForSudo;
        this.myExecutionID = source.myExecutionID;
        this.myAllocatePty = source.myAllocatePty;
        this.mySpringPreloaderEnabled = source.mySpringPreloaderEnabled;
        this.withAdditionalEnvs(source.myAdditionalEnvs);
    }

    public boolean isSpringPreloaderEnabled() {
        return this.mySpringPreloaderEnabled;
    }

    public T withSpringPreloaderEnabled(boolean isEnabled) {
        this.mySpringPreloaderEnabled = isEnabled;
        return this.self();
    }

    @NotNull
    protected abstract T self();

    @Nullable
    public Sdk getRubySdk() {
        return this.mySdk;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public T withModule(@Nullable Module module) {
        this.myModule = module;
        if (module != null) {
            this.myProject = module.getProject();
        }
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(3);
        }
        return t;
    }

    @NotNull
    public T withProject(@Nullable Project project) {
        this.myProject = project;
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(4);
        }
        return t;
    }

    public boolean hasModule() {
        return this.getModule() != null;
    }

    @NotNull
    public T withSdk(@Nullable Sdk rubySdk) throws IllegalArgumentException {
        if (rubySdk != null && !(rubySdk.getSdkType() instanceof RubySdkType)) {
            throw new IllegalArgumentException("Got " + String.valueOf(rubySdk) + " instead of Ruby SDK");
        }
        this.mySdk = rubySdk;
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(5);
        }
        return t;
    }

    @Nullable
    public String getWorkingDirPath() {
        return this.myWorkingDirPath;
    }

    @NotNull
    public T withWorkingDirPath(@Nullable String workingDirPath) {
        this.myWorkingDirPath = workingDirPath;
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(6);
        }
        return t;
    }

    @NotNull
    public T withWorkingDir(@Nullable VirtualFile workingDir) {
        T t = this.withWorkingDirPath(workingDir == null ? null : workingDir.getCanonicalPath());
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(7);
        }
        return t;
    }

    @NotNull
    public T withExecutionID(@Nullable String executionID) {
        this.myExecutionID = executionID;
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(8);
        }
        return t;
    }

    @Nullable
    public String getExecutionID() {
        return this.myExecutionID;
    }

    public boolean isAllocatePty() {
        return this.myAllocatePty;
    }

    @NotNull
    public T withPty(boolean allocatePty) {
        this.myAllocatePty = allocatePty;
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(9);
        }
        return t;
    }

    @NotNull
    public ExecutionMode getExecutionMode() {
        ExecutionMode executionMode = this.myExecutionMode;
        if (executionMode == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(10);
        }
        return executionMode;
    }

    @NotNull
    public T withExecutionMode(@NotNull ExecutionMode executionMode) {
        if (executionMode == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(11);
        }
        this.myExecutionMode = executionMode;
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(12);
        }
        return t;
    }

    @NotNull
    public T inSameThread(int timeout) {
        T t = this.withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode(timeout));
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(13);
        }
        return t;
    }

    @NotNull
    public T inSameThreadCancelableUnderProgressIndicator(int timeout) {
        T t = this.inSameThreadCancelableUnderProgressIndicator(timeout, "");
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(14);
        }
        return t;
    }

    @NotNull
    public T inSameThreadCancelableUnderProgressIndicator(int timeout, @NlsContexts.ProgressTitle @NotNull String message) {
        if (message == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(15);
        }
        boolean cancellable = ProgressManager.getInstance().getProgressIndicator() != null;
        T t = this.withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode(cancellable, message, timeout));
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(16);
        }
        return t;
    }

    @NotNull
    public T inSameThread() {
        T t = this.withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode());
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(17);
        }
        return t;
    }

    @NotNull
    public T inSameThread(int timeout, final @NotNull Runnable onTimeoutCallback) {
        if (onTimeoutCallback == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(18);
        }
        T t = this.withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode(this, timeout){

            public void onTimeout(@NotNull ProcessHandler processHandler, @NotNull String commandLineString, @NotNull ProcessOutput outputCollected, @Nullable Throwable invocatorStack) {
                if (processHandler == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (commandLineString == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputCollected == null) {
                    1.$$$reportNull$$$0(2);
                }
                onTimeoutCallback.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processHandler";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "commandLineString";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputCollected";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/run/context/RubyAbstractExecutionContext$1";
                objectArray[2] = "onTimeout";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(19);
        }
        return t;
    }

    @NotNull
    public T inSameThread(int timeout, @NlsContexts.ProgressTitle @NotNull String title2) {
        if (title2 == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(20);
        }
        T t = this.withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode(false, title2, timeout));
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(21);
        }
        return t;
    }

    @Nullable
    public CmdlinePreprocessor getCommandLinePreprocessor() {
        return this.myCommandLinePreprocessor;
    }

    public RubyCommandLine preprocessCommandLine(@NotNull RubyCommandLine commandLine) {
        if (commandLine == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(22);
        }
        if (this.getCommandLinePreprocessor() != null) {
            this.getCommandLinePreprocessor().preprocess(commandLine);
        }
        return commandLine;
    }

    public T withCommandLinePreprocessor(@Nullable CmdlinePreprocessor commandLinePreprocessor) {
        this.myCommandLinePreprocessor = commandLinePreprocessor;
        return this.self();
    }

    @NotNull
    public T withParentEnv(boolean withParentEnv) {
        this.myWithParentEnv = withParentEnv;
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(23);
        }
        return t;
    }

    public boolean isWithParentEnv() {
        return this.myWithParentEnv;
    }

    @NotNull
    public T withAskForSudo(boolean askForSudo) {
        this.myAskForSudo = askForSudo;
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(24);
        }
        return t;
    }

    public boolean isAskForSudo() {
        return this.myAskForSudo;
    }

    @NotNull
    public T withAddBundleExec(boolean addBundleExec) {
        this.myAddBundleExec = addBundleExec;
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(25);
        }
        return t;
    }

    public boolean isAddBundleExec() {
        return this.myAddBundleExec;
    }

    @NotNull
    public Map<String, String> getAdditionalEnvs() {
        Map<String, String> map = this.myAdditionalEnvs;
        if (map == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(26);
        }
        return map;
    }

    @NotNull
    public T withAdditionalEnvs(@Nullable Map<String, String> additionalEnv) {
        this.myAdditionalEnvs = additionalEnv == null ? new HashMap<String, String>() : new HashMap<String, String>(additionalEnv);
        T t = this.self();
        if (t == null) {
            RubyAbstractExecutionContext.$$$reportNull$$$0(27);
        }
        return t;
    }

    public T copy() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        assert (copy != null) : "Could not clone " + String.valueOf(this);
        return ((RubyAbstractExecutionContext)copy).withAdditionalEnvs(this.myAdditionalEnvs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 16, 17, 19, 21, 23, 24, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/context/RubyAbstractExecutionContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionMode";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTimeoutCallback";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title2";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/context/RubyAbstractExecutionContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withSdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkingDirPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkingDir";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withExecutionID";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withPty";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionMode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withExecutionMode";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "inSameThread";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inSameThreadCancelableUnderProgressIndicator";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "withParentEnv";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "withAskForSudo";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "withAddBundleExec";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalEnvs";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "withAdditionalEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withExecutionMode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inSameThreadCancelableUnderProgressIndicator";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inSameThread";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "preprocessCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 16, 17, 19, 21, 23, 24, 25, 26, 27 -> new IllegalStateException(string);
        };
    }
}

