/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationWithScriptPath;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.support.ConfigurationUIUtil;

public class RubyRunConfigurationEditor
extends SettingsEditor<RubyRunConfiguration>
implements RubyRunConfigurationParams,
PanelWithAnchor {
    protected JPanel generatedPanel;
    protected TextFieldWithBrowseButton scriptPathTextField;
    protected LabeledComponent scriptComponent;
    private JComponent myAnchor;
    private RawCommandLineEditor scriptArgsEditor;
    protected LabeledComponent scriptArgsComponent;
    private JPanel myCommonOptionsPanel;
    private final Project myProject;
    private final RubyCommonRunParamsEditor myCommonEditor;

    public RubyRunConfigurationEditor(Project project, RubyRunConfiguration configuration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = new RubyCommonRunParamsEditor(configuration);
        this.myCommonOptionsPanel.add((Component)this.myCommonEditor.getMainPanel(), "Center");
        this.initComponents();
        this.setupAnchor();
    }

    protected void resetEditorFrom(@NotNull RubyRunConfiguration config) {
        if (config == null) {
            RubyRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        AbstractRubyRunConfigurationWithScriptPath.copyParams(config, this);
        this.myCommonEditor.resetEditorFrom(config);
    }

    protected void applyEditorTo(@NotNull RubyRunConfiguration config) throws ConfigurationException {
        if (config == null) {
            RubyRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        AbstractRubyRunConfigurationWithScriptPath.copyParams(this, config);
        this.myCommonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.generatedPanel;
        if (jPanel == null) {
            RubyRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    protected void initComponents() {
        String title = RBundle.message((String)"run.configuration.messages.select.ruby.script.path");
        ConfigurationUIUtil.addFileChooser(title, this.scriptPathTextField, this.myProject);
    }

    protected LabeledComponent createScriptArgsComponent() {
        String text = RBundle.message((String)"run.configuration.messages.script.args");
        Ref scriptArgsEditorWrapper = new Ref();
        LabeledComponent<RawCommandLineEditor> myComponent = RunConfigurationUIUtil.createRawEditorComponent((Ref<? super RawCommandLineEditor>)scriptArgsEditorWrapper, text);
        this.scriptArgsEditor = (RawCommandLineEditor)scriptArgsEditorWrapper.get();
        return myComponent;
    }

    private void createUIComponents() {
        this.scriptArgsComponent = this.createScriptArgsComponent();
        Ref scriptTextFieldWrapper = new Ref();
        this.scriptComponent = RunConfigurationUIUtil.createScriptPathComponent((Ref<? super TextFieldWithBrowseButton>)scriptTextFieldWrapper, RBundle.message((String)"run.configuration.messages.script.path"));
        this.scriptPathTextField = (TextFieldWithBrowseButton)scriptTextFieldWrapper.get();
    }

    @Override
    @NotNull
    public String getScriptPath() {
        String string = FileUtil.toSystemIndependentName((String)this.scriptPathTextField.getText().trim());
        if (string == null) {
            RubyRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getScriptArgs() {
        String string = this.scriptArgsEditor.getText().trim();
        if (string == null) {
            RubyRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setScriptPath(String value) {
        this.scriptPathTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)value)));
    }

    @Override
    public void setScriptArgs(String value) {
        this.scriptArgsEditor.setText(value);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.scriptArgsComponent.setAnchor(anchor);
        this.scriptComponent.setAnchor(anchor);
        this.myCommonEditor.setAnchor(anchor);
    }

    private void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonEditor, this.scriptComponent, this.scriptArgsComponent});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/rubyScript/RubyRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/rubyScript/RubyRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.generatedPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent labeledComponent = this.scriptComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", RubyRunConfigurationEditor.class).getString("run.configuration.messages.script.path"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent2 = this.scriptArgsComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", RubyRunConfigurationEditor.class).getString("run.configuration.messages.script.args"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 7, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.generatedPanel;
    }
}

