/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.remote;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfigurationParams;

public class RubyRemoteDebugConfigurationForm
implements RubyRemoteDebugConfigurationParams,
PanelWithAnchor {
    protected JPanel generatedPanel;
    private LabeledComponent<JTextField> myRemoteHostComponent;
    private JTextField myRemoteHostField;
    private LabeledComponent<JTextField> myPortComponent;
    private JTextField myPortField;
    private LabeledComponent<JTextField> myRemoteRootComponent;
    private JTextField myRemoteRootField;
    private JTextField myInfoTextField;
    private LabeledComponent<TextFieldWithBrowseButton> myLocalRootComponent;
    private JBLabel myCommandLabel;
    private LabeledComponent<JTextField> myDispatcherPortComponent;
    private JTextField myDispatcherPortField;
    protected TextFieldWithBrowseButton myLocalRootField;
    private JComponent anchor;
    private final Project myProject;
    private final RubyRemoteDebugConfiguration myConfiguration;
    private static final String REMOTE_SCRIPT = "rdebug-ide --host 0.0.0.0 --port %s -- $COMMAND$";
    private static final String REMOTE_WITH_DISPATCHER_SCRIPT = "rdebug-ide --host 0.0.0.0 --port %s --dispatcher-port %s -- $COMMAND$";

    public RubyRemoteDebugConfigurationForm(@NotNull Project project, @NotNull RubyRemoteDebugConfiguration configuration) {
        if (project == null) {
            RubyRemoteDebugConfigurationForm.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            RubyRemoteDebugConfigurationForm.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        this.initComponents();
        this.setAnchor((JComponent)this.myRemoteRootComponent.getLabel());
    }

    protected void initComponents() {
        this.setRemoteHost(this.myConfiguration.getRemoteHost());
        this.setPort(this.myConfiguration.getPort());
        this.setDispatcherPort(this.myConfiguration.getDispatcherPort());
        this.setRemoteRoot(this.myConfiguration.getRemoteRoot());
        this.setLocalRoot(this.myConfiguration.getLocalRoot());
        DocumentAdapter infoTextUpdater = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String text = RubyDebuggerSettings.getInstance().getState().isMultiprocess() ? RubyRemoteDebugConfigurationForm.REMOTE_WITH_DISPATCHER_SCRIPT : RubyRemoteDebugConfigurationForm.REMOTE_SCRIPT;
                RubyRemoteDebugConfigurationForm.this.myInfoTextField.setText(String.format(text, RubyRemoteDebugConfigurationForm.this.myPortField.getText(), RubyRemoteDebugConfigurationForm.this.myDispatcherPortField.getText()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/run/configuration/remote/RubyRemoteDebugConfigurationForm$1", "textChanged"));
            }
        };
        this.myDispatcherPortField.getDocument().addDocumentListener((DocumentListener)infoTextUpdater);
        this.myPortField.getDocument().addDocumentListener((DocumentListener)infoTextUpdater);
        RunConfigurationUIUtil.addFolderChooser(RBundle.message((String)"dialog.title.choose.local.root.folder"), this.myLocalRootField, this.myProject);
    }

    private void createUIComponents() {
        this.myRemoteHostField = new JTextField();
        this.myRemoteHostComponent = new LabeledComponent();
        this.myRemoteHostComponent.setComponent((JComponent)this.myRemoteHostField);
        this.myPortField = new JTextField();
        this.myPortComponent = new LabeledComponent();
        this.myPortComponent.setComponent((JComponent)this.myPortField);
        this.myDispatcherPortField = new JTextField();
        this.myDispatcherPortComponent = new LabeledComponent();
        this.myDispatcherPortComponent.setComponent((JComponent)this.myDispatcherPortField);
        this.myDispatcherPortComponent.setVisible(RubyDebuggerSettings.getInstance().getState().isMultiprocess());
        this.myRemoteRootField = new JTextField();
        this.myRemoteRootComponent = new LabeledComponent();
        this.myRemoteRootComponent.setComponent((JComponent)this.myRemoteRootField);
        this.myLocalRootField = new TextFieldWithBrowseButton();
        this.myLocalRootComponent = new LabeledComponent();
        this.myLocalRootComponent.setComponent((JComponent)this.myLocalRootField);
    }

    public JComponent getPanel() {
        return this.generatedPanel;
    }

    @Override
    public String getRemoteHost() {
        return this.myRemoteHostField.getText().trim();
    }

    @Override
    public void setRemoteHost(String remoteHost) {
        this.myRemoteHostField.setText(remoteHost);
    }

    @Override
    public int getPort() {
        return RunConfigurationUtil.getIntByString(this.myPortField.getText().trim(), -1);
    }

    @Override
    public void setPort(int port) {
        this.myPortField.setText(RunConfigurationUtil.getStringByInt(port, -1, ""));
    }

    @Override
    public int getDispatcherPort() {
        return RunConfigurationUtil.getIntByString(this.myDispatcherPortField.getText().trim(), -1);
    }

    @Override
    public void setDispatcherPort(int port) {
        this.myDispatcherPortField.setText(RunConfigurationUtil.getStringByInt(port, -1, ""));
    }

    @Override
    public String getRemoteRoot() {
        return this.myRemoteRootField.getText().trim();
    }

    @Override
    public void setRemoteRoot(String remoteRoot) {
        this.myRemoteRootField.setText(remoteRoot);
    }

    @Override
    public String getLocalRoot() {
        return this.myLocalRootField.getText().trim();
    }

    @Override
    public void setLocalRoot(@NlsSafe String localRoot) {
        this.myLocalRootField.setText(localRoot);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myLocalRootComponent.setAnchor(anchor);
        this.myPortComponent.setAnchor(anchor);
        this.myDispatcherPortComponent.setAnchor(anchor);
        this.myRemoteHostComponent.setAnchor(anchor);
        this.myRemoteRootComponent.setAnchor(anchor);
        this.myCommandLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/remote/RubyRemoteDebugConfigurationForm";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.generatedPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/RBundle", RubyRemoteDebugConfigurationForm.class).getString("remote.debug.settings"), (int)0, (int)0, null, null));
        LabeledComponent<JTextField> labeledComponent = this.myRemoteHostComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", RubyRemoteDebugConfigurationForm.class).getString("remote.debug.remote.host"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<JTextField> labeledComponent2 = this.myRemoteRootComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", RubyRemoteDebugConfigurationForm.class).getString("remote.debug.remote.root.folder"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<JTextField> labeledComponent3 = this.myPortComponent;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/RBundle", RubyRemoteDebugConfigurationForm.class).getString("remote.debug.port"));
        jPanel2.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent4 = this.myLocalRootComponent;
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/RBundle", RubyRemoteDebugConfigurationForm.class).getString("remote.debug.local.root.folder"));
        jPanel2.add((Component)labeledComponent4, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<JTextField> labeledComponent5 = this.myDispatcherPortComponent;
        labeledComponent5.setLabelLocation("West");
        labeledComponent5.setText(DynamicBundle.getBundle((String)"messages/RBundle", RubyRemoteDebugConfigurationForm.class).getString("remote.debug.dispatcher.port"));
        jPanel2.add((Component)labeledComponent5, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.putClientProperty("html.disable", Boolean.FALSE);
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/RBundle", RubyRemoteDebugConfigurationForm.class).getString("remote.debug.info"), (int)0, (int)0, null, null));
        this.myInfoTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setText("rdebug-ide --port $PORT_NUMBER$ -- $SCRIPT$");
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 3, 6, 0, null, new Dimension(150, -1), null));
        this.myCommandLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RBundle", RubyRemoteDebugConfigurationForm.class).getString("remote.debug.server.command.text"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/RBundle", RubyRemoteDebugConfigurationForm.class).getString("remote.debug.server.hint"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.generatedPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

