/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunEnvironmentProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun.JRubyNailgunSettingsPanel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public class JRubyRunNailgunServerAction
extends DumbAwareAction {
    public static final Key<Ref<Integer>> NAILGUN_PORT = Key.create((String)"nailgun.port");
    public static final Key<String> NAILGUN_CLASSPATH = Key.create((String)"nailgun.classpath");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JRubyRunNailgunServerAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            JRubyRunNailgunServerAction.$$$reportNull$$$0(1);
        }
        Pair<Sdk, Module> pair = JRubyRunNailgunServerAction.getSdkAndModule(e.getDataContext());
        Sdk sdk = (Sdk)pair.getFirst();
        e.getPresentation().setEnabledAndVisible(pair.getSecond() != null && sdk != null && JRubySdkUtil.isJRubySDK(sdk));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            JRubyRunNailgunServerAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        Pair<Sdk, Module> sdkAndModule = JRubyRunNailgunServerAction.getSdkAndModule(e.getDataContext());
        final Sdk sdk = (Sdk)sdkAndModule.getFirst();
        final Module module = (Module)sdkAndModule.getSecond();
        assert (project != null);
        assert (module != null);
        if (sdk == null) {
            JRubyRunNailgunServerAction.showNailgunMessage(NotificationType.ERROR, RBundle.message((String)"sdk.error.jruby.jdk.type.incorrect", (Object[])new Object[]{RBundle.message((String)"nailgun.server")}));
            return;
        }
        Pair<Integer, String> pair = NailgunServerOptionsDialog.showDialog(project);
        final int port = (Integer)pair.getFirst();
        final String classPath = (String)pair.getSecond();
        project.putUserData(NAILGUN_CLASSPATH, (Object)classPath);
        if (port == -1) {
            return;
        }
        module.putUserData(NAILGUN_PORT, (Object)new Ref((Object)port));
        ModuleRunProfile profile = new ModuleRunProfile(){

            @NotNull
            public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                final GeneralCommandLine cmdLine = JRubyRunNailgunServerAction.createCommandLine(module, sdk, port, classPath);
                return new CommandLineState(this, env){

                    @NotNull
                    protected ProcessHandler startProcess() throws ExecutionException {
                        ColoredProcessHandler handler = new ColoredProcessHandler(cmdLine);
                        ProcessTerminatedListener.attach((ProcessHandler)handler);
                        ColoredProcessHandler coloredProcessHandler = handler;
                        if (coloredProcessHandler == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return coloredProcessHandler;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/run/configuration/nailgun/JRubyRunNailgunServerAction$1$1", "startProcess"));
                    }
                };
            }

            @NotNull
            public String getName() {
                String string = RBundle.message((String)"nailgun.server.name");
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Nullable
            public Icon getIcon() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/nailgun/JRubyRunNailgunServerAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/nailgun/JRubyRunNailgunServerAction$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        try {
            ExecutionEnvironmentBuilder.create((Project)project, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)profile).buildAndExecute();
        }
        catch (Exception e1) {
            JRubyRunNailgunServerAction.showNailgunMessage(NotificationType.ERROR, RBundle.message((String)"nailgun.server.fail"));
        }
    }

    @NotNull
    static Pair<Sdk, Module> getSdkAndModule(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Pair pair = Pair.create((Object)JRubyRunNailgunServerAction.getSdk(project, module), (Object)module);
        if (pair == null) {
            JRubyRunNailgunServerAction.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Nullable
    static Sdk getSdk(Project project, Module module) {
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            sdk = Objects.requireNonNull(ProjectRootManager.getInstance((Project)project), "Unable to get root manager for " + String.valueOf(project)).getProjectSdk();
        }
        return sdk;
    }

    private static GeneralCommandLine createCommandLine(Module module, Sdk sdk, int port, @Nullable String cp) {
        String path = RubySdkAdditionalData.getInterpreterPathFor(sdk);
        ArrayList<String> args = new ArrayList<String>();
        args.add(path);
        args.add("--ng-server");
        if (port != 2113) {
            args.add(String.valueOf(port));
        }
        GeneralCommandLine line = new GeneralCommandLine(args);
        Map map = line.getEnvironment();
        RubyRunner runner = RunnerUtil.getRunner(sdk, module);
        map.putAll(runner.getParentEnv());
        JRubyRunNailgunServerAction.addClassPathEnv(module, sdk, cp, map);
        return line;
    }

    private static void addClassPathEnv(Module module, Sdk sdk, String cp, Map<String, String> map) {
        if (cp == null) {
            RunEnvironmentProvider.processRunConfig(sdk, module, map);
        } else if (!cp.isEmpty()) {
            map.put("CLASSPATH", cp);
        }
    }

    private static void showNailgunMessage(NotificationType type, @NlsContexts.NotificationContent @NotNull String message) {
        if (message == null) {
            JRubyRunNailgunServerAction.$$$reportNull$$$0(4);
        }
        Notifications.Bus.notify((Notification)new Notification("Nailgun Server Debug", RBundle.message((String)"nailgun.server.name"), message, type));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/nailgun/JRubyRunNailgunServerAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/nailgun/JRubyRunNailgunServerAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkAndModule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showNailgunMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class NailgunServerOptionsDialog
    extends DialogWrapper {
        private final boolean showClassPathField;
        private final JRubyNailgunSettingsPanel nailgunPanel;

        protected NailgunServerOptionsDialog(@Nullable Project project, boolean showClassPathField) {
            super(project);
            this.showClassPathField = showClassPathField;
            this.setTitle(RBundle.message((String)"nailgun.server.settings"));
            this.nailgunPanel = new JRubyNailgunSettingsPanel(showClassPathField, project != null ? (String)project.getUserData(NAILGUN_CLASSPATH) : ""){

                @Override
                protected void validate(String port, String classPath) {
                    boolean isOk;
                    try {
                        isOk = Integer.parseInt(port) > 0;
                    }
                    catch (NumberFormatException e1) {
                        isOk = false;
                    }
                    this.setOKActionEnabled(isOk);
                }
            };
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.nailgunPanel.getMainPanel();
        }

        public int getPort() {
            return Integer.parseInt(this.nailgunPanel.getPort());
        }

        public String getClassPath() {
            return this.showClassPathField ? this.nailgunPanel.getClassPath() : null;
        }

        @NotNull
        public static Pair<Integer, String> showDialog(@NotNull Project project) {
            Application application;
            if (project == null) {
                NailgunServerOptionsDialog.$$$reportNull$$$0(0);
            }
            if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
                return new Pair((Object)2113, null);
            }
            NailgunServerOptionsDialog dialog = new NailgunServerOptionsDialog(project, PlatformUtils.isRubyMine());
            dialog.show();
            return dialog.getExitCode() == 0 ? new Pair((Object)dialog.getPort(), (Object)dialog.getClassPath()) : new Pair((Object)-1, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/ruby/run/configuration/nailgun/JRubyRunNailgunServerAction$NailgunServerOptionsDialog", "showDialog"));
        }
    }
}

