/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun.JRubyRunNailgunServerAction;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public final class JRubyNailgunUtil {
    private static final Logger LOG = Logger.getInstance(JRubyNailgunUtil.class);
    public static final int DEFAULT_PORT = 2113;
    private static final int DELAY_TIME = 150;
    private static final int MAX_CONNECTION_ATTEMPTS = 3;
    private static final String NAILGUN_PORT_PARAM = "--nailgun-port";
    private static final String NG_PARAM = "--ng";
    @NonNls
    static final String NAILGUN_RUN_NOTIFICATION_GROUP_ID = "Nailgun Server Run";
    @NonNls
    static final String NAILGUN_DEBUG_NOTIFICATION_GROUP_ID = "Nailgun Server Debug";

    public static void patchCmdLineForNailGunServer(@NotNull AbstractRubyRunConfiguration configuration, String runnerId, GeneralCommandLine cmdLine) {
        if (configuration == null) {
            JRubyNailgunUtil.$$$reportNull$$$0(0);
        }
        Sdk sdk = configuration.getSdk();
        Project project = configuration.getProject();
        String commandLineString = cmdLine.getCommandLineString();
        if (RubyAbstractCommandLineState.isInRubyDebugMode(runnerId)) {
            JRubyNailgunUtil.removeNailgunParameters(cmdLine);
            JRubyNailgunUtil.showNailgunNotification(RBundle.message((String)"nailgun.server.in.debug"), NotificationType.WARNING, project, NAILGUN_DEBUG_NOTIFICATION_GROUP_ID);
            return;
        }
        assert (JRubySdkUtil.isJRubySDK(sdk));
        Pair<NailgunServerAnalysisResult, Integer> pair = JRubyNailgunUtil.detectNailgunServer(sdk, commandLineString);
        NailgunServerAnalysisResult first = (NailgunServerAnalysisResult)((Object)pair.getFirst());
        int port = (Integer)pair.getSecond();
        switch (first.ordinal()) {
            case 1: {
                JRubyNailgunUtil.addNGParameterToCommandLine(cmdLine);
                break;
            }
            case 0: {
                JRubyNailgunUtil.addNGParameterToCommandLine(cmdLine);
                JRubyNailgunUtil.runNailgunServer(cmdLine, configuration);
                break;
            }
            case 3: {
                JRubyNailgunUtil.addNGParameterToCommandLine(cmdLine);
                JRubyNailgunUtil.updateNailgunServerPort(cmdLine, port);
                JRubyNailgunUtil.showNailgunNotification(RBundle.message((String)"nailgun.server.fail.port"), NotificationType.WARNING, project, NAILGUN_RUN_NOTIFICATION_GROUP_ID);
                break;
            }
            case 2: {
                JRubyNailgunUtil.showNailgunNotification(RBundle.message((String)"nailgun.server.fail.gemset"), NotificationType.WARNING, project, NAILGUN_RUN_NOTIFICATION_GROUP_ID);
            }
        }
    }

    public static boolean isNailgunSupportEnabled() {
        return Registry.is((String)"nailgun.server.support");
    }

    private static void showNailgunNotification(@NlsContexts.NotificationContent String message, NotificationType type, Project project, @NotNull @NonNls String notificationGroupId) {
        NotificationGroup notificationGroup;
        if (notificationGroupId == null) {
            JRubyNailgunUtil.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((notificationGroup = NotificationGroup.findRegisteredGroup((String)notificationGroupId)) != null, (Object)("Missing group: " + notificationGroupId));
        notificationGroup.createNotification(message, type).notify(project);
    }

    private static void removeNailgunParameters(GeneralCommandLine line) {
        ParametersList list = line.getParametersList();
        List parameters = list.getParameters();
        list.replaceOrAppend(NG_PARAM, "");
        int portIndex = parameters.indexOf(NAILGUN_PORT_PARAM);
        if (portIndex != -1) {
            list.replaceOrAppend(list.get(portIndex + 1), "");
            list.replaceOrAppend(list.get(portIndex), "");
        }
    }

    private static void addNGParameterToCommandLine(GeneralCommandLine line) {
        line.getParametersList().replaceOrPrepend(NG_PARAM, NG_PARAM);
    }

    private static void updateNailgunServerPort(GeneralCommandLine line, int newPort) {
        ParametersList list = line.getParametersList();
        int portIndex = list.getParameters().indexOf(NAILGUN_PORT_PARAM);
        if (portIndex == -1) {
            list.add(NAILGUN_PORT_PARAM, String.valueOf(newPort));
            return;
        }
        try {
            String s = list.get(portIndex + 1);
            Integer.parseInt(s);
            list.set(portIndex + 1, String.valueOf(newPort));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void runNailgunServer(GeneralCommandLine cmdLine, @NotNull AbstractRubyRunConfiguration configuration) {
        Ref portRef;
        if (configuration == null) {
            JRubyNailgunUtil.$$$reportNull$$$0(2);
        }
        AnAction action = ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun.JRubyRunNailgunServerAction");
        Module module = Objects.requireNonNull(configuration.getModule());
        DataContext dataContext = SimpleDataContext.builder().add(PlatformCoreDataKeys.MODULE, (Object)module).add(CommonDataKeys.PROJECT, (Object)configuration.getProject()).build();
        AnActionEvent e = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)dataContext);
        AtomicReference result = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> result.set(ActionUtil.performAction((AnAction)action, (AnActionEvent)e)));
        if (result.get() != null && ((AnActionResult)result.get()).isPerformed() && (portRef = (Ref)module.getUserData(JRubyRunNailgunServerAction.NAILGUN_PORT)) != null) {
            Integer port = (Integer)portRef.get();
            JRubyNailgunUtil.updateNailgunServerPort(cmdLine, port);
            JRubyNailgunUtil.waitUntilServerStarts(port);
        }
    }

    private static void waitUntilServerStarts(int port) {
        Socket socket = new Socket();
        InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
        for (int i = 0; i < 3; ++i) {
            try {
                socket.connect(address, 150);
                break;
            }
            catch (Exception exception) {
                DebugUtil.sleep((long)150L);
                continue;
            }
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Pair<NailgunServerAnalysisResult, Integer> detectNailgunServer(Sdk sdk, String cmd) {
        if (SystemInfo.isWindows) {
            NailgunServerAnalysisResult serverResult = NailgunServerAnalysisResult.NO_SUITABLE_SERVER;
            for (ProcessInfo info : OSProcessUtil.getProcessList()) {
                String s = info.getCommandLine();
                if (!s.contains("NGServer") && !s.contains("--ng-server")) continue;
                serverResult = NailgunServerAnalysisResult.SUITABLE_SERVER;
                break;
            }
            return new Pair((Object)serverResult, (Object)JRubyNailgunUtil.getServerPort(cmd));
        }
        Map<Integer, Boolean> gemsetResult = JRubyNailgunUtil.analyzeExistingUnixProcesses(sdk);
        if (gemsetResult.isEmpty()) {
            return new Pair((Object)NailgunServerAnalysisResult.NO_SUITABLE_SERVER, (Object)JRubyNailgunUtil.getServerPort(cmd));
        }
        Set<Integer> pidsSet = gemsetResult.keySet();
        Map<Integer, Integer> portResult = JRubyNailgunUtil.analyzeServerPort(pidsSet);
        int defaultPort = JRubyNailgunUtil.getServerPort(cmd);
        NailgunServerAnalysisResult result = null;
        int port = defaultPort;
        for (Integer pid : pidsSet) {
            Boolean properGemset = gemsetResult.get(pid);
            Integer pidPort = portResult.get(pid);
            if (properGemset.booleanValue() && pidPort == defaultPort) {
                return new Pair((Object)NailgunServerAnalysisResult.SUITABLE_SERVER, (Object)defaultPort);
            }
            if (properGemset.booleanValue()) {
                result = NailgunServerAnalysisResult.GOOD_GEMSET_WRONG_PORT;
                port = pidPort;
                continue;
            }
            if (pidPort == defaultPort) {
                if (result == NailgunServerAnalysisResult.GOOD_GEMSET_WRONG_PORT) continue;
                result = NailgunServerAnalysisResult.WRONG_GEMSET_GOOD_PORT;
                port = defaultPort;
                continue;
            }
            if (result == NailgunServerAnalysisResult.GOOD_GEMSET_WRONG_PORT || result == NailgunServerAnalysisResult.WRONG_GEMSET_GOOD_PORT) continue;
            result = NailgunServerAnalysisResult.NO_SUITABLE_SERVER;
        }
        return new Pair(result, (Object)port);
    }

    private static Map<Integer, Integer> analyzeServerPort(Set<Integer> serverPids) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        List<String> cmdArgs = JRubyNailgunUtil.createLsofCommandLine(serverPids);
        UnixProcessManager.processPSOutput((String[])ArrayUtilRt.toStringArray(cmdArgs), s -> {
            String[] split = s.split("\\s+", 3);
            int pid = -1;
            try {
                pid = Integer.parseInt(split[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int index = s.indexOf("*:");
            String portString = s.substring(index + 2);
            int port = -1;
            try {
                port = Integer.parseInt(portString.substring(0, portString.indexOf(" ")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pid != -1 && port != -1) {
                map.put(pid, port);
            }
            return true;
        });
        return map;
    }

    private static List<String> createLsofCommandLine(Set<Integer> serverPids) {
        ArrayList<String> list = new ArrayList<String>();
        String lsofCmd = "usr/bin/lsof";
        if (!new File(lsofCmd).isFile()) {
            lsofCmd = "lsof";
        }
        list.add(lsofCmd);
        list.add("-Pan");
        for (Integer pid : serverPids) {
            list.add("+p");
            list.add(String.valueOf(pid));
        }
        list.add("-i");
        list.add("tcp");
        return list;
    }

    private static Map<Integer, Boolean> analyzeExistingUnixProcesses(Sdk sdk) {
        String psCommand = "/bin/ps";
        if (!new File(psCommand).isFile()) {
            psCommand = "ps";
        }
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        UnixProcessManager.processPSOutput((String[])new String[]{psCommand, "xe"}, s -> {
            if (s.contains("NGServer")) {
                int pid = JRubyNailgunUtil.getPidFromPSOutput(s.trim());
                if (pid == -1) {
                    return false;
                }
                String actualGemsetPath = JRubyNailgunUtil.getGemsetPathFromPSOutput(s);
                if (actualGemsetPath == null) {
                    return false;
                }
                String sdkGemsetName = RVMSupportUtil.getGemsetPresentableName(sdk);
                if ("[default]".equals(sdkGemsetName)) {
                    map.put(pid, true);
                    return true;
                }
                Collection<String> sdkPath = GemManager.getInstance().getGemRootUrlsForSDK(sdk);
                for (String st : sdkPath) {
                    if (st.length() <= 7) {
                        LOG.warn("Unexpected ps output format (" + st + ")");
                        continue;
                    }
                    String sdkGemset = st.substring(7, st.indexOf("@") + 1) + sdkGemsetName;
                    if (!actualGemsetPath.equals(sdkGemset)) continue;
                    map.put(pid, true);
                    return true;
                }
                map.put(pid, false);
            }
            return true;
        });
        return map;
    }

    private static int getPidFromPSOutput(String s) {
        String pidStr = s.substring(0, s.indexOf(" "));
        try {
            return Integer.parseInt(pidStr);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Nullable
    private static String getGemsetPathFromPSOutput(String s) {
        int i1 = s.indexOf("GEM_HOME");
        if (i1 == -1) {
            return null;
        }
        String str = s.substring(i1 + 9);
        int i2 = str.indexOf("@");
        if (i2 == -1) {
            return str.substring(0, str.indexOf(" "));
        }
        int i3 = str.indexOf(" ", i2);
        str = str.substring(0, i3);
        return str;
    }

    private static int getServerPort(String cmd) {
        int startIndex = cmd.indexOf(NAILGUN_PORT_PARAM);
        if (startIndex == -1) {
            return 2113;
        }
        String[] split = cmd.substring(startIndex).split(" ");
        if (split.length < 2) {
            return 2113;
        }
        String portString = split[1];
        try {
            return Integer.parseInt(portString);
        }
        catch (Exception e) {
            return 2113;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationGroupId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/nailgun/JRubyNailgunUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCmdLineForNailGunServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showNailgunNotification";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runNailgunServer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum NailgunServerAnalysisResult {
        NO_SUITABLE_SERVER,
        SUITABLE_SERVER,
        WRONG_GEMSET_GOOD_PORT,
        GOOD_GEMSET_WRONG_PORT;

    }
}

