/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.debugger;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.statistic.InstallationState;
import org.jetbrains.plugins.ruby.statistic.RubyDebugGemInstallationCollectorKt;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.jetbrains.plugins.ruby.utils.RubyUIUtil;

public final class RubyDebugIdeGemHelper
implements DebugGemHelper {
    @NonNls
    private static final String RDI_NAME = "ruby-debug-ide";
    @NonNls
    public static final String DEBASE_NAME = "debase";
    @NonNls
    private static final String RDB_NAME = "ruby-debug-base";
    @NonNls
    private static final String RDB19_NAME = "ruby-debug-base19x";
    @NonNls
    private static final String DEFAULT_DEBUG_GEM_NAME = "debug";
    @NonNls
    private static final String DEBUG = "--debug";
    @NonNls
    private static final String RDI_GEMSPEC_FILE = "RDI_GEMSPEC_FILE";
    @NonNls
    private static final String DEBASE_GEMSPEC_FILE = "DEBASE_GEMSPEC_FILE";
    @NonNls
    private static final String MAX_TIME_UNTIL_DEBUGGER_TIMEOUT = "ruby.debugger.installation.timeout";
    @NonNls
    private static final String MAX_TIME_TO_WAIT_VFS_AFTER_DEBUG_GEM_INSTALLED_KEY = "ruby.debugger.debase.detection.wait.limit.after.installation";
    private static final Logger LOG = Logger.getInstance(RubyDebugIdeGemHelper.class);
    private static final Pattern RDB_JRUBY_GEM_OLD_PATTERN = Pattern.compile("ruby-debug-base-(0\\.10(\\.[0-9A-z]+)*)-java.gem");
    private static final Pattern RDB_JRUBY_GEM_NEW_PATTERN = Pattern.compile("ruby-debug-base-(0\\.11(\\.[0-9A-z]+)*)-java.gem");
    private static final Pattern ANY_VERSION_PATTERN = Pattern.compile("([0-9]+(\\.[0-9A-z]+)*)");
    private static final Pattern RDB_GEM_NAME_PATTERN = Pattern.compile("ruby-debug-base-([0-9]+(\\.[0-9A-z]+)*).gem");
    private static final Pattern RDB19_GEM_NAME_PATTERN = Pattern.compile("ruby-debug-base19x-([0-9]+(\\.[0-9A-z]+)*).gem");
    private static final Pattern RDB_WIN_GEM_NAME_PATTERN = Pattern.compile("ruby-debug-base-([0-9]+(\\.[0-9A-z]+)*)(-x86)?-mswin32.gem");
    private static final String RDI_OSS_VERSION_PATTERN_TEXT = "(0\\.7(\\.[0-9A-z]+)*)";
    private static final String RDI_JB_VERSION_PATTERN_TEXT = "(2\\.3(\\.[0-9A-z]+)*)";
    private static final String RDI_JB_30_VERSION_PATTERN_TEXT = "(3\\.0(\\.[0-9A-z]+)*)";
    private static final Pattern RDI_OSS_VERSION_PATTERN = Pattern.compile("(0\\.7(\\.[0-9A-z]+)*)");
    private static final Pattern RDI_JB_VERSION_PATTERN = Pattern.compile("(2\\.3(\\.[0-9A-z]+)*)");
    private static final Pattern RDI_JB_30_VERSION_PATTERN = Pattern.compile("(3\\.0(\\.[0-9A-z]+)*)");
    private static final Pattern RDI_OSS_GEM_PATTERN = Pattern.compile("ruby-debug-ide-(0\\.7(\\.[0-9A-z]+)*).gem");
    private static final Pattern RDI_JB_GEM_PATTERN = Pattern.compile("ruby-debug-ide-(2\\.3(\\.[0-9A-z]+)*).gem");
    private static final Pattern RDI_JB_30_GEM_PATTERN = Pattern.compile("ruby-debug-ide-(3\\.0(\\.[0-9A-z]+)*).gem");
    private static final String DEBASE_OSS_VERSION_PATTERN_TEXT = "(0\\.2(\\.[0-9A-z]+)*)";
    private static final String DEBASE_JB_VERSION_PATTERN_TEXT = "(2\\.3(\\.[0-9A-z]+)*)";
    private static final String DEBASE_JB_30_VERSION_PATTERN_TEXT = "(3\\.0(\\.[0-9A-z]+)*)";
    private static final Pattern DEBASE_OSS_VERSION_PATTERN = Pattern.compile("(0\\.2(\\.[0-9A-z]+)*)");
    private static final Pattern DEBASE_JB_VERSION_PATTERN = Pattern.compile("(2\\.3(\\.[0-9A-z]+)*)");
    private static final Pattern DEBASE_JB_30_VERSION_PATTERN = Pattern.compile("(3\\.0(\\.[0-9A-z]+)*)");
    private static final Pattern DEBASE_OSS_GEM_PATTERN = Pattern.compile("debase-(0\\.2(\\.[0-9A-z]+)*).gem");
    private static final Pattern DEBASE_JB_GEM_PATTERN = Pattern.compile("debase-(2\\.3(\\.[0-9A-z]+)*).gem");
    private static final Pattern DEBASE_JB_30_GEM_PATTERN = Pattern.compile("debase-(3\\.0(\\.[0-9A-z]+)*).gem");
    private static final String RDI_JB_VERSION = "2.3.26";
    private static final String RDI_JB_30_VERSION = "3.0.12";
    private static final String RDI_OSS_VERSION = "0.7.5";
    private static final String RDB19_VERSION = "0.11.32";
    private static final String DEBASE_OSS_VERSION = "0.2.9";
    private static final String DEBASE_JB_VERSION = "2.3.16";
    private static final String DEBASE_JB_30_VERSION = "3.0.12";
    private static final String RDB_GEM_VERSION = "0.10.5.rc10";
    private static final String RDB_JAVA_NEW_GEM_VERSION = "0.11.1";
    private static final String RDB_JAVA_OLD_GEM_VERSION = "0.10.6";
    public static final String DEBUGGER_PRESENT_ASKED = "debugger.present.asked";
    public static final String DEBUGGER_SHOULD_USE_DEBASE_23 = "ruby.use.debase23.debugger";
    public static final String DEBUGGER_SHOULD_USE_DEBASE_30 = "ruby.use.debase30.debugger";
    private static final String MIN_VERSION_DISABLE_DEFAULT_DEBUG_GEM = "1.6.2";
    private static Integer DEBUGGER_GEM_INSTALLATION_COUNT = 0;
    @Nullable
    private final State myState;
    @NotNull
    private final RubyDebugMode myMode;

    public RubyDebugIdeGemHelper(@Nullable State state, @NotNull RubyDebugMode mode) {
        if (mode == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(0);
        }
        this.myState = state;
        this.myMode = mode;
    }

    @Nullable
    public static GemInfo findGem(@NotNull String gemName, @Nullable Module module, @NotNull Sdk sdk) {
        if (gemName == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(1);
        }
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(2);
        }
        GemInfo ideGem = null;
        if (module != null) {
            ideGem = RubyProjectGemSearchService.Companion.findGem(module, gemName);
        }
        return ideGem != null ? ideGem : RubyGemSearchUtil.findGem(module, sdk, gemName);
    }

    public static boolean checkForDebuggerPresence(@Nullable Module module) {
        return RubyDebugIdeGemHelper.checkForGemPresence(module, "debugger", DEBUGGER_PRESENT_ASKED);
    }

    static boolean sdkEffectiveLanguageLevelGreaterThan22(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(3);
        }
        return RubyDebugIdeGemHelper.isSdkEffectiveLanguageLevelGreaterThan(sdk, LanguageLevel.RUBY22);
    }

    private static boolean isSdkEffectiveLanguageLevelGreaterThan(@NotNull Sdk sdk, @NotNull LanguageLevel languageLevel) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(4);
        }
        if (languageLevel == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(5);
        }
        return languageLevel.isLessThan(RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk));
    }

    static boolean sdkEffectiveLanguageLevelGreaterThan27(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(6);
        }
        return RubyDebugIdeGemHelper.isSdkEffectiveLanguageLevelGreaterThan(sdk, LanguageLevel.RUBY27);
    }

    static boolean sdkEffectiveLanguageLevelGreaterThan33(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(7);
        }
        return RubyDebugIdeGemHelper.isSdkEffectiveLanguageLevelGreaterThan(sdk, LanguageLevel.RUBY33);
    }

    public static boolean isDebase23Enabled(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(8);
        }
        return Registry.is((String)DEBUGGER_SHOULD_USE_DEBASE_23, (boolean)true) && RubyDebugIdeGemHelper.isDebase23Compatible(sdk);
    }

    public static boolean isDebase30Enabled(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(9);
        }
        return Registry.is((String)DEBUGGER_SHOULD_USE_DEBASE_30, (boolean)true) && RubyDebugIdeGemHelper.isDebase30Compatible(sdk);
    }

    public static boolean isDebaseEnabled(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(10);
        }
        return RubyDebugIdeGemHelper.isDebase23Enabled(sdk) || RubyDebugIdeGemHelper.isDebase30Enabled(sdk);
    }

    public static boolean isDebase23Compatible(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(11);
        }
        return RubySdkUtil.isMRISdk(sdk) && RubyDebugIdeGemHelper.sdkEffectiveLanguageLevelGreaterThan22(sdk) && !RubyDebugIdeGemHelper.sdkEffectiveLanguageLevelGreaterThan33(sdk);
    }

    public static boolean isDebase30Compatible(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(12);
        }
        return RubySdkUtil.isMRISdk(sdk) && RubyDebugIdeGemHelper.sdkEffectiveLanguageLevelGreaterThan27(sdk);
    }

    static boolean sdkEffectiveLanguageLevelGreaterThan23(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(13);
        }
        return RubyDebugIdeGemHelper.isSdkEffectiveLanguageLevelGreaterThan(sdk, LanguageLevel.RUBY23);
    }

    private static boolean checkForGemPresence(@Nullable Module module, @NotNull String gemName, @NotNull String askedProperty) {
        if (gemName == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(14);
        }
        if (askedProperty == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(15);
        }
        if (module == null || PropertiesComponent.getInstance((Project)module.getProject()).getBoolean(askedProperty)) {
            return true;
        }
        GemInfo debuggerInfo = RubyProjectGemSearchService.Companion.findGem(module, gemName);
        if (debuggerInfo == null) {
            return true;
        }
        int res = RubyUIUtil.showYesNoDialogFromEDT(module.getProject(), RubyDebugIdeGemHelper.getDialogMessage(gemName), RBundle.message((String)"gems.debugger.alert.title"), Messages.getQuestionIcon());
        if (res == 0) {
            PropertiesComponent.getInstance((Project)module.getProject()).setValue(askedProperty, true);
            return true;
        }
        return false;
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getDialogMessage(@NotNull String gemName) {
        if (gemName == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(16);
        }
        String string = new HtmlBuilder().appendRaw(RBundle.message((String)"gems.debugger.in.gemfile", (Object[])new Object[]{gemName, RBundle.link((String)"https://www.jetbrains.com/help/ruby/debugging-code.html", (String)"gems.debugger.in.gemfile.check.link.text")})).wrapWithHtmlBody().toString();
        if (string == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String getDebugFrontEndGemName() {
        return RDI_NAME;
    }

    @NotNull
    public String getDebugBackendEndGemName(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(18);
        }
        String string = BackendDebugGemType.getBaseType(sdk, false).getGemInfo().getGemName();
        if (string == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    public boolean isUsable() {
        return this.myState != null;
    }

    @Override
    public void configureEnvironment(@NotNull Map<String, String> env, @NotNull RubySdkSystemAccessor accessor, @NotNull PathMappingSettings mappingSettings) {
        if (env == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(20);
        }
        if (accessor == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(21);
        }
        if (mappingSettings == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(22);
        }
        LOG.assertTrue(this.myState != null);
        if (this.myState.myShouldDisableDefaultDebugGem) {
            env.putIfAbsent("RUBY_DEBUG_ENABLE", "0");
        }
        if (this.myState.myPassGemspecFile) {
            RubyDebugIdeGemHelper.passGemspecFile(env, mappingSettings, RDI_GEMSPEC_FILE, this.myState.myFrontEndGeminfo);
            RubyDebugIdeGemHelper.passGemspecFile(env, mappingSettings, DEBASE_GEMSPEC_FILE, this.myState.myBackEndGemInfo);
        } else {
            this.patchRubyLib(env, accessor, mappingSettings);
        }
    }

    private static void passGemspecFile(@NotNull Map<String, String> env, @NotNull PathMappingSettings mappingSettings, String key, GemInfo gemInfo) {
        VirtualFile gemspecFile;
        if (env == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(23);
        }
        if (mappingSettings == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(24);
        }
        LOG.assertTrue((gemspecFile = gemInfo.getSpecFile()) != null);
        String remoteGemspecFilePath = mappingSettings.convertToRemote(gemspecFile.getPath());
        env.put(key, remoteGemspecFilePath);
        LOG.debug(key, new Object[]{" set to ", remoteGemspecFilePath});
    }

    private void patchRubyLib(@NotNull Map<String, String> env, @NotNull RubySdkSystemAccessor accessor, @NotNull PathMappingSettings mappingSettings) {
        if (env == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(25);
        }
        if (accessor == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(26);
        }
        if (mappingSettings == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(27);
        }
        String rubyLib = env.get("RUBYLIB");
        rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(Objects.requireNonNull(this.myState.myFrontEndGeminfo.getLibFolder()).getPath()));
        rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(Objects.requireNonNull(this.myState.myBackEndGemInfo.getLibFolder()).getPath()));
        if (this.myState.myLineCacheNeeded) {
            VirtualFile linecacheLib = this.myState.myLineCacheLib;
            LOG.assertTrue(linecacheLib != null);
            rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(linecacheLib.getPath()));
        }
        LOG.debug("RUBYLIB set to: ", new Object[]{rubyLib});
        env.put("RUBYLIB", rubyLib);
    }

    @Override
    public boolean isMultiProcessDebugSupported() {
        assert (this.myState != null) : "state must not be null at this point";
        return this.myState.myMultiProcessDebugSupported;
    }

    @Override
    @NotNull
    public String getRdebugScriptPath() {
        assert (this.myState != null) : "state must not be null at this point";
        String string = this.myState.myRDebugScriptPath;
        if (string == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @NotNull
    public String getErrorMsg() {
        String string = RBundle.message((String)"gem.not.found.executable.for.gem", (Object[])new Object[]{RDI_NAME, this.myMode.getDebugScript()});
        if (string == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Override
    public void enableVerboseMode(@NotNull List<String> args, boolean enableMode) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(30);
        }
        if (enableMode) {
            args.add(DEBUG);
        }
    }

    @Override
    public void enableKeyValuePresentation(@NotNull List<String> args, boolean enableMode) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(31);
        }
        if (this.myState != null && this.myState.myKeyValueHashAvailable) {
            args.add("--key-value");
        }
    }

    @Override
    public void enableSteppingOverIntoBlocks(@NotNull List<String> args, boolean enableMode) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(32);
        }
        if (this.myState != null && this.myState.mySmartSrepOverSupported && enableMode) {
            args.add("--step-over-in-blocks");
        }
    }

    @Override
    public void disableIntHandler(@NotNull List<String> args, boolean disableHandler) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(33);
        }
        if (disableHandler) {
            args.add("--disable-int-handler");
        }
    }

    @Override
    public void setEvaluationTimeout(@NotNull List<String> args, int seconds) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(34);
        }
        if (this.myState != null && this.myState.myTimeoutConfigurable) {
            args.add("--evaluation-timeout");
            args.add(Integer.toString(seconds));
        }
    }

    @Override
    public void enableEvaluationControl(@NotNull List<String> args, boolean enableMode) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(35);
        }
        if (this.myState != null && this.myState.myEvaluationControlConfigurable && enableMode) {
            args.add("--evaluation-control");
        }
    }

    @Override
    public void setEvaluationTimeLimit(@NotNull List<String> args, int milliseconds) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(36);
        }
        if (this.myState != null && this.myState.myEvaluationControlConfigurable) {
            args.add("--time-limit");
            args.add(Integer.toString(milliseconds));
        }
    }

    @Override
    public void setEvaluationMemoryLimit(@NotNull List<String> args, int megabytes) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(37);
        }
        if (this.myState != null && this.myState.myEvaluationControlConfigurable) {
            args.add("--memory-limit");
            args.add(Integer.toString(megabytes));
        }
    }

    @Override
    public void setFullValueEvaluationTimeLimit(@NotNull List<String> args, int milliseconds) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(38);
        }
        args.add("--full-value-time-limit");
        args.add(Integer.toString(milliseconds));
    }

    @Override
    public void setFulValueEvaluationMemoryLimit(@NotNull List<String> args, int megabytes) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(39);
        }
        args.add("--full-value-memory-limit");
        args.add(Integer.toString(megabytes));
    }

    @Override
    public void addGemSpecificArgs(@NotNull List<String> args) {
        if (args == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(40);
        }
        if (this.myState != null && this.myState.myRmProtocolExtensionsSupported) {
            args.add("--rubymine-protocol-extensions");
        }
    }

    @Override
    public boolean needsDebugPreLoader() {
        return true;
    }

    @Override
    public boolean supportsNonSuspendedFramesReading(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(41);
        }
        return !RubySdkUtil.isNativeRuby20(sdk) && !RubySdkUtil.isNativeRuby21(sdk) && !RubySdkUtil.isNativeRuby22(sdk) && !RubySdkUtil.isNativeRuby23(sdk) && !RubySdkUtil.isNativeRuby24(sdk) && !RubySdkUtil.isNativeRuby25(sdk) && !RubySdkUtil.isNativeRuby26(sdk) && !RubySdkUtil.isNativeRuby27(sdk) && !RubySdkUtil.isNativeRuby30(sdk) && !RubySdkUtil.isNativeRuby31(sdk) && !RubySdkUtil.isNativeRuby32(sdk) && !RubySdkUtil.isNativeRuby33(sdk) && !RubySdkUtil.isNativeRuby34(sdk);
    }

    @Override
    public boolean supportsCatchpointRemoval() {
        return this.myState != null && this.myState.myCatchPointRemovalSupported;
    }

    @Override
    public boolean supportsLoadingFullValue() {
        return this.myState != null && this.myState.myLoadingFullValueSupported;
    }

    @Override
    public boolean supportsTypeRenderers() {
        return this.myState != null && this.myState.myLoadingFullValueSupported;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@Nullable Project project) {
        if (project == null || !this.supportFileFiltering()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                RubyDebugIdeGemHelper.$$$reportNull$$$0(42);
            }
            return list;
        }
        List<VirtualFile> list = Arrays.asList(ProjectRootManager.getInstance((Project)project).getContentRoots());
        if (list == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(43);
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> getExcludedDirs(@Nullable Project project) {
        if (project == null || !this.supportFileFiltering()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                RubyDebugIdeGemHelper.$$$reportNull$$$0(44);
            }
            return list;
        }
        ArrayList<VirtualFile> excludedDirs = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ContainerUtil.addAll(excludedDirs, (Object[])ModuleRootManager.getInstance((Module)module).getExcludeRoots());
        }
        ArrayList<VirtualFile> arrayList = excludedDirs;
        if (arrayList == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    @Override
    public boolean supportFileFiltering() {
        return this.myState != null && this.myState.myFileFilterSupported;
    }

    @Override
    public boolean pauseActionSupported() {
        return true;
    }

    @Override
    public boolean debugConsoleSupported(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(46);
        }
        return this.myState != null && this.myState.myDebugConsoleSupported;
    }

    private static boolean askUserToInstallOrUpdateDebugGems(@NotNull Module module, @NotNull Sdk sdk, @NotNull Project project) {
        String yesText;
        String message;
        if (module == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(47);
        }
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(48);
        }
        if (project == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(49);
        }
        MyDebuggerGemsStatus status = MyDebuggerGemsStatus.from(module, sdk);
        String title = RBundle.message((String)"gems.debugger.alert.title");
        if (!status.isAllGemsInstalled()) {
            message = RBundle.message((String)"gems.install.debug.gem");
            yesText = RBundle.message((String)"gems.install.debug.gem.yes");
        } else {
            message = RBundle.message((String)"gems.update.debug.gem");
            yesText = RBundle.message((String)"gems.update.debug.gem.yes");
        }
        int installRubyDebugGemDialogResult = RubyUIUtil.showYesNoDialogFromEDT(project, message, title, yesText, Messages.getCancelButton(), Messages.getQuestionIcon());
        return installRubyDebugGemDialogResult == 0;
    }

    private static void refreshSdkLibraries(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(50);
        }
        LOG.debug("Refreshing SDK libraries...");
        RubySdkGemLibraryManager.getInstance().refreshRoots(sdk, false);
        RubySdkGemLibraryManager.getInstance().refresh(false);
    }

    private static void copyGemsToRemoteInterpreters(@Nullable Module module, @NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(51);
        }
        if (!RubyRemoteInterpreterManager.isRemoteSdk(sdk)) {
            return;
        }
        final Runnable installGemsRunnable = () -> RubyRemoteInterpreterManager.getInstance().updateGemsCopy(sdk, module, false);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            installGemsRunnable.run();
            return;
        }
        Project project = RModuleUtil.getInstance().getProject(module);
        Task.Backgroundable copyGemsTask = new Task.Backgroundable(project, "", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                installGemsRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)copyGemsTask);
    }

    @Nullable
    public static BackendDebugGemType getOrInstallDebugIdeGem(@Nullable Module module, @NotNull Sdk sdk) throws com.intellij.execution.ExecutionException {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(52);
        }
        return RubyDebugIdeGemHelper.getOrInstallDebugIdeGem(module, sdk, null, false);
    }

    public static Boolean installDebuggerGems(@Nullable Module module, @NotNull Sdk sdk, @Nullable String installDir, boolean forceInstall) throws TimeoutException, BundledGemsNotFoundException {
        List gemsToInstall;
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(53);
        }
        MyDebuggerGemsStatus status = MyDebuggerGemsStatus.from(module, sdk);
        BackendDebugGemType backendDebugGemType = status.getBackEndGemType();
        FrontendDebugGemType frontendDebugGemType = status.getFrontEndGemType();
        try {
            gemsToInstall = ContainerUtil.concat(backendDebugGemType.getGemsToInstall(), frontendDebugGemType.getGemsToInstall());
        }
        catch (com.intellij.execution.ExecutionException e) {
            throw new BundledGemsNotFoundException(e.getMessage());
        }
        if (gemsToInstall.isEmpty()) {
            LOG.info("No gems to install. Skipping installation.");
            return false;
        }
        final CompletableFuture processTerminatedFuture = new CompletableFuture();
        final CompletableFuture processStartedFuture = new CompletableFuture();
        ProcessListener installationListener = new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                LOG.info("Started debugger gem installation process!");
                processStartedFuture.complete(event.getProcessHandler());
            }

            public void processNotStarted() {
                LOG.info("Failed to start debugger gem installation process!");
                processStartedFuture.complete(null);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                LOG.info("Debugger gem installation process terminated with exit code: " + event.getExitCode());
                processTerminatedFuture.complete(event.getExitCode() == 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        LOG.debug("Starting gems installation.");
        GemInstallCommandOptions options = new GemInstallCommandOptions().withSources(ContainerUtil.map((Collection)gemsToInstall, GemDependency::getUrl)).withInstallDir(installDir).withNoDocument().withForce(forceInstall).withIgnoreDependencies(JRubySdkUtil.isJRubySDK(sdk));
        if (module == null) {
            HashMap<GemDependency, String> errors = new HashMap<GemDependency, String>();
            GemInstallUtil.installGemsInBackground(sdk, module, gemsToInstall, options, new GemInstallProcessOptions(errors).withUpdatingInstalledGems().withAsynchronousGemSync());
            return errors.isEmpty();
        }
        GemRunner.installInConsole(module, sdk, gemsToInstall, installationListener, options, RBundle.message((String)"gems.debugger.installation.console.title"));
        try {
            ProcessHandler handler = (ProcessHandler)processStartedFuture.get();
            if (handler == null) {
                LOG.info("Failed to acquire debugger gem installation process handler!");
                return false;
            }
            try {
                if (((Boolean)processTerminatedFuture.get(Registry.intValue((String)MAX_TIME_UNTIL_DEBUGGER_TIMEOUT), TimeUnit.SECONDS)).booleanValue()) {
                    RubyDebugIdeGemHelper.copyGemsToRemoteInterpreters(module, sdk);
                    return true;
                }
                return false;
            }
            catch (TimeoutException e) {
                LOG.info("Debugger gem installation process timed out!");
                handler.destroyProcess();
                throw e;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
    }

    @Nullable
    public static BackendDebugGemType getOrInstallDebugIdeGem(@Nullable Module module, @NotNull Sdk sdk, @Nullable String installDir, boolean forceInstall) throws com.intellij.execution.ExecutionException {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(54);
        }
        RubyDebugIdeGemHelper.refreshSdkLibraries(sdk);
        MyDebuggerGemsStatus status = MyDebuggerGemsStatus.from(module, sdk);
        boolean shouldInstallOrUpdateDebugGems = !status.isAllGemsInstalled() || !status.isAllGemsUpToDate();
        RubyDebugGemInstallationCollectorKt.logDebugGemsUpToDate(!shouldInstallOrUpdateDebugGems);
        if (!shouldInstallOrUpdateDebugGems) {
            LOG.info("No missing debugger dependencies detected. Skipping installation.");
            return status.getBackEndGemType();
        }
        DEBUGGER_GEM_INSTALLATION_COUNT = DEBUGGER_GEM_INSTALLATION_COUNT + 1;
        RubyDebugGemInstallationCollectorKt.logDebugGemsInstallationAttempt(DEBUGGER_GEM_INSTALLATION_COUNT);
        boolean userInstallationApproval = module == null || RubyDebugIdeGemHelper.askUserToInstallOrUpdateDebugGems(module, sdk, module.getProject());
        RubyDebugGemInstallationCollectorKt.logDebugGemsInstallationCancelled(!userInstallationApproval);
        if (!userInstallationApproval) {
            LOG.info("User cancelled debugger installation. Skipping installation.");
            throw new DebugGemInstallationCancelledException();
        }
        CompletableFuture<Boolean> gemsetChangedFuture = new CompletableFuture<Boolean>();
        LOG.debug("Subscribing to GEMSET_CHANGED_TOPIC.");
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(GemManager.GEMSET_CHANGED_TOPIC, modules -> {
            LOG.info("Change handler fired...");
            MyDebuggerGemsStatus callbackStatus = MyDebuggerGemsStatus.from(module, sdk);
            if (callbackStatus.isAllGemsInstalled() && callbackStatus.isAllGemsUpToDate()) {
                gemsetChangedFuture.complete(true);
            }
        });
        LOG.info("Gem installation starting...");
        try {
            if (!RubyDebugIdeGemHelper.installDebuggerGems(module, sdk, installDir, forceInstall).booleanValue()) {
                RubyDebugGemInstallationCollectorKt.logDebugGemsInstallationState(InstallationState.FAIL);
                throw new com.intellij.execution.ExecutionException(RBundle.message((String)"gems.debugger.installation.failed"));
            }
        }
        catch (BundledGemsNotFoundException e) {
            RubyDebugGemInstallationCollectorKt.logDebugGemsInstallationState(InstallationState.BUNDLED_GEMS_MISSING);
            throw new com.intellij.execution.ExecutionException(e.getMessage());
        }
        catch (TimeoutException e) {
            RubyDebugGemInstallationCollectorKt.logDebugGemsInstallationState(InstallationState.TIMEOUT);
            throw new com.intellij.execution.ExecutionException(RBundle.message((String)"gems.debugger.installation.timeout"));
        }
        RubyDebugIdeGemHelper.refreshSdkLibraries(sdk);
        LOG.info("Refreshed SDK libraries after debugger gem installation.");
        try {
            if (module == null) {
                gemsetChangedFuture.complete(true);
            }
            gemsetChangedFuture.get(Registry.intValue((String)MAX_TIME_TO_WAIT_VFS_AFTER_DEBUG_GEM_INSTALLED_KEY), TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new com.intellij.execution.ExecutionException(RBundle.message((String)"gems.debugger.installation.failed.to.detect.gems"));
        }
        finally {
            connection.disconnect();
        }
        RubyDebugGemInstallationCollectorKt.logDebugGemsInstallationState(InstallationState.SUCCESS);
        LOG.debug("Gem installation succeeded. Starting the debugger...");
        MyDebuggerGemsStatus statusAfterInstallation = MyDebuggerGemsStatus.from(module, sdk);
        GemInfo installedFrontEndGem = statusAfterInstallation.getFrontEndGemType().findGem(module, sdk);
        return installedFrontEndGem != null ? statusAfterInstallation.getBackEndGemType() : null;
    }

    public static boolean isAllDebuggerGemsInstalledAndUpToDate(@Nullable Module module, @NotNull Sdk sdk) {
        MyDebuggerGemsStatus status;
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(55);
        }
        return (status = MyDebuggerGemsStatus.from(module, sdk)).isAllGemsInstalled() && status.isAllGemsUpToDate();
    }

    @Nullable
    private static GemInfo findGemByVersionPattern(@NotNull String gemName, @Nullable Module module, @NotNull Sdk sdk, @NotNull Pattern pattern) {
        if (gemName == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(56);
        }
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(57);
        }
        if (pattern == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(58);
        }
        return RubyGemSearchUtil.findGem(module, sdk, (GemInfo it) -> it.getName().equals(gemName) && pattern.matcher(it.getVersion()).matches());
    }

    private static boolean shouldInstallBundledDebug(String systemName) {
        return systemName != null && systemName.contains("i386") && (RubySdkUtil.isMswin32(systemName) || RubySdkUtil.isMingw32(systemName));
    }

    @Nullable
    public static State createState(@Nullable Module module, @NotNull Sdk sdk, @NotNull RubyDebugMode mode, @Nullable BackendDebugGemType backendDebugGemType) throws com.intellij.execution.ExecutionException {
        VirtualFile lineCacheLib;
        String linecacheGemName;
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(59);
        }
        if (mode == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(60);
        }
        if (backendDebugGemType == null) {
            LOG.warn("Backend debug gem type is not specified for " + String.valueOf(module) + " sdk " + String.valueOf(sdk));
            return null;
        }
        FrontendDebugGemType frontendDebugGemType = backendDebugGemType.getFrontendDebugGemType();
        GemInfo frontendGemInfo = frontendDebugGemType.findGem(module, sdk);
        if (frontendGemInfo == null || !frontendGemInfo.isValid()) {
            LOG.warn("Unable to find frontend gem " + String.valueOf(frontendDebugGemType) + "; module: " + String.valueOf(module) + "; sdk: " + String.valueOf(sdk));
            return null;
        }
        GemInfo backEndGemInfo = backendDebugGemType.findGem(module, sdk);
        if (backEndGemInfo == null || !backEndGemInfo.isValid()) {
            LOG.warn("Unable to find backend gem " + String.valueOf(backendDebugGemType));
            return null;
        }
        boolean isDebaseEnabled = RubyDebugIdeGemHelper.isDebaseEnabled(sdk);
        boolean isLineCacheRequired = RubyDebugIdeGemHelper.isLineCacheNeeded(sdk, backEndGemInfo);
        GemInfo linecacheInfo = null;
        if (isLineCacheRequired && ((linecacheInfo = RubyGemSearchUtil.findGem(module, sdk, linecacheGemName = RubySdkUtil.isRuby19(sdk) && !JRubySdkUtil.isJRubySDK(sdk) ? "linecache19" : "linecache")) == null || !linecacheInfo.isValid())) {
            String exceptionMessage = RBundle.message((String)"ruby.debugger.cannot.start.debug", (Object[])new Object[]{RBundle.message((String)"ruby.debugger.cannot.find.gem", (Object[])new Object[]{linecacheGemName})});
            throw new com.intellij.execution.ExecutionException(exceptionMessage);
        }
        GemInfo defaultDebugGem = module != null ? RubyProjectGemSearchService.Companion.findGem(module, DEFAULT_DEBUG_GEM_NAME) : null;
        LOG.debug("Default debug gem ", new Object[]{defaultDebugGem, " found for the module: ", module});
        boolean shouldDisableDefaultDebugGem = defaultDebugGem != null && VersionComparatorUtil.compare((String)defaultDebugGem.getVersion(), (String)MIN_VERSION_DISABLE_DEFAULT_DEBUG_GEM) >= 0;
        VirtualFile gemDir = frontendGemInfo.getFile();
        assert (gemDir != null);
        String scriptPath = GemUtil.findScriptInBinDir(mode.getDebugScript(), gemDir.findChild("bin"));
        VirtualFile frontEndSpec = frontendGemInfo.getSpecFile();
        VirtualFile backEndSpec = backEndGemInfo.getSpecFile();
        VirtualFile virtualFile = lineCacheLib = linecacheInfo != null ? linecacheInfo.getLibFolder() : null;
        if (scriptPath == null || frontEndSpec == null || backEndSpec == null || isLineCacheRequired && lineCacheLib == null) {
            LOG.debug("One of requirements for state is not met: ", new Object[]{"scriptPath: ", scriptPath, "; frontEndSpec: ", frontEndSpec, "; backEndSpec: ", backEndSpec, "; lineCacheRequired: ", isLineCacheRequired, "; lineCacheLib: ", lineCacheLib, "; frontEndGem: ", frontendGemInfo, "; backEndGem: ", backEndGemInfo});
            return null;
        }
        return new State(isDebaseEnabled, isLineCacheRequired, shouldDisableDefaultDebugGem, scriptPath, frontendGemInfo, backEndGemInfo, lineCacheLib, frontendGemInfo, frontendDebugGemType.isAcceptsGemspecFile());
    }

    private static boolean isLineCacheNeeded(@NotNull Sdk sdk, @NotNull GemInfo baseInfo) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(61);
        }
        if (baseInfo == null) {
            RubyDebugIdeGemHelper.$$$reportNull$$$0(62);
        }
        String sdkVersion = sdk.getVersionString();
        if (RubySdkUtil.isRuby18(sdk) && sdkVersion != null && sdkVersion.contains("1.8.6")) {
            return false;
        }
        if (DEBASE_NAME.equals(baseInfo.getName())) {
            return false;
        }
        String requiredVersion = RDB19_NAME.equals(baseInfo.getName()) ? "0.11.30.pre10" : "0.10.5.rc9";
        return VersionComparatorUtil.compare((String)baseInfo.getVersion(), (String)requiredVersion) <= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 19, 28, 29, 42, 43, 44, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 41: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "askedProperty";
                break;
            }
            case 17: 
            case 19: 
            case 28: 
            case 29: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper";
                break;
            }
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogMessage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugBackendEndGemName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdebugScriptPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMsg";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findGem";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sdkEffectiveLanguageLevelGreaterThan22";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSdkEffectiveLanguageLevelGreaterThan";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sdkEffectiveLanguageLevelGreaterThan27";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sdkEffectiveLanguageLevelGreaterThan33";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDebase23Enabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDebase30Enabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDebaseEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDebase23Compatible";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDebase30Compatible";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sdkEffectiveLanguageLevelGreaterThan23";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkForGemPresence";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDialogMessage";
                break;
            }
            case 17: 
            case 19: 
            case 28: 
            case 29: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDebugBackendEndGemName";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "configureEnvironment";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "passGemspecFile";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "patchRubyLib";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "enableVerboseMode";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "enableKeyValuePresentation";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "enableSteppingOverIntoBlocks";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "disableIntHandler";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluationTimeout";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "enableEvaluationControl";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluationTimeLimit";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluationMemoryLimit";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setFullValueEvaluationTimeLimit";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setFulValueEvaluationMemoryLimit";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addGemSpecificArgs";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "supportsNonSuspendedFramesReading";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "debugConsoleSupported";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "askUserToInstallOrUpdateDebugGems";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "refreshSdkLibraries";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "copyGemsToRemoteInterpreters";
                break;
            }
            case 52: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getOrInstallDebugIdeGem";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "installDebuggerGems";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isAllDebuggerGemsInstalledAndUpToDate";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findGemByVersionPattern";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isLineCacheNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 19, 28, 29, 42, 43, 44, 45 -> new IllegalStateException(string);
        };
    }

    public static final class State {
        @NotNull
        private static final String MULTI_PROCESS_DEBUG_BOUND = "0.4.17.beta9";
        @NotNull
        private static final String TIMEOUT_BOUND = "0.4.23.beta2";
        @NotNull
        private static final String EVALUATION_CONTROL_BOUND = "0.6.1.beta9";
        @NotNull
        private static final String DEBUG_CONSOLE_BOUND = "0.4.23.beta2";
        @NotNull
        private static final String RM_PROTOCOL_EXTENSIONS_BOUND = "0.4.24.beta4";
        @NotNull
        private static final String CATCH_POINT_REMOVAL_BOUND = "0.5.0";
        @NotNull
        private static final String FILE_FILTER_BOUND = "0.6.0.pre1";
        @NotNull
        private static final String SMART_STEP_OVER_BOUND = "0.8.0.beta1";
        @NotNull
        private static final String KEY_VALUE_HASH_BOUND = "0.7.0.beta5";
        public final boolean myLineCacheNeeded;
        public final boolean myMultiProcessDebugSupported;
        public final boolean myTimeoutConfigurable;
        public final boolean myEvaluationControlConfigurable;
        public final boolean myDebugConsoleSupported;
        public final boolean myCatchPointRemovalSupported;
        public final boolean myLoadingFullValueSupported;
        public final boolean myTypeRenderersSupported;
        public final boolean myRmProtocolExtensionsSupported;
        public final boolean myFileFilterSupported;
        public final boolean mySmartSrepOverSupported;
        public final boolean myKeyValueHashAvailable;
        public final boolean myShouldDisableDefaultDebugGem;
        @NotNull
        public final String myRDebugScriptPath;
        @NotNull
        public final GemInfo myFrontEndGeminfo;
        @NotNull
        public final GemInfo myBackEndGemInfo;
        public final boolean myPassGemspecFile;
        @Nullable
        public final VirtualFile myLineCacheLib;

        private State(boolean isDebaseEnabled, boolean lineCacheNeeded, boolean shouldDisableDefaultDebugGem, @NotNull String rDebugScriptPath, @NotNull GemInfo frontEndGemInfo, @NotNull GemInfo backEndGemInfo, @Nullable VirtualFile lineCacheLib, @Nullable GemInfo gemInfo, boolean passGemspecFile) {
            if (rDebugScriptPath == null) {
                State.$$$reportNull$$$0(0);
            }
            if (frontEndGemInfo == null) {
                State.$$$reportNull$$$0(1);
            }
            if (backEndGemInfo == null) {
                State.$$$reportNull$$$0(2);
            }
            this.myLineCacheNeeded = lineCacheNeeded;
            if (gemInfo != null) {
                String gemVersion = gemInfo.getVersion();
                this.myMultiProcessDebugSupported = VersionComparatorUtil.compare((String)gemVersion, (String)MULTI_PROCESS_DEBUG_BOUND) > 0;
                this.myTimeoutConfigurable = VersionComparatorUtil.compare((String)gemVersion, (String)"0.4.23.beta2") >= 0;
                this.myEvaluationControlConfigurable = VersionComparatorUtil.compare((String)gemVersion, (String)EVALUATION_CONTROL_BOUND) >= 0;
                this.myDebugConsoleSupported = VersionComparatorUtil.compare((String)gemVersion, (String)"0.4.23.beta2") >= 0;
                this.myRmProtocolExtensionsSupported = VersionComparatorUtil.compare((String)gemVersion, (String)RM_PROTOCOL_EXTENSIONS_BOUND) >= 0;
                this.myCatchPointRemovalSupported = VersionComparatorUtil.compare((String)gemVersion, (String)CATCH_POINT_REMOVAL_BOUND) >= 0;
                this.myLoadingFullValueSupported = isDebaseEnabled;
                this.myTypeRenderersSupported = isDebaseEnabled;
                this.myFileFilterSupported = VersionComparatorUtil.compare((String)gemVersion, (String)FILE_FILTER_BOUND) >= 0;
                this.mySmartSrepOverSupported = VersionComparatorUtil.compare((String)gemVersion, (String)SMART_STEP_OVER_BOUND) >= 0;
                this.myKeyValueHashAvailable = VersionComparatorUtil.compare((String)gemVersion, (String)KEY_VALUE_HASH_BOUND) >= 0;
            } else {
                this.myMultiProcessDebugSupported = false;
                this.myTimeoutConfigurable = false;
                this.myEvaluationControlConfigurable = false;
                this.myDebugConsoleSupported = false;
                this.myRmProtocolExtensionsSupported = false;
                this.myCatchPointRemovalSupported = false;
                this.myLoadingFullValueSupported = false;
                this.myTypeRenderersSupported = false;
                this.myFileFilterSupported = false;
                this.mySmartSrepOverSupported = false;
                this.myKeyValueHashAvailable = false;
            }
            this.myShouldDisableDefaultDebugGem = shouldDisableDefaultDebugGem;
            this.myRDebugScriptPath = rDebugScriptPath;
            this.myFrontEndGeminfo = frontEndGemInfo;
            this.myBackEndGemInfo = backEndGemInfo;
            this.myLineCacheLib = lineCacheLib;
            this.myPassGemspecFile = passGemspecFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rDebugScriptPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "frontEndGemInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "backEndGemInfo";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$State";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum BackendDebugGemType implements DebugGemType
    {
        RDB18("ruby-debug-base", "0.10.5.rc10", FrontendDebugGemType.RDI_OSS, ANY_VERSION_PATTERN, RDB_GEM_NAME_PATTERN, new String[0]),
        RDB18_WIN("ruby-debug-base", "0.10.5.rc10", FrontendDebugGemType.RDI_OSS, ANY_VERSION_PATTERN, RDB_WIN_GEM_NAME_PATTERN, "linecache"),
        RDB19("ruby-debug-base19x", "0.11.32", FrontendDebugGemType.RDI_OSS, ANY_VERSION_PATTERN, RDB19_GEM_NAME_PATTERN, new String[0]),
        DEBASE_OSS("debase", "0.2.9", FrontendDebugGemType.RDI_OSS, DEBASE_OSS_VERSION_PATTERN, DEBASE_OSS_GEM_PATTERN, new String[0]),
        DEBASE_JB("debase", "2.3.16", FrontendDebugGemType.RDI_JB, DEBASE_JB_VERSION_PATTERN, DEBASE_JB_GEM_PATTERN, new String[0]),
        RDB_JRUBY_OLD("ruby-debug-base", "0.10.6", FrontendDebugGemType.RDI_OSS, ANY_VERSION_PATTERN, RDB_JRUBY_GEM_OLD_PATTERN, "rake"),
        RDB_JRUBY_NEW("ruby-debug-base", "0.11.1", FrontendDebugGemType.RDI_OSS, ANY_VERSION_PATTERN, RDB_JRUBY_GEM_NEW_PATTERN, "rake"),
        DEBASE_JB_30("debase", "3.0.12", FrontendDebugGemType.RDI_JB_30, DEBASE_JB_30_VERSION_PATTERN, DEBASE_JB_30_GEM_PATTERN, new String[0]);

        @NotNull
        private final SimpleGemInfo myGemInfo;
        private final FrontendDebugGemType myFrontendDebugGemType;
        @NotNull
        private final Pattern myGemVersionPattern;
        @NotNull
        private final Pattern myGemPattern;
        @NotNull
        private final List<String> myDependencies;

        private BackendDebugGemType(@NotNull String name, @NotNull String version, @NotNull FrontendDebugGemType frontendDebugGemType, @NotNull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotNull @NotNull Pattern gemVersionPattern, Pattern gemPattern, String ... dependencies) {
            if (name == null) {
                BackendDebugGemType.$$$reportNull$$$0(0);
            }
            if (version == null) {
                BackendDebugGemType.$$$reportNull$$$0(1);
            }
            if (frontendDebugGemType == null) {
                BackendDebugGemType.$$$reportNull$$$0(2);
            }
            if (gemVersionPattern == null) {
                BackendDebugGemType.$$$reportNull$$$0(3);
            }
            if (gemPattern == null) {
                BackendDebugGemType.$$$reportNull$$$0(4);
            }
            if (dependencies == null) {
                BackendDebugGemType.$$$reportNull$$$0(5);
            }
            this.myGemInfo = new SimpleGemInfo(name, version);
            this.myFrontendDebugGemType = frontendDebugGemType;
            this.myGemVersionPattern = gemVersionPattern;
            this.myGemPattern = gemPattern;
            this.myDependencies = List.of(dependencies);
        }

        @NotNull
        public SimpleGemInfo getGemInfo() {
            SimpleGemInfo simpleGemInfo = this.myGemInfo;
            if (simpleGemInfo == null) {
                BackendDebugGemType.$$$reportNull$$$0(6);
            }
            return simpleGemInfo;
        }

        @NotNull
        FrontendDebugGemType getFrontendDebugGemType() {
            FrontendDebugGemType frontendDebugGemType = this.myFrontendDebugGemType;
            if (frontendDebugGemType == null) {
                BackendDebugGemType.$$$reportNull$$$0(7);
            }
            return frontendDebugGemType;
        }

        @NotNull
        Pattern getGemVersionPattern() {
            Pattern pattern = this.myGemVersionPattern;
            if (pattern == null) {
                BackendDebugGemType.$$$reportNull$$$0(8);
            }
            return pattern;
        }

        @NotNull
        Pattern getGemPattern() {
            Pattern pattern = this.myGemPattern;
            if (pattern == null) {
                BackendDebugGemType.$$$reportNull$$$0(9);
            }
            return pattern;
        }

        @NotNull
        List<String> getDependencies() {
            List<String> list = this.myDependencies;
            if (list == null) {
                BackendDebugGemType.$$$reportNull$$$0(10);
            }
            return list;
        }

        @Contract(value="null -> false")
        boolean isUpToDate(@Nullable GemInfo gemInfo) {
            return this.getGemInfo().isUpToDateGem(gemInfo);
        }

        @Override
        @Nullable
        public GemInfo findGem(@Nullable Module module, @NotNull Sdk sdk) {
            if (sdk == null) {
                BackendDebugGemType.$$$reportNull$$$0(11);
            }
            return RubyDebugIdeGemHelper.DEBASE_NAME.equals(this.getGemInfo().getGemName()) ? RubyDebugIdeGemHelper.findGemByVersionPattern(this.getGemInfo().getGemName(), module, sdk, this.getGemVersionPattern()) : RubyDebugIdeGemHelper.findGem(this.getGemInfo().getGemName(), module, sdk);
        }

        public static BackendDebugGemType getBaseType(@NotNull Sdk sdk, boolean suppressProprietary) {
            if (sdk == null) {
                BackendDebugGemType.$$$reportNull$$$0(12);
            }
            if (RubySdkUtil.isRubinius(sdk)) {
                return DEBASE_OSS;
            }
            if (JRubySdkUtil.isJRubySDK(sdk)) {
                return RubyDebugIdeGemHelper.sdkEffectiveLanguageLevelGreaterThan23(sdk) ? RDB_JRUBY_NEW : RDB_JRUBY_OLD;
            }
            if (!suppressProprietary && RubyDebugIdeGemHelper.isDebase30Enabled(sdk)) {
                return DEBASE_JB_30;
            }
            if (!suppressProprietary && RubyDebugIdeGemHelper.isDebase23Enabled(sdk)) {
                return DEBASE_JB;
            }
            if (LanguageLevel.RUBY19.isLessThan(RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk))) {
                return DEBASE_OSS;
            }
            if (RubySdkUtil.isRuby19(sdk)) {
                return RDB19;
            }
            if (RubySdkSystemAccessor.notNullFrom(sdk).isWindows() && RubyDebugIdeGemHelper.shouldInstallBundledDebug(RubySdkType.getPlatform(sdk))) {
                return RDB18_WIN;
            }
            return RDB18;
        }

        @Override
        @NotNull
        public List<GemDependency> getGemsToInstall() throws com.intellij.execution.ExecutionException {
            List<GemDependency> gemsToInstall = GemInstallUtil.findBundledGemsToInstall(RBundle.message((String)"gems.bundled.debug.not.found"), this.getGemPattern());
            this.getDependencies().forEach(it -> gemsToInstall.addAll(0, GemDependency.anyAsList(it)));
            List<GemDependency> list = gemsToInstall;
            if (list == null) {
                BackendDebugGemType.$$$reportNull$$$0(13);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9, 10, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frontendDebugGemType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemVersionPattern";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemPattern";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$BackendDebugGemType";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$BackendDebugGemType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemInfo";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrontendDebugGemType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemVersionPattern";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemPattern";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemsToInstall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findGem";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getBaseType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 9, 10, 13 -> new IllegalStateException(string);
            };
        }
    }

    private static class SimpleGemInfo {
        @NotNull
        private final String myGemName;
        @NotNull
        private final String myGemVersion;

        private SimpleGemInfo(@NotNull String gemName, @NotNull String gemVersion) {
            if (gemName == null) {
                SimpleGemInfo.$$$reportNull$$$0(0);
            }
            if (gemVersion == null) {
                SimpleGemInfo.$$$reportNull$$$0(1);
            }
            this.myGemName = gemName;
            this.myGemVersion = gemVersion;
        }

        @NotNull
        private String getGemName() {
            String string = this.myGemName;
            if (string == null) {
                SimpleGemInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private String getGemVersion() {
            String string = this.myGemVersion;
            if (string == null) {
                SimpleGemInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleGemInfo)) {
                return false;
            }
            SimpleGemInfo info = (SimpleGemInfo)o;
            if (!this.myGemName.equals(info.myGemName)) {
                return false;
            }
            return this.myGemVersion.equals(info.myGemVersion);
        }

        @Contract(value="null -> false")
        public boolean isUpToDateGem(@Nullable GemInfo gem) {
            if (gem == null) {
                return false;
            }
            String version = gem.getVersion();
            LOG.info("Currently installed: " + gem.getName() + "(" + version + ") at " + gem.getUrl());
            LOG.info("Bundled: " + this.getGemName() + "(" + this.getGemVersion() + ")");
            return VersionComparatorUtil.compare((String)version, (String)this.getGemVersion()) >= 0;
        }

        public int hashCode() {
            int result = this.myGemName.hashCode();
            result = 31 * result + this.myGemVersion.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemVersion";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$SimpleGemInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$SimpleGemInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyDebuggerGemsStatus {
        final BackendDebugGemType myBackEndGemType;
        @Nullable
        final GemInfo myBackendGem;
        final boolean myIsBackendGemUpToDate;
        final FrontendDebugGemType myFrontEndGemType;
        @Nullable
        final GemInfo myFrontEndGem;
        final boolean myIsFrontendGemUpToDate;

        private MyDebuggerGemsStatus(@NotNull BackendDebugGemType backEndGemType, @Nullable GemInfo backEndGem, boolean isBackendGemUpToDate, @NotNull FrontendDebugGemType frontEndGemType, @Nullable GemInfo frontEndGem, boolean isFrontEndGemUpToDate) {
            if (backEndGemType == null) {
                MyDebuggerGemsStatus.$$$reportNull$$$0(0);
            }
            if (frontEndGemType == null) {
                MyDebuggerGemsStatus.$$$reportNull$$$0(1);
            }
            this.myFrontEndGemType = frontEndGemType;
            this.myFrontEndGem = frontEndGem;
            this.myIsFrontendGemUpToDate = isFrontEndGemUpToDate;
            this.myBackEndGemType = backEndGemType;
            this.myBackendGem = backEndGem;
            this.myIsBackendGemUpToDate = isBackendGemUpToDate;
        }

        static MyDebuggerGemsStatus from(@Nullable Module module, @NotNull Sdk sdk) {
            if (sdk == null) {
                MyDebuggerGemsStatus.$$$reportNull$$$0(2);
            }
            BackendDebugGemType backEndGemType = BackendDebugGemType.getBaseType(sdk, false);
            GemInfo backendGem = backEndGemType.findGem(module, sdk);
            boolean isBackendGemUpToDate = backEndGemType.isUpToDate(backendGem);
            FrontendDebugGemType frontEndGemType = backEndGemType.getFrontendDebugGemType();
            GemInfo frontEndGem = frontEndGemType.findGem(module, sdk);
            boolean isFrontEndGemUpToDate = frontEndGemType.isUpToDate(frontEndGem);
            return new MyDebuggerGemsStatus(backEndGemType, backendGem, isBackendGemUpToDate, frontEndGemType, frontEndGem, isFrontEndGemUpToDate);
        }

        @NotNull
        BackendDebugGemType getBackEndGemType() {
            BackendDebugGemType backendDebugGemType = this.myBackEndGemType;
            if (backendDebugGemType == null) {
                MyDebuggerGemsStatus.$$$reportNull$$$0(3);
            }
            return backendDebugGemType;
        }

        @NotNull
        FrontendDebugGemType getFrontEndGemType() {
            FrontendDebugGemType frontendDebugGemType = this.myFrontEndGemType;
            if (frontendDebugGemType == null) {
                MyDebuggerGemsStatus.$$$reportNull$$$0(4);
            }
            return frontendDebugGemType;
        }

        boolean isAllGemsInstalled() {
            return this.myBackendGem != null && this.myFrontEndGem != null;
        }

        boolean isAllGemsUpToDate() {
            return this.myIsBackendGemUpToDate && this.myIsFrontendGemUpToDate;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "backEndGemType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frontEndGemType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$MyDebuggerGemsStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$MyDebuggerGemsStatus";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBackEndGemType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrontEndGemType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    static enum FrontendDebugGemType implements DebugGemType
    {
        RDI_OSS("ruby-debug-ide", "0.7.5", RDI_OSS_VERSION_PATTERN, RDI_OSS_GEM_PATTERN, false),
        RDI_JB("ruby-debug-ide", "2.3.26", RDI_JB_VERSION_PATTERN, RDI_JB_GEM_PATTERN, true),
        RDI_JB_30("ruby-debug-ide", "3.0.12", RDI_JB_30_VERSION_PATTERN, RDI_JB_30_GEM_PATTERN, true);

        @NotNull
        private final SimpleGemInfo myGemInfo;
        @NotNull
        private final Pattern myGemVersionPattern;
        @NotNull
        private final Pattern myGemPattern;
        private final boolean myAcceptsGemspecFile;

        private FrontendDebugGemType(@NotNull String name, @NotNull String version, Pattern gemVersionPattern, Pattern gemPattern, boolean acceptsGemspecFile) {
            if (name == null) {
                FrontendDebugGemType.$$$reportNull$$$0(0);
            }
            if (version == null) {
                FrontendDebugGemType.$$$reportNull$$$0(1);
            }
            if (gemVersionPattern == null) {
                FrontendDebugGemType.$$$reportNull$$$0(2);
            }
            if (gemPattern == null) {
                FrontendDebugGemType.$$$reportNull$$$0(3);
            }
            this.myGemInfo = new SimpleGemInfo(name, version);
            this.myGemVersionPattern = gemVersionPattern;
            this.myGemPattern = gemPattern;
            this.myAcceptsGemspecFile = acceptsGemspecFile;
        }

        public boolean isAcceptsGemspecFile() {
            return this.myAcceptsGemspecFile;
        }

        @NotNull
        public SimpleGemInfo getGemInfo() {
            SimpleGemInfo simpleGemInfo = this.myGemInfo;
            if (simpleGemInfo == null) {
                FrontendDebugGemType.$$$reportNull$$$0(4);
            }
            return simpleGemInfo;
        }

        @NotNull
        Pattern getGemVersionPattern() {
            Pattern pattern = this.myGemVersionPattern;
            if (pattern == null) {
                FrontendDebugGemType.$$$reportNull$$$0(5);
            }
            return pattern;
        }

        @Contract(value="null -> false")
        boolean isUpToDate(@Nullable GemInfo gemInfo) {
            return this.getGemInfo().isUpToDateGem(gemInfo);
        }

        @Override
        @Nullable
        public GemInfo findGem(@Nullable Module module, @NotNull Sdk sdk) {
            if (sdk == null) {
                FrontendDebugGemType.$$$reportNull$$$0(6);
            }
            return RubyDebugIdeGemHelper.findGemByVersionPattern(this.getGemInfo().getGemName(), module, sdk, this.getGemVersionPattern());
        }

        @NotNull
        Pattern getGemPattern() {
            Pattern pattern = this.myGemPattern;
            if (pattern == null) {
                FrontendDebugGemType.$$$reportNull$$$0(7);
            }
            return pattern;
        }

        @Override
        @NotNull
        public List<GemDependency> getGemsToInstall() throws com.intellij.execution.ExecutionException {
            List<GemDependency> list = GemInstallUtil.findBundledGemsToInstall(RBundle.message((String)"gems.bundled.debug.not.found"), this.getGemPattern());
            if (list == null) {
                FrontendDebugGemType.$$$reportNull$$$0(8);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemVersionPattern";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemPattern";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$FrontendDebugGemType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$FrontendDebugGemType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemVersionPattern";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemPattern";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemsToInstall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findGem";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static interface DebugGemType {
        @Nullable
        public GemInfo findGem(@Nullable Module var1, @NotNull Sdk var2);

        @NotNull
        public List<GemDependency> getGemsToInstall() throws com.intellij.execution.ExecutionException;
    }

    public static final class BundledGemsNotFoundException
    extends Exception {
        public BundledGemsNotFoundException(String message) {
            super(message);
        }
    }

    public static final class DebugGemInstallationCancelledException
    extends com.intellij.execution.ExecutionException {
        public DebugGemInstallationCancelledException() {
            super("");
        }
    }
}

